% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interpolate_mmhp_latent.R
\name{interpolate_mmhp_latent}
\alias{interpolate_mmhp_latent}
\title{Interpolate latent process of MMHP}
\usage{
interpolate_mmhp_latent(params, events, zt)
}
\arguments{
\item{params}{parameters of the MMHP, an MMHP object}

\item{events}{events (not including 0, but assumes start at 0)}

\item{zt}{inferred latent state of events}
}
\value{
list of the states of the Markov process (z.hat), including
initial state
and the times of the transitions between these times (x.hat).
}
\description{
Interpolate latent process of MMHP
}
\examples{
Q <- matrix(c(-0.4, 0.4, 0.2, -0.2), ncol = 2, byrow = TRUE)
mmhp_obj <- pp_mmhp(Q,
  delta = c(1 / 3, 2 / 3), lambda0 = 0.9, lambda1 = 1.1,
  alpha = 0.8, beta = 1.2
)
ppdiag:::interpolate_mmhp_latent(
  params = mmhp_obj,
  events = c(1, 2, 3, 5), zt = c(2, 1, 1, 2)
)
}
\keyword{internal}
