% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drawHPPIntensity.R
\name{drawHPPIntensity}
\alias{drawHPPIntensity}
\title{Draw intensity of homogeneous Poisson process}
\usage{
drawHPPIntensity(
  hpp = NULL,
  events,
  int_title = "Homogeneous Poisson Process",
  start = 0,
  end = max(events),
  color = "red",
  plot_events = TRUE,
  fit = FALSE,
  add = FALSE,
  verbose = FALSE
)
}
\arguments{
\item{hpp}{object for homogeneous Poisson process}

\item{events}{event times input}

\item{int_title}{the plot title}

\item{start}{start of events}

\item{end}{end of events}

\item{color}{a specification for the default plotting color.}

\item{plot_events}{a boolean indicating whether input events will be plotted}

\item{fit}{a boolean indicating whether to fit a hpp or
use the passed object}

\item{add}{whether to add the hpp intensity to an existing plot}

\item{verbose}{whether to output informative messages as running}
}
\value{
no return value, intensity plot of homogeneous Poisson process
}
\description{
Draw the intensity for a homogeneous Poisson process
}
\examples{
pois_y <- pp_hpp(lambda = 1)
drawHPPIntensity(pois_y, events = pp_simulate(pois_y, end = 10))
}
