% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/computePower.R
\name{computePower}
\alias{computePower}
\title{Power estimation}
\usage{
computePower(X, Y, A, n, seed = 123,
Nsim = 100, nperm = 200, alpha = 0.05,
scaling = 'auto-scaling', test = 'R2',
Y.prob = FALSE, eps = 0.01, post.transformation = TRUE,
fast = FALSE, transformation = 'clr', ncores = NULL)
}
\arguments{
\item{X}{Data matrix where columns represent the \eqn{p} variables and
rows the \eqn{n} observations.}

\item{Y}{Data matrix where columns represent the two classes and
rows the \eqn{n} observations.}

\item{A}{Number of score components}

\item{n}{Sample size}

\item{seed}{Seed value}

\item{Nsim}{Number of simulations}

\item{nperm}{Number of permutations}

\item{alpha}{Type I error level}

\item{scaling}{Type of scaling, one of
\code{c('auto-scaling', 'pareto-scaling', 'mean-centering')}. Default to 'auto-scaling'}

\item{test}{Type of test statistic, one of \code{c('score', 'mcc', 'R2')}. Default to 'R2'.}

\item{Y.prob}{Boolean value. Default \code{FALSE}. IF \code{TRUE} \code{Y} is a probability vector}

\item{eps}{Default 0.01. \code{eps} is used when \code{Y.prob = FALSE} to transform \code{Y} in a probability vector.}

\item{post.transformation}{Boolean value. \code{TRUE} if you want to apply post transformation. Default to \code{TRUE}}

\item{fast}{Use the function \code{fk_density} from the \code{FKSUM} \code{R} package for kernel density estimation. Default to \code{FALSE}.}

\item{transformation}{Transformation used to map \code{Y} in probability data vector. The options are 'ilr' and 'clr'.}

\item{ncores}{Number of cores, default NULL.}
}
\value{
Returns a matrix of estimated power for each number of components and tests selected.
}
\description{
Estimates power for a given sample size, type I error level and number
of score components.
}
\examples{
\dontrun{
datas <- simulatePilotData(nvar = 10, clus.size = c(5,5),m = 6,nvar_rel = 5,A = 2)
out <- computePower(X = datas$X, Y = datas$Y, A = 3, n = 20, test = 'R2')
}
}
\references{
For the general framework of power analysis for PLS-based methods see:

Andreella, A., Fino, L., Scarpa, B., & Stocchero, M. (2024). Towards a power analysis for PLS-based methods. arXiv preprint \url{https://arxiv.org/abs/2403.10289}.
}
\author{
Angela Andreella
}
