% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PLSc.R
\name{PLSc}
\alias{PLSc}
\title{PLS classification}
\usage{
PLSc(X, Y, A, scaling = 'auto-scaling', post.transformation = TRUE,
eps = 0.01, Y.prob = FALSE, transformation = 'ilr')
}
\arguments{
\item{X}{Data matrix where columns represent the \eqn{p} variables and
rows the \eqn{n} observations.}

\item{Y}{Data matrix where columns represent the two classes and
rows the \eqn{n} observations.}

\item{A}{Number of score components}

\item{scaling}{Type of scaling, one of
\code{c('auto-scaling', 'pareto-scaling', 'mean-centering')}. Default to 'auto-scaling'}

\item{post.transformation}{Boolean value. \code{TRUE} if you want to apply post transformation. Default \code{TRUE}}

\item{eps}{Default 0.01. \code{eps} is used when \code{Y.prob = FALSE} to transform \code{Y} in a probability vector}

\item{Y.prob}{Boolean value. Default \code{FALSE}. IF \code{TRUE} \code{Y} is a probability vector}

\item{transformation}{Transformation used to map \code{Y} in probability data vector. The options are 'ilr' and 'clr'.
Default @ilr.}
}
\value{
List with the following objects:
\describe{
  \item{W}{Matrix of weights}
  \item{X_loading}{Matrix of \code{X} loading}
  \item{Y_loading}{Matrix of \code{Y} loading}
  \item{X}{Matrix of \code{X} data (predictor variables)}
  \item{Y}{Matrix of \code{Y} data (dependent variable)}
  \item{T_score}{Matrix of scores}
  \item{Y_fitted}{Fitted \code{Y} matrix}
  \item{B}{Matrix regression coefficients}
  \item{M}{Number of orthogonal components if \code{post.transformation=TRUE} is applied.}
  }
}
\description{
Performs Partial Least Squares classification
}
\examples{
datas <- simulatePilotData(nvar = 30, clus.size = c(5,5),m = 6,nvar_rel = 5,A = 2)
out <- PLSc(X = datas$X, Y = datas$Y, A = 3)

}
\references{
Stocchero, M., De Nardi, M., & Scarpa, B. (2021). PLS for classification. Chemometrics and Intelligent Laboratory Systems, 216, 104374.
}
\author{
Angela Andreella
}
