% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dprgumbel.R, R/pprgumbel.R, R/qprgumbel.R,
%   R/rprgumbel.R
\name{PowerReversalGumbel}
\alias{PowerReversalGumbel}
\alias{dprgumbel}
\alias{PowerReversalGumbel}
\alias{pprgumbel}
\alias{PowerReversalGumbel}
\alias{qprgumbel}
\alias{PowerReversalGumbel}
\alias{rprgumbel}
\title{The Power Reversal-Gumbel Distribution}
\usage{
dprgumbel(x, lambda = 1, mu = 0, sigma = 1, log = FALSE)

pprgumbel(q, lambda = 1, mu = 0, sigma = 1, lower.tail = TRUE,
  log.p = FALSE)

qprgumbel(p, lambda = 1, mu = 0, sigma = 1, lower.tail = TRUE,
  log.p = FALSE)

rprgumbel(n, lambda = 1, mu = 0, sigma = 1)
}
\arguments{
\item{x, q}{vector of quantiles.}

\item{lambda}{shape parameter.}

\item{mu, sigma}{location and scale parameters.}

\item{log, log.p}{logical; if TRUE, probabilities p are given as log(p).}

\item{lower.tail}{logical; if TRUE (default), probabilities are \eqn{P[X \le x ]}, otherwise, P[X > x].}

\item{p}{vector of probabilities.}

\item{n}{number of observations.}
}
\description{
Density, distribution function,
quantile function and random generation for
the power Reversal-Gumbel distribution with parameters mu, sigma and lambda.
}
\details{
The power reverlsa-Gumbel distribution has density

\eqn{f(x)=\lambda \left[1-e^{-e^{\left(\frac{x-\mu}{\sigma}\right)}}\right]^{\lambda-1}\left[\frac{1}{\sigma}e^{\left(\frac{x-\mu}{\sigma}\right)-e^{\left(\frac{x-\mu}{\sigma}\right)}} \right]}{f(x)=[\lambda/\sigma][exp(-(x-\mu)/\sigma-exp(-(x-\mu)/\sigma))][exp(-exp(-(x-\mu)/\sigma))]^(\lambda-1)},

where \eqn{-\infty<\mu<\infty} is the location paramether, \eqn{\sigma^2>0} the scale parameter and \eqn{\lambda>0} the shape parameter.
}
\examples{
dprgumbel(1, 1, 3, 4)
pprgumbel(1, 1, 3, 4)
qprgumbel(0.2, 1, 3, 4)
rprgumbel(5, 2, 3, 4)
}
\references{
Abanto -Valle, C. A., Bazán, J. L. and Smith, A. C. (2014) \emph{State space mixed models for binary responses with skewed inverse links using JAGS}. Rio de Janeiro, Brazil.

Anyosa, S. A. C. (2017) \emph{Binary regression using power and reversal power links}. Master's thesis in Portuguese. Interinstitutional Graduate Program in Statistics. Universidade de São Paulo - Universidade Federal de São Carlos. Available in \url{https://repositorio.ufscar.br/handle/ufscar/9016}.

Bazán, J. L., Torres -Avilés, F., Suzuki, A. K. and Louzada, F. (2017) Power and reversal power links for binary regressions: An application for motor insurance policyholders. \emph{Applied Stochastic Models in Business and Industry}, \strong{33}(1), 22-34.
}
