% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drain.R
\name{drain}
\alias{drain}
\alias{drain_package}
\alias{drain_interactive}
\title{Clear package options}
\usage{
drain(.slot, .pkg)

drain_package(.pkg)

drain_interactive(.slot)
}
\arguments{
\item{.slot}{(optional) slot to clear from \code{options()}}

\item{.pkg}{(optional) package to clear from \code{options()}}
}
\value{
This function never returns an object; it is called for its' side-
effect of removing data from \code{options()}.
}
\description{
Clear options of previously specified content. In most cases, calling \code{drain}
with no arguments will be sufficient, but the arguments \code{.slot} and \code{.pkg},
and their corresponding functions \code{drain_interactive()} and \code{drain_package()}
are provided in case greater control is needed. This is rarely needed for
packages, but it is possible to manually specify the use of multiple slots
when using \code{potions::brew()} interactively.
}
\details{
Note that this function is not vectorized, so passing multiple
values to \code{.slot} or \code{.pkg} will fail (e.g. \code{drain(.slot = c("x", "y"))}).
Similarly, passing arguments to both \code{.slot} and \code{.pkg} will fail.
}
