% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{tortoise}
\alias{tortoise}
\title{Projection matrices for desert tortoise}
\format{
A list of 4 matrices
}
\source{
Table 5 in Doak et al (1994).  Used by Caswell (2001) in chapter 9 on
sensitivity analysis.
}
\usage{
tortoise
}
\description{
Projection matrices for the desert tortoise \emph{Gopherus agassizii} with 4
different fertility estimates (low, medium low, medium high, and high)
}
\examples{
tortoise
A <- tortoise[["med.high"]]
# log color scale not needed
image2(A, mar = c(1, 3.5, 5, 1), log = FALSE, box.off = .1)
title("Tortoise projection matrix", line = 3)
splitA(A)
lambda(A)
sapply(tortoise, lambda)
}
\references{
Morris, W. F., and D. F. Doak. 2002. Quantitative conservation
biology: Theory and practice of population viability analysis. Sinauer,
Sunderland, Massachusetts, USA.
}
\keyword{datasets}
