% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sliding.windows.fstat.R
\name{sliding.windows.fstat}
\alias{sliding.windows.fstat}
\title{Compute sliding window estimates of F-statistics or ratio of F-statistics over the genome}
\usage{
sliding.windows.fstat(
  x,
  num.pop.idx = NULL,
  den.pop.idx = NULL,
  num.stat = NULL,
  den.stat = NULL,
  window.def = c("nsnp", "bp")[1],
  sliding.window.size = NULL,
  window.overlap.fact = 0.5,
  bp.start.first.snp = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{x}{A pooldata object containing Pool-Seq information or a countdata object containing allele count information}

\item{num.pop.idx}{A vector of length 1 to 4 (depending on num.stat) giving the index (or names) of the populations samples. If num.stat="het", num.pop.idx must be of length 1: num.pop.idx=i specifies the ith pop in x. If num.stat="div", "F2" or "Fst", num.pop.idx must be of length 2: num.pop.idx=c(i,j) specifies the pairs of populations with indexes i and j in x. If num.stat="F3" or "F3star", num.pop.idx must be of length 3 (num.pop.idx=c(i,j,k) specifies the F3(pop_i;pop_j,pop_k) populations triplet). Finally, if num.stat="F4" or "Dstat", num.pop.idx must be of length 4: num.pop.idx=c(i,j,k) specifies the F4(pop_i,pop_j;pop_k,pop_l) populations quadruplet i.e. the computed (numerator) statistic computed is (F2(pop_i,pop_k)-F2(pop_i,pop_l)-F2(pop_j,pop_k)+F2(pop_j,pop_l))/2.}

\item{den.pop.idx}{A vector of length 1 to 4 (see num.pop.idx description) giving the index of the populations specifying the F-statistic. If NULL, the computed statistic is the one specified by num.pop.idx.}

\item{num.stat}{the name of the (numerator) stat which must be "het" (1-Q1), "div" (1-Q2), "F2", "Fst", "F3", "F3star", "F4", "Dstat", "Fh", "Fd", or "FdM"}

\item{den.stat}{the name of the (numerator) stat which must be "het" (1-Q1), "div" (1-Q2), "F2", "Fst", "F3", "F3star", "F4", "Dstat", "Fh", "Fd", or "FdM"}

\item{window.def}{Either "nsnp" or "bp" to define windows by either a number of SNPs or a size in bp, respectively}

\item{sliding.window.size}{A numeric value giving the number of SNPs or the size (in bp) of the windows depending window.def}

\item{window.overlap.fact}{A numeric value (between 0 and 1) giving the percentage of overlap between consecutive windows (default=0.5)}

\item{bp.start.first.snp}{When window.def="bp", if TRUE (default) the windowing start at the first SNP position, if FALSE the windowing start at position 1}

\item{verbose}{If TRUE extra information is printed on the terminal}
}
\value{
A data frame with 7 columns with for each window in a row their i) chromosome/contig of origin; ii) start and iii) end position; iv) the mid-position of each window; v) the cumulated mid-position of each window (to facilitate further plotting); vi) the number of SNPs included in the computation of window value; and vii) the estimated value of the statistic
}
\description{
Compute sliding window estimates of F-statistics or ratio of F-statistics over the genome
}
\details{
Compute sliding window estimates of F-statistics or ratio of F-statistics over the genome.
}
\examples{
 make.example.files(writing.dir=tempdir())
 pooldata=popsync2pooldata(sync.file=paste0(tempdir(),"/ex.sync.gz"),poolsizes=rep(50,15))
}
\seealso{
To generate pooldata object, see \code{\link{vcf2pooldata}}, \code{\link{popsync2pooldata}},\code{\link{genobaypass2pooldata}} or \code{\link{genoselestim2pooldata}}. To generate coundata object, see \code{\link{genobaypass2countdata}} or \code{\link{genotreemix2countdata}}.
}
