% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{extract_vscan_counts}
\alias{extract_vscan_counts}
\alias{.extract_vscan_counts}
\title{extract_vscan_counts}
\usage{
.extract_vscan_counts(vcf_data, ad_idx, rd_idx)
}
\arguments{
\item{vcf_data}{a matrix of String containing count information in VarScan format}

\item{ad_idx}{the index of the FORMAT AD field}

\item{rd_idx}{the index of the FORMAT RD field}
}
\value{
A numeric matrix of read count with nsnp rows and 2*npools columns.
The first npools columns consist of read count for the reference allele (RD),
columns npools+1 to 2*npools consist of read coverage (RD+AD)
}
\description{
Extract VarScan counts
}
\details{
Extract VarScan counts and return read counts for the reference and alternate allele.
For VarScan generated vcf, SNPs with more than one alternate allele are discarded 
(because only a single count is then reported in the AD fields) making the min.rc unavailable (of vcf2pooldata).
The VarScan --min-reads2 option might replace to some extent the min.rc functionality although 
SNP where the two major alleles in the Pool-Seq data are different from the reference allele 
(e.g., expected to be more frequent when using a distantly related reference genome for mapping) 
will be disregarded.
}
\examples{
.extract_vscan_counts(rbind(c("0/0:0:20","1/1:18:1"),c("0/1:12:15","1/1:27:2")),3,2)

}
