% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lf_to_tdf.R
\name{clean_scores}
\alias{clean_scores}
\title{Clean Scores Data}
\usage{
clean_scores(
  scores_data,
  pattern1 = NULL,
  replacement1 = NULL,
  pattern2 = NULL,
  replacement2 = NULL,
  pattern3 = NULL,
  replacement3 = NULL
)
}
\arguments{
\item{scores_data}{The list containing the output scores data from the
score_markers_rev3.}

\item{pattern1}{The first pattern to replace in the ID.This is intended to
clean up the ID names for when the machine adds substrings to the names. For
example 104.1a_FA060920_2020-06-09_C05.fsa.1 becomes 104.1a using
pattern1="_FA.*" and replacement1= ""}

\item{replacement1}{Replacement for the first pattern.}

\item{pattern2}{The second pattern to replace in the ID. See pattern1 for
more details.}

\item{replacement2}{Replacement for the second pattern.}

\item{pattern3}{The pattern to replace in the file name.This is intended to
clean up the file names for when the machine adds sub strings to the names.
For example 104.1a_FA060920_2020-06-09_C05.fsa.1 becomes
104.1a_FA060920_2020-06-09_C05.fsa using pattern3= "\\.1*$" and
replacement3= ""}

\item{replacement3}{Replacement for the file name pattern.}
}
\value{
A cleaned long format data frame
}
\description{
This function cleans the score_markers_rev3 data by applying specified
patterns and replacements to the ID and filename columns.
}
\examples{
scores_data <- list(
data.frame(Score = c(90, 85, 70), stringsAsFactors = FALSE),
data.frame(Score = c(80, 75, 60), stringsAsFactors = FALSE)
)
rownames(scores_data[[1]]) <- c("104.1a_FA060920_2020-06-09_C05.fsa_Sa.1",
                                "105.2b_FA060920_2020-06-09_C05.fsa_Sa.1",
                                "106.3c_FA060920_2020-06-09_C05.fsa_Fa.1")
rownames(scores_data[[2]]) <- c("107.4d_FA060920_2020-06-09_C05.fsa_Sa.1",
                                "108.5e_FA060920_2020-06-09_C05.fsa_Sa.1",
                                "109.6f_SA060920_2020-06-09_C05.fsa_Fa.1")
clean_scores(scores_data,pattern1= "_SA.*", replacement1="",
pattern2= "_FA.*",replacement2="")

}
