% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Windy_gridworld.R
\docType{data}
\name{Windy_gridworld}
\alias{Windy_gridworld}
\alias{windy_gridworld}
\title{Windy Gridworld MDP}
\format{
An object of class \link{MDP}.
}
\description{
The Windy gridworld MDP example from Chapter 6 of the textbook
"Reinforcement Learning: An Introduction."
}
\details{
The gridworld has the following layout:

\figure{windy-gridworld.png}{Windy Gridworld.}

The grid world is represented as a 7 x 10 matrix of states.
In the middle region the next states are shifted upward by wind
(the strength in number of squares is given below each column).
For example, if the agent is one cell to the right of the goal,
then the action left takes the agent to the cell just above the goal.

No discounting is used (i.e., \eqn{\gamma = 1}).
}
\examples{
data(Windy_gridworld)
Windy_gridworld

gridworld_matrix(Windy_gridworld)
gridworld_matrix(Windy_gridworld, what = "labels")

# The Goal is an absorbing state 
which(absorbing_states(Windy_gridworld))

# visualize the transition graph
gridworld_plot_transition_graph(Windy_gridworld, 
  vertex.size = 10, vertex.label = NA)

# solve using value iteration
sol <- solve_MDP(Windy_gridworld) 
sol
policy(sol)
gridworld_plot_policy(sol)
}
\references{
Richard S. Sutton and Andrew G. Barto (2018). Reinforcement Learning: An Introduction
Second Edition, MIT Press, Cambridge, MA.
}
\seealso{
Other MDP_examples: 
\code{\link{Cliff_walking}},
\code{\link{DynaMaze}},
\code{\link{MDP}()},
\code{\link{Maze}}

Other gridworld: 
\code{\link{Cliff_walking}},
\code{\link{DynaMaze}},
\code{\link{Maze}},
\code{\link{gridworld}}
}
\concept{MDP_examples}
\concept{gridworld}
\keyword{datasets}
