% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ind_stdcontinuous.R
\encoding{UTF-8}
\name{ind_stdcontinuous}
\alias{ind_stdcontinuous}
\title{Assess polypharmacy based on the number of medications that is consumed both during the initial and the final period of the study period}
\usage{
ind_stdcontinuous(
  processed_tab,
  pdays,
  stats = c("mean", "sd", "min", "p5", "p10", "p25", "median", "p75", "p90", "p95",
    "max")
)
}
\arguments{
\item{processed_tab}{Table of individual drug treatments over the study period. Created by \code{\link{data_process}} function.}

\item{pdays}{Duration (in days) of the initial and final periods of time . The initial period = [min; min+\code{pdays}] and the final period = [max-\code{pdays}; max], where \emph{min} and \emph{max} are the \code{study_start} and \code{study_end} arguments. See \code{\link{data_process}}.}

\item{stats}{Cohort descriptive statistics to calculate on the polypharmacy indicator. See \emph{Details} for possible values.}
}
\value{
\code{list}:
\itemize{
\item \code{indic}: \code{data.table} indicating each \code{stats} (columns).
\item \code{stats_id}: \code{data.table} indicating the number of drugs use for each individual (all cohort).
}
}
\description{
Calculates the number of distinct medications that are consumed both during the initial and the final period of the overall study period by every individual of the study cohort and provides cohort descriptive statistics on this indicator.
}
\details{
\strong{stats:} Possible values are
\itemize{
\item \code{'mean'}, \code{'min'}, \code{'median'}, \code{'max'}, \code{'sd'};
\item \code{'pX'} where \emph{X} is an integer value in ]0, 100];
\item \code{'q1'}=\code{'p25'}, \code{'q2'}=\code{'p50'}=\code{'median'}, \code{q3}=\code{'p75'}.
}
}
\examples{
rx1 <- data.frame(id = c(1, 1, 1, 2, 3),
                  code = c("A", "A", "B", "A", "A"),
                  date = c("2000-01-01", "2000-01-22", "2000-01-10", "2000-01-01", "2000-01-20"),
                  duration = c(10, 10, 22, 31, 12))
cohort1 <- data.frame(id = as.numeric(1:4),
                      age = c(45, 12, 89, 31),
                      sex = c("F", "F", "M", "M"))
rx_proc1 <- data_process(Rx_deliv = rx1, Rx_id = "id", Rx_drug_code = "code",
                         Rx_drug_deliv = "date", Rx_deliv_dur = "duration",
                         Cohort = cohort1, Cohort_id = "id",
                         study_start = "2000-01-01", study_end = "2000-01-31",
                         cores = 1)
dt_ind_stdcontinuous <- ind_stdcontinuous(processed_tab = rx_proc1, pdays = 10)
}
