% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linguee_external_sources.R
\name{linguee_external_sources}
\alias{linguee_external_sources}
\title{Retrieve external sources using Linguee Translation API}
\usage{
linguee_external_sources(query, src, dst, limit = 5)
}
\arguments{
\item{query}{The word or phrase for which you want to retrieve external sources.}

\item{src}{The source language of the word or phrase. Accepts language codes such as "en", "es", "fr", etc.}

\item{dst}{The target language for the external source retrieval. Accepts language codes such as "en", "es", "fr", etc.}

\item{limit}{The maximum number of external sources to retrieve. Defaults to 5.}
}
\value{
A dataframe of external sources with columns: src, dst, src_url, dst_url.
}
\description{
Retrieve external sources using Linguee Translation API
}
\examples{
\donttest{
linguee_external_sources(query = "hello", src = "en", dst = "es")
}

}
\seealso{
linguee_word_translation, linguee_translation_examples
}
