% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/translate_apertium.R
\name{apertium_translate}
\alias{apertium_translate}
\title{Translate text using Apertium}
\usage{
apertium_translate(
  text,
  target_language,
  source_language,
  host = "https://apertium.org/apy"
)
}
\arguments{
\item{text}{Text to translate. Can be a single string or a vector of strings.}

\item{target_language}{Language to translate text to.}

\item{source_language}{Language to translate text from.}

\item{host}{Host URL for the Apertium API (default is "https://apertium.org/apy").}
}
\value{
Translated text. Returns a vector if input is a vector.
}
\description{
Translate text using Apertium
}
\examples{
\donttest{
apertium_translate("Hello World", target_language = "es", source_language = "en")
apertium_translate("Hola mundo", target_language = "en", source_language = "es")

# Translate multiple texts
texts <- c("Hello", "Good morning", "Thank you")
apertium_translate(texts, target_language = "es", source_language = "en")
}
}
