% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method_zero_round.R
\name{zero.round}
\alias{zero.round}
\alias{zero.round,polynomial-method}
\alias{zero.round,polyMatrix-method}
\title{Rounds objects to zero if there is too small}
\usage{
zero.round(x, eps = ZERO_EPS)

\S4method{zero.round}{polynomial}(x, eps = ZERO_EPS)

\S4method{zero.round}{polyMatrix}(x, eps = ZERO_EPS)
}
\arguments{
\item{x}{an \R object}

\item{eps}{Minimal numerical value which will not be treated as zero}
}
\description{
Rounds objects to zero if there is too small
}
\details{
By befault \code{eps} = \verb{\{r\} ZERO_EPS}
}
\section{Methods (by class)}{
\itemize{
\item \code{polynomial}: rounding of a polynomial means rounding of each coefficient

\item \code{polyMatrix}: rounding of a polynomial matrix
}}

\examples{

# numerical
zero.round(1)  ## 1
zero.round(0)  ## 0
zero.round(0.1, eps=0.5) ## 0
zero.round(c(1, 0, .01, 1e-10)) ##  1.00 0.00 0.01 0.00


# polynomials
zero.round(parse.polynomial("0.1 + x + 1e-7 x^2")) ## 0.1 + x
zero.round(parse.polynomial("0.1 + x + 1e-7 x^2"), eps=0.5) ## x


# polynomial matrix
zero.round(parse.polyMatrix(
  "1 + 0.1 x, 10 + x + 3e-8 x^2, 1e-8",
  "0.1 + x^2,     .1 + 1e-8 x^4, 1e-8 x^5"
))
##             [,1]     [,2]   [,3]
## [1,]    1 + 0.1x   10 + x      0
## [2,]   0.1 + x^2      0.1      0

zero.round(parse.polyMatrix(
  "1 + 0.1 x, 10 + x + 3e-8 x^2, 1e-8",
  "0.1 + x^2,     .1 + 1e-8 x^4, 1e-8 x^5"
), eps=0.5)
##        [,1]     [,2]   [,3]
## [1,]      1   10 + x      0
## [2,]    x^2        0      0

}
\seealso{
\code{\link[=is.zero]{is.zero()}}
}
