% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{summary.pmrm_fit}
\alias{summary.pmrm_fit}
\title{Summarize a PMRM.}
\usage{
\method{summary}{pmrm_fit}(object, ...)
}
\arguments{
\item{object}{A fitted model object of class \code{"pmrm_fit"}.}

\item{...}{Not used.}
}
\value{
A \code{tibble} with one row and columns with the following columns:
\itemize{
\item \code{model}: \code{"decline"} or \code{"slowing"}.
\item \code{parameterization}: \code{"proportional"} or \code{"nonproportional"}.
\item \code{n_observations}: number of non-missing observations in the data.
\item \code{n_parameters}: number of true model parameters.
\item \code{log_likelihood}: maximized log likelihood of the model fit.
\item \code{deviance}: deviance of the fitted model, defined here as
\code{-2 * log_likelihood}.
\item \code{aic}: Akaike information criterion.
\item \code{bic}: Bayesian information criterion.
}

This format is designed for easy comparison of multiple fitted models.
}
\description{
Summarize a progression model for repeated measures (PMRM).
}
\examples{
  set.seed(0L)
  simulation <- pmrm_simulate_decline_proportional(
    visit_times = seq_len(5L) - 1,
    gamma = c(1, 2)
  )
  fit <- pmrm_model_decline_proportional(
    data = simulation,
    outcome = "y",
    time = "t",
    patient = "patient",
    visit = "visit",
    arm = "arm",
    covariates = ~ w_1 + w_2
  )
  summary(fit)
}
\seealso{
Other model comparison: 
\code{\link{AIC.pmrm_fit}()},
\code{\link{BIC.pmrm_fit}()},
\code{\link{confint.pmrm_fit}()},
\code{\link{deviance.pmrm_fit}()},
\code{\link{glance.pmrm_fit}()},
\code{\link{logLik.pmrm_fit}()}
}
\concept{model comparison}
