% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AIC.R
\name{AIC.pmrm_fit}
\alias{AIC.pmrm_fit}
\title{Akaike information criterion (AIC)}
\usage{
\method{AIC}{pmrm_fit}(object, ..., k = NULL)
}
\arguments{
\item{object}{A fitted model object of class \code{"pmrm_fit"}.}

\item{...}{Not used.}

\item{k}{Not used. Must be \code{NULL}.}
}
\value{
Numeric scalar, the Akaike information criterion (AIC)
of the fitted model.
}
\description{
Extract the Akaike information criterion (AIC)
of a progression model for repeated measures (PMRM).
}
\examples{
  set.seed(0L)
  simulation <- pmrm_simulate_decline_proportional(
    visit_times = seq_len(5L) - 1,
    gamma = c(1, 2)
  )
  fit <- pmrm_model_decline_proportional(
    data = simulation,
    outcome = "y",
    time = "t",
    patient = "patient",
    visit = "visit",
    arm = "arm",
    covariates = ~ w_1 + w_2
  )
  AIC(fit)
}
\seealso{
Other model comparison: 
\code{\link{BIC.pmrm_fit}()},
\code{\link{confint.pmrm_fit}()},
\code{\link{deviance.pmrm_fit}()},
\code{\link{glance.pmrm_fit}()},
\code{\link{logLik.pmrm_fit}()},
\code{\link{summary.pmrm_fit}()}
}
\concept{model comparison}
