% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pmml.ARIMA.R
\name{pmml.ARIMA}
\alias{pmml.ARIMA}
\title{Generate PMML for an ARIMA object the \bold{forecast} package.}
\usage{
\method{pmml}{ARIMA}(
  model,
  model_name = "ARIMA_model",
  app_name = "SoftwareAG PMML Generator",
  description = "ARIMA Time Series Model",
  copyright = NULL,
  model_version = NULL,
  transforms = NULL,
  missing_value_replacement = NULL,
  ts_type = "statespace",
  cpi_levels = c(80, 95),
  ...
)
}
\arguments{
\item{model}{An ARIMA object from the package \pkg{forecast}.}

\item{model_name}{A name to be given to the PMML model.}

\item{app_name}{The name of the application that generated the PMML.}

\item{description}{A descriptive text for the Header element of the PMML.}

\item{copyright}{The copyright notice for the model.}

\item{model_version}{A string specifying the model version.}

\item{transforms}{Data transformations.}

\item{missing_value_replacement}{Value to be used as the 'missingValueReplacement'
attribute for all MiningFields.}

\item{ts_type}{The type of time series representation for PMML: "arima" or "statespace".}

\item{cpi_levels}{Vector of confidence levels for prediction intervals.}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
PMML representation of the \code{ARIMA} object.
}
\description{
Generate PMML for an ARIMA object the \bold{forecast} package.
}
\details{
The model is represented as a PMML TimeSeriesModel.

When \code{ts_type = "statespace"} (by default), the R object is exported as StateSpaceModel in PMML.

When \code{ts_type = "arima"}, the R object is exported as ARIMA in PMML with conditional
least squares (CLS). Note that ARIMA models in R are
estimated using a state space representation. Therefore, when using CLS with seasonal models,
forecast results between R and PMML may not match exactly. Additionally, when ts_type="arima", prediction intervals
are exported for non-seasonal models only. For ARIMA models with d=2, the prediction intervals
between R and PMML may not match.

OutputField elements are exported with
dataType "string", and contain a collection of all values up to and including the steps-ahead value supplied
during scoring.
String output in this form is facilitated by Extension elements in the PMML file,
and is supported by Zementis Server since version 10.6.0.0.

\code{cpi_levels} behaves similar to \code{levels} in \code{forecast::forecast}: values must be
between 0 and 100, non-inclusive.

Models with a drift term will be supported in a future version.

Transforms are currently not supported for ARIMA models.
}
\examples{
\dontrun{
library(forecast)

# non-seasonal model
data("WWWusage")
mod <- Arima(WWWusage, order = c(3, 1, 1))
mod_pmml <- pmml(mod)

# seasonal model
data("JohnsonJohnson")
mod_02 <- Arima(JohnsonJohnson,
  order = c(1, 1, 1),
  seasonal = c(1, 1, 1)
)
mod_02_pmml <- pmml(mod_02)

# non-seasonal model exported with Conditional Least Squares
data("WWWusage")
mod <- Arima(WWWusage, order = c(3, 1, 1))
mod_pmml <- pmml(mod, ts_type = "arima")
}

}
\author{
Dmitriy Bolotov
}
