% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spatial_probit.R
\name{pmlsbp}
\alias{pmlsbp}
\alias{print.pmlsprobit}
\title{Fitting Spatial Probit Models by Partial Maximum Likelihood}
\usage{
pmlsbp(
  formula, data, model = "SAR", grouping = 2,
  W = NULL,
  zero.policy = spatialreg::get.ZeroPolicyOption(),
  M = NULL, formula_xlag = NULL, W2 = NULL,
  method_inv = "solve",
  start = NULL, subset = NULL, na.action = na.fail,
  qu = Inf, iterlim = 1000,
  mvtnorm_control = list(M = 1e4, sim_type = "qmc",
                         tol = .Machine$double.eps, fast = FALSE),
  finalHessian = ifelse(method == "bhhh", method, TRUE),
  method = "bhhh", print.level = 2,
  vce.type = "asy",
  Conley = list(coords = NULL, LM = 2),
  nBoot = 1e3, spectral = FALSE,
  verbose = TRUE ,
  tol.solve = .Machine$double.eps,
  version = 0, ...
)

\method{print}{pmlsprobit}(x, digits = max(3, getOption("digits") - 3), ...)
}
\arguments{
\item{formula}{An object of class \code{"formula"} specifying the model.}

\item{data}{An optional data frame containing the variables in the model.}

\item{model}{A character string specifying the model type; either
\code{"SAR"} or \code{"SARAR"}.}

\item{grouping}{An integer defining the number of observations to include
in the tuples used for estimation.}

\item{W}{A spatial weights object of class \code{"listw"}, for example
created by \code{\link[spdep]{nb2listw}}.}

\item{zero.policy}{Logical; if \code{TRUE}, assigns zero to lagged values
for observations without neighbors.}

\item{M}{A spatial weights object of class \code{"listw"} used for the
disturbance process; relevant only if \code{model = "SARAR"}.}

\item{formula_xlag}{An optional \code{"formula"} specifying covariates to be
spatially lagged.}

\item{W2}{A spatial weights object used to construct spatially lagged
covariates; relevant only if \code{formula_xlag} is not \code{NULL}.}

\item{method_inv}{Character string specifying the method used to invert
\eqn{I - \rho W}; one of \code{"solve"}, \code{"chol"}, or \code{"fast"}.}

\item{start}{Numeric vector of starting values.}

\item{subset}{Optional vector specifying a subset of observations.}

\item{na.action}{A function specifying how missing values are handled.}

\item{qu}{Integer used only if \code{method_inv = "fast"}.}

\item{iterlim}{Integer specifying the maximum number of iterations.}

\item{mvtnorm_control}{A list of control parameters for multivariate normal
probability calculations; see \code{\link[mvtnorm]{lpmvnorm}}.}

\item{finalHessian}{Logical or character specifying how the final Hessian
matrix is computed; see \code{\link[maxLik]{maxLik}}.}

\item{method}{Maximization method passed to \code{\link[maxLik]{maxLik}}.}

\item{print.level}{Integer controlling the amount of diagnostic output.}

\item{vce.type}{Character specifying the variance–covariance estimator;
one of \code{"asy"}, \code{"bootstrap"}, or \code{"mConley"}.}

\item{Conley}{A list specifying options for the modified Conley estimator.}

\item{nBoot}{Integer specifying the number of bootstrap replications.}

\item{spectral}{Logical; if \code{TRUE}, uses spectral normalization of \eqn{W}.}

\item{verbose}{Logical; if \code{TRUE}, diagnostic messages are printed during
model estimation. The default is \code{TRUE}. Setting \code{verbose = FALSE}
suppresses intermediate output.}

\item{tol.solve}{Numeric tolerance used when inverting matrices.}

\item{version}{Integer controlling the computation of bivariate normal
integrals when \code{grouping = 2}.}

\item{...}{Additional arguments passed to \code{\link[maxLik]{maxLik}}.}

\item{x}{a \code{"pmlsprobit"} object}

\item{digits}{integer, used for number formatting the decimal digits}
}
\value{
An object of class \code{"pmlsprobit"}, which is a list containing:
\describe{
\item{\code{beta}}{Named vector of regression coefficients.}
\item{\code{call}}{The matched function call.}
\item{\code{code}}{Convergence code from \code{maxLik}.}
\item{\code{estimate}}{Named vector of parameter estimates.}
\item{\code{f}}{List of matrices used for prediction.}
\item{\code{maximum}}{Value of the partial log-likelihood.}
\item{\code{message}}{Convergence message from \code{maxLik}.}
\item{\code{model}}{Model frame used in estimation.}
\item{\code{model.type}}{Either \code{"SAR"} or \code{"SARAR"}.}
\item{\code{rho}}{Estimated spatial autoregressive parameter.}
\item{\code{slx}}{Logical indicating the presence of spatially lagged covariates.}
\item{\code{start}}{Starting values used in estimation.}
\item{\code{terms}}{Terms object.}
\item{\code{vcov}}{Variance–covariance matrix of the estimates.}
\item{\code{W}}{Spatial weights matrix \eqn{W}.}
\item{\code{lambda}}{Estimated disturbance parameter (SARAR only).}
\item{\code{M}}{Spatial weights matrix \eqn{M} (SARAR only).}
\item{\code{W2}}{Spatial weights matrix \eqn{W_2} (if \code{slx = TRUE}).}
}

No return value
}
\description{
Fits spatial autoregressive probit models using partial maximum likelihood
as proposed in Bille and Leorato (2020) \url{doi:10.1080/07474938.2019.1682314}.
Both Spatial Autoregressive (SAR) probit models and Spatial Autoregressive
Probit Models with Autoregressive Disturbances (SARAR) are supported.
}
\details{
The SARAR model is defined as
\deqn{
y^* = \rho W y + X \beta + W_2 Z \gamma + u
}{
y* = rho W y + X beta + W2 Z gamma + u
}
with
\deqn{
u = \lambda M u + \epsilon,
}{
u = lambda M u + epsilon
}
where \eqn{\epsilon \sim N(0,\sigma^2)} and the observed binary outcome is
\eqn{y = 1(y^* > 0)}. The SAR model is obtained by setting \eqn{\lambda = 0}.
}
\section{Functions}{
\itemize{
\item \code{print(pmlsprobit)}: prints the call and the coefficient estimates of a \code{"pmlsprobit"} object

}}
\examples{
\donttest{
data(oldcol, package = "spdep")
dat <- COL.OLD
dat$y <- as.numeric(dat$CRIME > 35)

listw <- spdep::nb2listw(COL.nb, style = "W")

set.seed(857489)
mod <- pmlsbp(
  y ~ HOVAL + INC, data = dat, W = listw,
  model = "SAR", grouping = 7,
  na.action = na.omit, spectral = TRUE,
  iterlim = 1e5
)
}

}
\references{
Bille', A. G., & Leorato, S. (2020).
Partial ML estimation for spatial autoregressive nonlinear probit models
with autoregressive disturbances.
\emph{Econometric Reviews}, 39(5), 437–475.
\doi{10.1080/07474938.2019.1682314}
}
\seealso{
\code{\link{pmlsbp}}, \code{\link[maxLik]{maxLik}}
}
