% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalize_isobaric.R
\name{normalize_isobaric}
\alias{normalize_isobaric}
\title{Examine and Apply Isobaric Normalization}
\usage{
normalize_isobaric(
  omicsData,
  exp_cname = NULL,
  apply_norm = FALSE,
  channel_cname = NULL,
  refpool_channel = NULL,
  refpool_cname = NULL,
  refpool_notation = NULL
)
}
\arguments{
\item{omicsData}{an object of the class 'isobaricpepData'}

\item{exp_cname}{character string specifying the name of the column
containing the experiment/plate information in \code{f_data}}

\item{apply_norm}{logical, indicates whether normalization should be applied
to omicsData$e_data}

\item{channel_cname}{optional character string specifying the name of the
column containing the instrument channel a sample was run on in
\code{f_data}. This argument is optional. See Details for how to specify
information regarding reference pool samples. If using this argument, the
'refpool_channel' argument must also be specified; in this case,
'refpool_cname' and 'refpool_notation' should not be specified.}

\item{refpool_channel}{optional character string specifying which channel
contains the reference pool sample. Only used when this is the same
from experiment to experiment. This argument is optional. See Details for
how to specify information regarding reference pool samples. If using this
argument, the 'channel_cname' argument must also be specified; in this
case, 'refpool_cname' and 'refpool_notation' should not be specified.}

\item{refpool_cname}{optional character string specifying the name of the
column containing information about which samples are reference samples in
\code{f_data}. This argument is optional. see Details for how to specify
information regarding reference pool samples. If using this argument, the
'refpool_notation' argument must also be specified; in this case,
'channel_cname' and 'refpool_channel' should not be specified.}

\item{refpool_notation}{optional character string specifying the value in the
refpool_channel column which denotes that a sample is a reference sample.
This argument is optional. See Details for how to specify information
regarding reference pool samples. If using this argument, the
'refpool_cname' argument must also be specified; in this case,
'channel_cname' and 'refpool_channel' should not be specified.}
}
\value{
If apply_norm = TRUE, an object of class 'isobaricpepData', normalized to reference pool,
 and with the attribute 'isobaric_info' updated to include information about
 the reference pool samples and the normalization procedure.  Otherwise an
 object of class 'isobaricnormRes' containing similar information about the 
 normalization process
}
\description{
Examine reference pool samples and apply normalization of study samples to
their corresponding reference pool sample
}
\details{
There are two ways to specify the information needed for identifying
  reference samples which should be used for normalization: \enumerate{ \item
  specify \code{channel_cname} and \code{refpool_channel}. This should be
  used when the reference sample for each experiment/plate was always located
  in the same channel. Here \code{channel_cname} gives the column name for
  the column in \code{f_data} which gives information about which channel
  each sample was run on, and \code{refpool_channel} is a character string
  specifying the value in \code{channel_colname} that corresponds to the
  reference sample channel. \item specify \code{refpool_cname} and
  \code{refpool_notation}. This should be used when the reference sample is
  not in a consistent channel across experiments/plates. Here,
  \code{refpool_cname} gives the name of the column in \code{f_data} which
  indicates whether a sample is a reference or not, and
  \code{refpool_notation} is a character string giving the value used to
  denote a reference sample in that column. } In both cases you must specify
  \code{exp_cname} which gives the column name for the column in
  \code{f_data} containing information about which experiment/plate a sample
  was run on.
}
\examples{
\dontshow{if (identical(tolower(Sys.getenv("NOT_CRAN")), "true") & requireNamespace("pmartRdata", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(pmartRdata)

myiso <- edata_transform(isobaric_object, "log2")

# Don't apply the normalization quite yet;
# can use summary() and plot() to view reference pool samples
myiso_refpools <- normalize_isobaric(
  omicsData = myiso, exp_cname = "Plex",
  apply_norm = FALSE,
  refpool_cname = "Virus",
  refpool_notation = "Pool"
)
summary(myiso_refpools)

# Now apply the normalization;
# can use plot() to view the study samples after reference pool normalization
myiso_norm <- normalize_isobaric(
  omicsData = myiso, exp_cname = "Plex",
  apply_norm = TRUE,
  refpool_cname = "Virus",
  refpool_notation = "Pool"
)
\dontshow{\}) # examplesIf}
}
