% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api_handlers.R
\name{api_shiny}
\alias{api_shiny}
\title{Serve a Shiny app from a plumber2 api}
\usage{
api_shiny(api, path, app, except = NULL, auth_flow = NULL, auth_scope = NULL)
}
\arguments{
\item{api}{A plumber2 api to add the shiny app to}

\item{path}{The path to serve the shiny app from}

\item{app}{A shiny app object}

\item{except}{Subpaths to \code{path} that should not be forwarded to the
shiny app. Be sure it doesn't contains paths that the shiny app needs}

\item{auth_flow}{A logical expression giving the authentication flow the
client must pass to get access to the resource.}

\item{auth_scope}{The scope requirements of the resource}
}
\value{
This functions return the \code{api} object allowing for easy chaining
with the pipe
}
\description{
You can serve one or more shiny apps as part of a plumber2 api. The shiny app
launches in a background process and the api will work as a reverse proxy to
forward requests to \code{path} to the process and relay the response to the
client. The shiny app is started along with the api and shut down once the
api is stopped. This functionality requires the shiny and callr packages to
be installed. Be aware that all requests to subpaths of \code{path} will be
forwarded to the shiny process, and thus not end up in your normal route
}
\section{Using annotation}{
A shiny app can be served using an annotated route file by using the \verb{@shiny}
tag and proceeding the annotation block with the shiny app object

\if{html}{\out{<div class="sourceCode">}}\preformatted{#* @shiny /my_app/
shiny::shinyAppDir("./shiny")
}\if{html}{\out{</div>}}
}

\examples{
\dontshow{if (requireNamespace("shiny", quietly = TRUE)) withAutoprint(\{ # examplesIf}
blank_shiny <- shiny::shinyApp(
  ui = shiny::fluidPage(),
  server = shiny::shinyServer(function(...) {})
)

api() |>
  api_shiny("my_app/", blank_shiny)
\dontshow{\}) # examplesIf}
}
