% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IPW.R
\name{ipw_pls}
\alias{ipw_pls}
\alias{ipw_pls_legacy}
\title{Iterative predictor weighting PLS (IPW-PLS)}
\usage{
ipw_pls(
  y,
  X,
  ncomp = 10,
  no.iter = 10,
  IPW.threshold = 0.01,
  filter = "RC",
  scale = TRUE
)

ipw_pls_legacy(y, X, ncomp = 10, no.iter = 10, IPW.threshold = 0.1)
}
\arguments{
\item{y}{vector of response values (\code{numeric} or \code{factor}).}

\item{X}{numeric predictor \code{matrix}.}

\item{ncomp}{integer number of components (default = 10).}

\item{no.iter}{the number of iterations (default = 10).}

\item{IPW.threshold}{threshold for regression coefficients (default = 0.1).}

\item{filter}{which filtering method to use (among "RC", "SR", "LW", "VIP", "sMC")}

\item{scale}{standardize data (default=TRUE, as in reference)}
}
\value{
Returns a vector of variable numbers corresponding to the model 
having lowest prediction error.
}
\description{
An iterative procedure for variable elimination.
}
\details{
This is an iterative elimination procedure where a measure of predictor 
importance is computed after fitting a PLSR model (with complexity chosen based
on predictive performance). The importance measure is used both to re-scale the 
original X-variables and to eliminate the least important variables before
subsequent model re-fitting

The IPW implementation was corrected in \code{plsVarSel} version 0.9.5. For backward
compatibility the old implementation is included as \code{ipw_pls_legacy}.
}
\examples{
data(gasoline, package = "pls")
with( gasoline, ipw_pls(octane, NIR) )

}
\references{
M. Forina, C. Casolino, C. Pizarro Millan, Iterative predictor weighting
 (IPW) PLS: a technique for the elimination of useless predictors in regression problems,
 Journal of Chemometrics 13 (1999) 165-184.
}
\seealso{
\code{\link{VIP}} (SR/sMC/LW/RC), \code{\link{filterPLSR}}, \code{\link{shaving}}, 
\code{\link{stpls}}, \code{\link{truncation}},
\code{\link{bve_pls}}, \code{\link{ga_pls}}, \code{\link{ipw_pls}}, \code{\link{mcuve_pls}},
\code{\link{rep_pls}}, \code{\link{spa_pls}},
\code{\link{lda_from_pls}}, \code{\link{setDA}}.
}
\author{
Kristian Hovde Liland
}
