% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PVS_PVR.R
\name{PVS}
\alias{PVS}
\title{Principal Variable Selection (PVS)}
\usage{
PVS(X, nvar, ncomp = NULL)
}
\arguments{
\item{X}{numeric predictor \code{matrix}.}

\item{nvar}{integer, the required number of selected variables.}

\item{ncomp}{integer, number of principal components included in the voting (default = all PCs).}
}
\value{
A list containing:
\item{Q}{Orthonormal scores (associated with the selected variables).}
\item{R}{Corresponding loadings. NOTE: R[,vperm] is upper triangular.}
\item{ids}{Indices arranged in the order of the nvar selected variables.}
\item{vperm}{Indices arranged in the order of the nvar selected and all non-selected variables. NOTE: R[,vperm] is upper triangular.}
\item{ssEX}{The variances explained by the selected variables.}
\item{ni}{The norms of the (residual) selected variables before the score-normalization (Q).}
\item{U}{The normalized PCA-scores.}
\item{s}{Singular values of the mean centered X.}
}
\description{
Greedy algorithm for extracting the most dominant (principal)
variables (X-columns) with respect to explained X-variance.
}
\examples{
library(pls)
data(gasoline, package = "pls")

# PVS: Select 10 variables using all PCs in voting
pvs_result <- PVS(gasoline$NIR, nvar = 10)

# Compare with PCA using pcr() (octane is unused in PCA)
pca_result <- pcr(octane ~ NIR, ncomp = 10, data = gasoline, scale = FALSE)

# Plot cumulative variance explained
plot(cumsum(pvs_result$ssEX), type = "b", col = "blue", 
     xlab = "Number of Variables/Components", 
     ylab = "Cumulative \% Variance Explained",
     main = "PVS vs PCA", ylim = c(0, 100))
pca_var <- 100 * cumsum(pca_result$Xvar) / pca_result$Xtotvar
lines(seq_along(pca_var), pca_var, type = "b", col = "red")
legend("bottomright", legend = c("PVS (10 variables)", "PCA (10 components)"),
       col = c("blue", "red"), lty = 1, pch = 1)

}
\references{
Joakim Skogholt, Kristian Hovde Liland, Tormod Næs, Age K. Smilde, Ulf Geir Indahl,
Selection of principal variables through a modified Gram–Schmidt process with and without supervision,
Journal of Chemometrics, Volume 37, Issue 10, Pages e3510 (2023), https://doi.org/10.1002/cem.3510
}
\seealso{
\code{\link{PVR}}, \code{\link{VIP}}, \code{\link{filterPLSR}}, \code{\link{shaving}}, 
\code{\link{stpls}}, \code{\link{truncation}},
\code{\link{bve_pls}}, \code{\link{ga_pls}}, \code{\link{ipw_pls}}, \code{\link{mcuve_pls}},
\code{\link{rep_pls}}, \code{\link{spa_pls}}.
}
\author{
Ulf Indahl, Kristian Hovde Liland.
}
