% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.summary.plsRmodel.R
\name{print.summary.plsRmodel}
\alias{print.summary.plsRmodel}
\title{Print method for summaries of plsR models}
\usage{
\method{print}{summary.plsRmodel}(x, ...)
}
\arguments{
\item{x}{an object of the class \code{"summary.plsRmodel"}}

\item{\dots}{not used}
}
\value{
\item{language}{call of the model}
}
\description{
This function provides a print method for the class
\code{"summary.plsRmodel"}
}
\examples{

data(Cornell)
XCornell<-Cornell[,1:7]
yCornell<-Cornell[,8]
modpls <- plsRglm(yCornell,XCornell,3,modele="pls")
class(modpls)
print(summary(modpls))
rm(list=c("XCornell","yCornell","modpls"))

}
\references{
Nicolas Meyer, Myriam Maumy-Bertrand et
Frédéric Bertrand (2010). Comparaison de la
régression PLS et de la régression
logistique PLS : application aux données
d'allélotypage. \emph{Journal de la Société Française
de Statistique}, 151(2), pages 1-18.
\url{https://www.numdam.org/item/JSFS_2010__151_2_1_0/}
}
\seealso{
\code{\link{print}} and \code{\link{summary}}
}
\author{
Frédéric Bertrand\cr
\email{frederic.bertrand@lecnam.net}\cr
\url{https://fbertran.github.io/homepage/}
}
\keyword{methods}
\keyword{print}
