% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/default.R
\name{as.png.default}
\alias{as.png.default}
\title{Convert to PNG by Default}
\usage{
\method{as.png}{default}(x, width = getOption("plotscale_png_width", 3),
  height = getOption("plotscale_png_height", 3), devsize = if (scaled)
  "devsize" else "unscaled", res = getOption("plotscale_res", 300),
  units = "in", scaled = getOption("plotscale_scaled", TRUE),
  filename = "Rplot\%03d.png", ...)
}
\arguments{
\item{x}{object}

\item{width}{desired plot width}

\item{height}{desired plot height}

\item{devsize}{a function of x, width, height, and \dots that calculates device size}

\item{res}{passed to \code{\link[grDevices]{png}}}

\item{units}{NOT passed to \code{\link[grDevices]{png}}; width and height always treated as inches regardless}

\item{scaled}{whether to rescale width and height by plot size}

\item{filename}{file name passed to \code{\link[grDevices]{png}}}

\item{...}{other arguments to \code{\link[grDevices]{png}} and devsize}
}
\value{
(invisible) the filename argument
}
\description{
Converts object to PNG.  By default, device is scaled by plot size. Device is automatically closed and filename argument is returned.
}
\examples{
options(example.ask = FALSE)
options(device.ask.default = FALSE)
library(lattice)
as.png(xyplot(2~3), filename = tempfile())
}
\seealso{
Other as.png: \code{\link{as.png}}

Other devices: \code{\link{as.pdf.default}},
  \code{\link{as.pdf}}, \code{\link{as.png}}
}
