% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util.R
\name{keepFigRatio}
\alias{keepFigRatio}
\title{Calculate the height or width in plot coordinates to keep a given ratio  
relative to the figure.}
\usage{
keepFigRatio(input, original = c(1024, 768), side.input = 1)
}
\arguments{
\item{input}{A number in units of x- or y-axis (determined by 
\code{side.input} argument).}

\item{original}{Two-number vector representing the width and height of the 
original rectangle; alternatively, if only one number is provided, this is 
interpreted as the width:height ratio.}

\item{side.input}{Number representing the axis associated with the number(s) 
specified in the argument \code{input}, with 1=bottom (default), 2=left, 
3=top, 4=right. The output is adjusted accordingly.}
}
\value{
Width and height in x- and y-units
}
\description{
Calculate the height or width in plot coordinates to keep a given ratio  
relative to the figure.
}
\examples{
# add centered square to plot,
# while plot window is not squared
dev.new(width=5, height=4)
emptyPlot(1,1, bty='o')
size1 = keepFigRatio(.5, original=c(1,1))
size2 = keepFigRatio(.5, original=c(1,1), side.input=2)
rect(xleft=.5-(size1$x/2),
     xright=.5+(size1$x/2),
     ybottom=.5-(size1$y/2),
     ytop=.5+(size1$y/2),
     col="gray")
rect(xleft=.5-(size2$x/2),
     xright=.5+(size2$x/2),
     ybottom=.5-(size2$y/2),
     ytop=.5+(size2$y/2),
     col=alpha("#FF3300"), border=NA)
rect(xleft=.25, xright=.75,
     ybottom=.25, ytop=.75,
     lwd=2, border="#0066FF")


}
\seealso{
Other Utility functions: 
\code{\link{findAbsMin}()},
\code{\link{find_n_neighbors}()},
\code{\link{firstLetterCap}()},
\code{\link{getArrowPos}()},
\code{\link{getDec}()},
\code{\link{getRange}()},
\code{\link{getRatioCoords}()},
\code{\link{get_palette}()},
\code{\link{group_sort}()},
\code{\link{inch2coords}()},
\code{\link{isColor}()},
\code{\link{list2str}()},
\code{\link{move_n_point}()},
\code{\link{orderBoxplot}()},
\code{\link{se}()},
\code{\link{sortGroups}()}
}
\concept{Utility functions}
