% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_ATE.R
\name{plot_SATE}
\alias{plot_SATE}
\title{Plot histogram or density of Sample Average Treatment Effects}
\usage{
plot_SATE(
  .model,
  type = c("histogram", "density"),
  ci_80 = FALSE,
  ci_95 = FALSE,
  reference = NULL,
  .mean = FALSE,
  .median = FALSE
)
}
\arguments{
\item{.model}{a model produced by `bartCause::bartc()`}

\item{type}{histogram or density}

\item{ci_80}{TRUE/FALSE. Show the 80\% credible interval?}

\item{ci_95}{TRUE/FALSE. Show the 95\% credible interval?}

\item{reference}{numeric. Show a vertical reference line at this x-axis value}

\item{.mean}{TRUE/FALSE. Show the mean reference line}

\item{.median}{TRUE/FALSE. Show the median reference line}
}
\value{
ggplot object
}
\description{
Plot a histogram or density of the Sample Average Treatment Effect (SATE). The Sample Average Treatment Effect is derived from taking the difference of each individual's observed outcome and a predicted counterfactual outcome from a BART model averaged over the population.
The mean of SATE will resemble means of CATE and PATE but will account for the least uncertainty.
}
\examples{
\donttest{
data(lalonde)
confounders <- c('age', 'educ', 'black', 'hisp', 'married', 'nodegr')
model_results <- bartCause::bartc(
 response = lalonde[['re78']],
 treatment = lalonde[['treat']],
 confounders = as.matrix(lalonde[, confounders]),
 estimand = 'ate',
 commonSup.rule = 'none'
)
plot_SATE(model_results)
}
}
\author{
George Perrett, Joseph Marlo
}
