% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/try_again.R
\name{try_again}
\alias{try_again}
\title{Retry code execution with exponential backoff}
\usage{
try_again(
  x,
  times = 2,
  delay_seconds_min = 5,
  delay_seconds_max = 10,
  verbose = FALSE
)
}
\arguments{
\item{x}{The code to execute (as an expression)}

\item{times}{Integer, the maximum number of attempts to make. Defaults to 2}

\item{delay_seconds_min}{Numeric, the minimum delay in seconds between attempts.
Defaults to 5}

\item{delay_seconds_max}{Numeric, the maximum delay in seconds between attempts.
Defaults to 10}

\item{verbose}{Logical, whether to show progress information. Defaults to \code{FALSE}}
}
\value{
\code{TRUE} invisibly if successful, otherwise throws an error with the last
error message
}
\description{
This function attempts to execute code multiple times with random delays between
attempts. It's particularly useful for handling transient failures in operations
that may succeed on subsequent attempts, such as network requests or file operations.
}
\details{
The function is adapted from the \code{try_again} function in the testthat package,
but with additional features for controlling retry behavior and verbosity.
}
\examples{
\dontrun{
# Try a simple operation
try_again({
  # Your code here
  stop("Simulated error")
}, times = 3, verbose = TRUE)

# Try with custom delays
try_again({
  # Your code here
  stop("Simulated error")
}, delay_seconds_min = 1, delay_seconds_max = 3)
}
}
