% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_plates.R
\name{read_plates}
\alias{read_plates}
\title{Read multiple plater-formatted files and combine result into one data frame.}
\usage{
read_plates(files, plate_names = NULL, well_ids_column = "Wells", sep = ",")
}
\arguments{
\item{files}{A character vector with the paths of one or more plater-formatted
.csv files.}

\item{plate_names}{A character vector the same length as \code{files} with the
names to give the individual plates in the resulting data frame. Defaults to
the file names (stripped of path and .csv).}

\item{well_ids_column}{The name to give the column that will contain the well
identifiers. Default "Wells".}

\item{sep}{The character used to separate columns in the file (e.g. "," or ";"). 
Defaults to ",".}
}
\value{
Returns a data frame like that returned by \code{read_plate}, 
containing the data from all of the plates. The plates will be identified 
with a column called "Plate" containing the names given in 
\code{plate_names}.
}
\description{
A wrapper around \code{read_plate} that handles multiple plates and combines
them all into a single data frame.
}
\examples{
# Combine multiple files into one tidy data frame
file1 <- system.file("extdata", "example-1.csv", package = "plater")
file2 <- system.file("extdata", "more-bacteria.csv", package = "plater")

# Data are stored in plate-shaped form
data <- read_plates(
   files = c(file1, file2),
   plate_names = c("Experiment 1", "Experiment 2"),
   well_ids_column = "Wells")

# Data from both plates are tidy and in the same data frame
head(data)
}
