% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/burndown.R
\name{plot,burndown-method}
\alias{plot,burndown-method}
\alias{plot.burndown}
\title{Draw a burndown chart}
\usage{
\S4method{plot}{burndown}(
  x,
  col = NULL,
  draw.plan = TRUE,
  draw.regression = TRUE,
  draw.lastupdate = FALSE,
  t.stop = "",
  y.name = "Remaining Effort",
  debug = FALSE,
  ...
)
}
\arguments{
\item{x}{A \linkS4class{burndown} object.}

\item{col}{list of colours for items, starting with the first key in the
file (which will be at the bottom of the chart).  If not specified, the
\code{\link[=hcl]{hcl()}} scheme will be used, to generate colours that are
distinct, that show up reasonably well on a monitor.}

\item{draw.plan}{boolean, set to \code{TRUE} to draw the plan, as a
blue descending line with a horizontal intercept.}

\item{draw.regression}{boolean, set to \code{TRUE} to draw a red dashed
line indicating the overall progress, as determined by regression.}

\item{draw.lastupdate}{boolean, set to \code{TRUE} to draw the last update
(which otherwise requires a sharp eye).}

\item{t.stop}{a POSIX time, the maximum time for graph (defaults to deadline
if not given).}

\item{y.name}{character string, for labelling the vertical axis.}

\item{debug}{boolean, set to \code{TRUE} to monitor the work.}

\item{...}{extra things handed down to plotting functions.}
}
\description{
Plot a burndown chart.
}
\examples{
library(plan)
data(burndown)
summary(burndown)
plot(burndown)
}
\references{
\url{https://en.wikipedia.org/wiki/Burndown_chart}
}
\seealso{
Other things related to burndown data: 
\code{\link{as.burndown}()},
\code{\link{burndown-class}},
\code{\link{burndown}},
\code{\link{read.burndown}()},
\code{\link{summary,burndown-method}}
}
\author{
Dan Kelley
}
\concept{things related to burndown data}
