% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filecache.R
\name{get_filepath}
\alias{get_filepath}
\title{Retrieve the path to a single file from the package cache.}
\usage{
get_filepath(pkg_info, relative_filename, mustWork = TRUE)
}
\arguments{
\item{pkg_info, }{named list. Package identifier, see get_pkg_info() on how to get one.}

\item{relative_filename, }{string. A filename, relative to the package cache.}

\item{mustWork, }{logical. Whether an error should be created if the file does not exist.}
}
\value{
string. The path to the file. If mustWork=TRUE, the file is guaranteed to exist if the function returns (an error will occur if it does not). If mustWork=FALSE and the file does not exist, the empty string is returned.
}
\description{
Retrieve the path to a single file from the package cache.
}
\examples{
    pkg_info = get_pkg_info("mypackage")
    full_path_of_file = get_filepath(pkg_info, "file1.txt", mustWork=FALSE)

}
