% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optimize_pi_ratings.R
\name{optimize_pi_ratings}
\alias{optimize_pi_ratings}
\title{Optimize Pi Ratings}
\usage{
optimize_pi_ratings(teams, outcomes, lambda_in, gamma_in, b_in, c_in)
}
\arguments{
\item{teams}{an (n x 2) character matrix,
contains unique names for the respective home and away teams in n
subsequent matches}

\item{outcomes}{an (n x 2) numeric matrix,
contains the points that the respective home and away teams scored in n
subsequent matches}

\item{lambda_in}{a numerical vector, learning rate values to consider in
the grid optimization, default value: seq(0, 0.1, 0.005)}

\item{gamma_in}{a numerical vector, learning rate values to consider in
the grid optimization, default value: seq(0, 1, 0.05)}

\item{b_in}{a constant, logarithmic base, default value: 10}

\item{c_in}{a constant, default value: 3}
}
\value{
a dataframe with the results of the grid optimization,
the mean squared error for every combination of learning rates
lambda and gamma specified in the parameter vectors
}
\description{
This function performs grid optimization on a prespecified set
of parameters to find the optimal learning rates for calculating
the pi ratings for sport teams in competitive matches
for a set of teams in their respective set of sport matches.
The pi rating system was developed by Constantinou and
Fenton Constantinou and Fenton (2013)
<doi:10.1515/jqas-2012-0036>
}
\examples{
# toy example
teams <- matrix(c("team A", "team B", "team B", "team A"), nrow = 2)
outcomes <- matrix(c(1, 3, 2, 1), nrow = 2)
optimize_pi_ratings(teams, outcomes, seq(0.05, 0.07, 0.005), seq(0.4, 0.6, 0.05))
}
