% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/legacy_local.R
\name{legacy_local}
\alias{legacy_local}
\alias{board_register_local}
\alias{legacy_temp}
\title{Local board (legacy API)}
\usage{
legacy_local(path = NULL, name = "local", versions = FALSE)

board_register_local(name = "local", cache = NULL, ...)

legacy_temp(name = "temp", ...)
}
\arguments{
\item{path}{Path where pins will be stored. If not supplied, defaults
to a system \strong{cache} directory, which may be deleted by the operating
system if you run out of disk space.}

\item{name}{An optional name used identify the board. This is no longer
generally needed since you should be passing around an explicit
board object.}

\item{versions}{Should this board be registered with support for versions?}

\item{cache}{Cache path. Every board requires a local cache to avoid
downloading files multiple times. The default stores in a standard
cache location for your operating system, but you can override if needed.}

\item{...}{Additional parameters required to initialize a particular board.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}

\code{legacy_local()} powers \code{board_register_local()}, which allows you to
access local pins created in earlier versions of the pins package. For
new pins, we recommend that you transition to \code{\link[=board_local]{board_local()}} which
supports the new pins API.

\code{legacy_temp()} creates a legacy board in a temporary location, for use
in tests and examples.
}
\examples{
\dontrun{
# Old api
pin(data.frame(x = 1:3), "test")
pin_get("test")

# New api
board <- board_local()
board \%>\% pin_write(data.frame(x = 1:3), "test")
board \%>\% pin_read("test")
}
}
\keyword{internal}
