% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{plotTruncatedTree}
\alias{plotTruncatedTree}
\title{Plot truncated tree visualization}
\usage{
plotTruncatedTree(
  x,
  layout = c("circular", "dendrogram"),
  collapse_to = c("asc_subgroup", "iuis_subgroup", "family"),
  label_style = c("asc", "iuis", "both"),
  show_threshold_line = TRUE,
  threshold = 0.25,
  tip_size_by = "n_alleles",
  tip_color_by = "present",
  show_heatmap = TRUE,
  label_size = 7,
  ...
)
}
\arguments{
\item{x}{A GermlineCluster object from \code{\link{inferAlleleClusters}}}

\item{layout}{Tree layout: "circular" (default) or "dendrogram"}

\item{collapse_to}{Level to collapse tree: "asc_subgroup" (default, based on ASC names),
"iuis_subgroup" (based on original IUIS gene names), or "family"}

\item{label_style}{Label style for tips: "asc" (default, show ASC names like IGHVF1-G1),
"iuis" (show IUIS names with superscript markers if ASC splits IUIS group),
or "both" (show both names)}

\item{show_threshold_line}{Logical. Show threshold line on tree. Default is TRUE.}

\item{threshold}{Threshold height for threshold line (0-1 scale). Default is 0.25.}

\item{tip_size_by}{Variable for tip point size: "n_alleles" (default), "fixed", or NULL}

\item{tip_color_by}{Variable for tip point color: "present" (default), "fraction_novel", or NULL}

\item{show_heatmap}{Logical. Show heatmap annotation for IUIS vs ASC families. Default is TRUE.}

\item{label_size}{Size of tip labels. Default is 7.}

\item{...}{Additional arguments passed to ggtree}
}
\value{
A ggplot/ggtree object
}
\description{
Creates a circular or dendrogram tree visualization collapsed to ASC subgroup level,
with optional heatmap annotations showing family assignments.
}
\details{
This function creates a publication-quality tree visualization that:
\itemize{
\item Renames tree tips from original allele names to ASC names (new_allele)
\item Collapses alleles to ASC subgroup level (single representative per ASC group)
\item Shows tip point size by number of alleles in cluster
\item Adds optional heatmap track showing IUIS vs ASC family assignments
\item Draws threshold line at specified height
}

When using \code{label_style = "iuis"}, if multiple ASC groups split a single IUIS
subgroup, the labels are marked with superscript letters (e.g., IGHV1-2^A, IGHV1-2^B)
to distinguish them.

Requires the ggtree package to be installed.
}
\examples{
\donttest{
data(HVGERM)
asc <- inferAlleleClusters(HVGERM[1:50])

# Basic truncated tree with ASC labels
if (requireNamespace("ggtree", quietly = TRUE)) {
  plotTruncatedTree(asc, show_heatmap = FALSE)

  # With IUIS labels (marked if ASC splits IUIS group)
  plotTruncatedTree(asc, label_style = "iuis", show_heatmap = FALSE)
}
}

}
\seealso{
\code{\link{inferAlleleClusters}}, \code{\link{plot.GermlineCluster}}
}
