% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/branch.length.R
\name{species.tip.length}
\alias{species.tip.length}
\title{Compute species tip length}
\usage{
species.tip.length(tree = NULL, edge.info = NULL, ...)
}
\arguments{
\item{tree}{phylo. A dated tree.}

\item{edge.info}{Object returned by \code{\link{tip.root.path}} consisting of
a list containing the edge matrix (H1) with the path from tip to root and and
a numeric vector (edge.length) giving the length of each branch of the tree.}

\item{...}{additional arguments to be passed passed down from a calling
function.}
}
\value{
returns a numeric vector giving the length of species branch.
}
\description{
Computation of species tip length using a phylogeny.
}
\details{
Calculates tip lengths for all species in a phylogeny
}
\examples{
library(phyloraster)
tree <- ape::read.tree(system.file("extdata", "tree.nex",
package="phyloraster"))

species.tip.length(tree)

library(ape)
set.seed(1)
tree <- rtree(n=40)

plot(tree)

species.tip.length(tree)

edge.info <- tip.root.path(tree)

species.tip.length(edge.info = edge.info)

}
\author{
Neander M. Heming
}
