% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phylocanvas.R
\name{phylocanvas}
\alias{phylocanvas}
\title{phylocanvas}
\usage{
phylocanvas(tree, treetype = "rectangular", nodestyles = NULL,
  nodesize = 30, textsize = 30, linewidth = 3, showlabels = TRUE,
  alignlabels = FALSE, showhistory = FALSE, showcontextmenu = TRUE,
  showscalebar = FALSE, width = NULL, height = NULL, elementId = NULL)
}
\arguments{
\item{tree}{Required. Newick string of a phyloseq tree, \code{\link[ape]{phylo}} class object,
\code{\link[phylobase]{phylo4}} class object,, or path to newick-containing file.}

\item{treetype}{Optional. Default \code{"rectangular"}. Can be one of "rectengular", "circular",
"hierarchical", "diagonal", or "radial".}

\item{nodestyles}{Optional. Default \code{NULL}. Let nodes b stylized.}

\item{nodesize}{Optional. Default \code{30}. Global nodesize.}

\item{textsize}{Optional. Default \code{30}. Global textsize.}

\item{linewidth}{Optional. Default \code{3}. Global linewidth.}

\item{showlabels}{Optional. Default \code{TRUE}. Whether to show labels.}

\item{alignlabels}{Optional. Default \code{FALSE}. Whether to align node labels}

\item{showhistory}{Optional. Default \code{FALSE}. Whether to use/show the history plugin.}

\item{showcontextmenu}{Optional. Default \code{TRUE}. Whether to use/show the mouse context menu.}

\item{showscalebar}{Optional. Default \code{FALSE}. Whether to use/show the scalebar.}

\item{width}{Optional. Default \code{NULL}. HTMLWidget width}

\item{height}{Optional. Default \code{NULL}. HTMLWidget width}

\item{elementId}{Optional. Default \code{NULL}. HTMLWidget ID}
}
\description{
An html widget wrapper of the \href{http://phylocanvas.org}{phylocanvas.js} JS library.
}
