% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.descendants.R
\name{get.descendants}
\alias{get.descendants}
\title{get descendants}
\usage{
get.descendants(tree, nodename)
}
\arguments{
\item{tree}{Required. A \code{\link[phylobase]{phylo4}} object.}

\item{nodename}{Required. A character corresponding to an internal node.}
}
\value{
a character vector of descendant names
}
\description{
get the names of the tips of descendants given a tree
and the name of an internal node.
}
\examples{
birdfile <- system.file("treedata/birdfamilies.tree", package="phylocanvas")
tree <- load.tree(birdfile)
node <- phylobase::MRCA(tree, c("Cerylidae", "Upupidae"))
get.descendants(tree, node)

}
