% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/waffle.R
\name{waffle_icon}
\alias{waffle_icon}
\title{Waffle plot with icons}
\usage{
waffle_icon(
  values,
  colors,
  icons,
  ncol = 10,
  nrow = 10,
  flow = c("row", "column"),
  legend = TRUE,
  width = NULL
)
}
\arguments{
\item{values}{A vector of values to be plotted.}

\item{colors}{Colors to use for each unique values.}

\item{icons}{Icon or list of icons associated to unique values.}

\item{ncol, nrow}{Number of column and row in the matrix.}

\item{flow}{Populate matrix by rows or columns.}

\item{legend}{Logical, display or not a legend.}

\item{width}{Width of the matrix.}
}
\value{
HTML tags.
}
\description{
Waffle plot with icons
}
\examples{
library(phosphoricons)

waffle_icon(
  values = sort(sample(c("Aa", "Bb", "Cc"), 100, TRUE)),
  colors = c("#81F4E1", "#56CBF9", "#FF729F"),
  icons = ph("user", weight = "fill", height = 32)
)

waffle_icon(
  values = sample(c("Cats", "Dogs"), 200, TRUE),
  colors = list(
    Cats = "#456990",
    Dogs = "#F45B69"
  ),
  icons = list(
    Cats = ph("cat", height = NULL),
    Dogs = ph("dog", height = NULL)
  ),
  ncol = 15,
  nrow = 8,
  width = "500px"
)
}
