% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search.R
\name{ph_search}
\alias{ph_search}
\title{Search phones}
\usage{
ph_search(phlist, phonex)
}
\arguments{
\item{phlist}{The output of \code{phonetise()}.}

\item{phonex}{A phonetic expression. Supported shorthands are \code{C} for
consonant, \code{V} for vowel, and \verb{#} for word boundary.}
}
\value{
A list.
}
\description{
Given a vector of phonetised strings, find phones.
}
\examples{
ipa <- c("p\u02B0a\u0303k\u02B0", "t\u02B0um\u0325", "\u025Bk\u02B0\u026F", "pun")
ph <- c("p\u02B0", "t\u02B0", "k\u02B0", "a\u0303", "m\u0325")
ipa_ph <- phonetise(ipa, multi = ph)
ph_search(ipa_ph, "#CV")

# partial matches are also returned
ph_search(ipa_ph, "p")

# use regular expressions
ph_search(ipa_ph, "p\u02B0?V")
}
