% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set-relations.R
\name{phint_within}
\alias{phint_within}
\title{Test whether a datetime or phinterval is within another phinterval}
\usage{
phint_within(x, phint, bounds = c("[]", "()"))
}
\arguments{
\item{x}{\verb{[phinterval / Interval / Date / POSIXct / POSIXlt]}

The object to test.}

\item{phint}{\verb{[phinterval / Interval]}

A \verb{<phinterval>} or \verb{<Interval>} vector.}

\item{bounds}{\verb{["[]" / "()"]}

Whether span endpoints are inclusive or exclusive:
\itemize{
\item \code{"[]"} (default): Closed intervals - both endpoints are included
\item \code{"()"}: Open intervals - both endpoints are excluded
}

This affects adjacency and overlap detection. For example, with \code{bounds = "[]"},
the intervals \verb{[1, 5]} and \verb{[5, 10]} are considered adjacent (they share the
endpoint 5), while with \code{bounds = "()"}, \verb{(1, 5)} and \verb{(5, 10)} are disjoint
(neither includes 5).}
}
\value{
A logical vector.
}
\description{
\code{phint_within()} tests whether the i-th element of \code{x} is contained within
the i-th element of \code{phint}, returning a logical vector. \code{x} may be a datetime
(Date, POSIXct, POSIXlt), \code{\link[lubridate:interval]{lubridate::interval()}}, or \code{\link[=phinterval]{phinterval()}}, while
\code{phint} must be a \code{\link[lubridate:interval]{lubridate::interval()}} or \code{\link[=phinterval]{phinterval()}}. \code{x} and \code{phint}
are recycled to their common length using vctrs-style recycling rules.

Datetimes on an endpoint of an interval are considered to be within the
interval. An interval is considered to be within itself.
}
\examples{
jan_1_to_5 <- interval(as.Date("2000-01-01"), as.Date("2000-01-05"))
jan_2_to_4 <- interval(as.Date("2000-01-02"), as.Date("2000-01-04"))
jan_3_to_9 <- interval(as.Date("2000-01-03"), as.Date("2000-01-09"))

phint_within(
  c(jan_2_to_4, jan_3_to_9, jan_1_to_5),
  c(jan_1_to_5, jan_1_to_5, NA)
)

phint_within(as.Date(c("2000-01-06", "2000-01-20")), jan_3_to_9)

# Intervals are within themselves
phint_within(jan_1_to_5, jan_1_to_5)

# By default, interval endpoints are considered within
phint_within(as.Date("2000-01-01"), jan_1_to_5)

# Use bounds to consider intervals as exclusive of endpoints
phint_within(as.Date("2000-01-01"), jan_1_to_5, bounds = "()")

# Holes are never within any interval (including other holes)
hole <- hole()
phint_within(c(hole, hole), c(hole, jan_1_to_5))

}
