% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pedtricks-package.R
\docType{package}
\name{pedtricks-package}
\alias{pedtricks}
\alias{pedtricks-package}
\title{pedtricks: Visualize, Summarize and Simulate Data from Pedigrees}
\description{
Sensitivity and power analysis, for calculating statistics describing pedigrees from wild populations, and for visualizing pedigrees. This is a reboot of the methods developed by Morrissey and Wilson (2010) \doi{ 10.1111/j.1755-0998.2009.02817.x}.
}
\details{
\itemize{
\item \code{pedigreeStats()} and \code{pedStatSummary()} have been replaced by \code{ped_stats()} with a \code{summary()} and \code{plot()} methods to simplify the workflow and allow to get the plots without running the statistics each time
\item \code{makePedigreeFactor()} and \code{makePedigreeNumeric()} have been combined in \code{convert_ped()} which convert a pedigree to numeric or factor
\item \code{fixPedigree()} is now \code{fix_ped()}
\item \code{genomesim()}, \code{microsim()} and \code{phensim()} have been renamed as \code{genome_sim()}, \code{micro_sim()} and \code{phen_sim()}
}

For backward compatibility with code using \code{pedantics} older names are still usable but not recommended.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://juliengamartin.github.io/pedtricks/}
  \item Report bugs at \url{https://github.com/JulienGAMartin/pedtricks/issues}
}

}
\author{
\strong{Maintainer}: Julien Martin \email{julien.martin@uottawa.ca} (\href{https://orcid.org/0000-0001-7726-6809}{ORCID})

Authors:
\itemize{
  \item Matthew Wolak \email{mew0099@auburn.edu} (\href{https://orcid.org/0000-0002-7962-0071}{ORCID})
  \item Susan Johnston \email{Susan.Johnston@ed.ac.uk} (\href{https://orcid.org/0000-0002-5623-8902}{ORCID})
  \item Joel Pick \email{joel.l.pick@gmail.com} (\href{https://orcid.org/0000-0002-6295-3742}{ORCID})
  \item Michael Morrissey \email{michael.morrissey@st-andrews.ac.uk} (\href{https://orcid.org/0000-0001-6209-0177}{ORCID})
}

}
\keyword{internal}
