% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weight_for_stature.R
\name{weight_for_stature}
\alias{weight_for_stature}
\alias{weight_for_length}
\alias{weight_for_height}
\alias{p_weight_for_height}
\alias{q_weight_for_height}
\alias{z_weight_for_height}
\alias{p_weight_for_length}
\alias{q_weight_for_length}
\alias{z_weight_for_length}
\title{Weight for Stature - Pediatric Growth Standard}
\usage{
p_weight_for_height(
  q,
  male,
  height,
  source = getOption("pedbp_pgs_source", "CDC"),
  ...
)

q_weight_for_height(
  p,
  male,
  height,
  source = getOption("pedbp_pgs_source", "CDC"),
  ...
)

z_weight_for_height(
  q,
  male,
  height,
  source = getOption("pedbp_pgs_source", "CDC"),
  ...
)

p_weight_for_length(
  q,
  male,
  length,
  source = getOption("pedbp_pgs_source", "CDC"),
  ...
)

q_weight_for_length(
  p,
  male,
  length,
  source = getOption("pedbp_pgs_source", "CDC"),
  ...
)

z_weight_for_length(
  q,
  male,
  length,
  source = getOption("pedbp_pgs_source", "CDC"),
  ...
)
}
\arguments{
\item{q}{a vector of quantiles}

\item{male}{integer value, 1 = male, 0 = female}

\item{source}{a character string denoting the data source providing the
parameters needed for the estimate.  Valid values are "CDC" and "WHO".  This
can be set explicitly, or by using the \code{pedbp_pgs_source} option.}

\item{...}{pass through}

\item{p}{a vector of probabilities}

\item{length, height}{in centimeters}
}
\value{
\code{p_} method return values from the estimated distribution function.

\code{q_} methods return values from the estimated quantile function.

\code{z_} methods return standard scores.
}
\description{
Weight for stature quantile, distribution, and zscore function based on LMS data
from the CDC and WHO.
}
\details{
Length or height values are used.  Length is assess when the patient is lying
down versus height when the patient is standing.  There is an implication of
younger patients being in the _for_length set.  There is some overlap in
numeric values of length and height.
}
\section{Notes}{
 CDC Recommends using WHO growth charts for infants and
children ages 0 to 2 years of age in the U.S. and CDC growth charts to
monitor growth for children age 2 years and older in the U.S.
}

\examples{
# The 60th weight qualtile for a 1.2 meter tall male is
q_weight_for_height(p = 0.60, male = 1, height = 120, source = "CDC")
q_weight_for_height(p = 0.60, male = 1, height = 120, source = "WHO")

# There are slight differences in the quantiles for length and height
q_weight_for_length(p = 0.60, male = 1, length = 97, source = "CDC")
q_weight_for_height(p = 0.60, male = 1, height = 97, source = "CDC")

# percentiles and standard scores for a 14 kg, 88 cm tall/long male
p_weight_for_height(q = 14, male = 1, height = 88, source = "CDC")
p_weight_for_height(q = 14, male = 1, height = 88, source = "WHO")
p_weight_for_length(q = 14, male = 1, length = 88, source = "CDC")
p_weight_for_length(q = 14, male = 1, length = 88, source = "WHO")

# correseponding standard scores
z_weight_for_height(q = 14, male = 1, height = 88, source = "CDC")
z_weight_for_height(q = 14, male = 1, height = 88, source = "WHO")
z_weight_for_length(q = 14, male = 1, length = 88, source = "CDC")
z_weight_for_length(q = 14, male = 1, length = 88, source = "WHO")


}
\references{
\url{https://www.cdc.gov/growthcharts/percentile_data_files.htm},
\url{https://www.who.int/tools/child-growth-standards/standards}
}
\seealso{
\itemize{
\item Distribution functions:
  \itemize{
    \item \code{\link{bmi_for_age}}
    \item \code{\link{head_circumference_for_age}}
    \item \code{\link{height_for_age}}
    \item \code{\link{length_for_age}}
    \item \code{\link{weight_for_age}}
    \item \code{\link{weight_for_length}}
    \item \code{\link{weight_for_height}}
  }
\item Plotting functions:
  \itemize{
    \item \code{\link{gs_chart}}
    \item \code{\link{gs_cdf}}
  }
\item Vignette:
  \itemize{
    \item \code{vignette(topic = "growth-standards", package = "pedbp")}
  }
}
}
