% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/other_software.R
\name{plot_checkm2_res}
\alias{plot_checkm2_res}
\title{Visualize CheckM2 Genome Quality Assessment Results}
\usage{
plot_checkm2_res(
  checkm2_df,
  add_marginal = TRUE,
  marginal_type = "density",
  point_size = 0.6,
  base_size = 14,
  quality_thresholds = list(high_comp = 90, high_contam = 5, med_comp = 70, med_contam =
    10),
  filter_data = TRUE,
  min_quality_score = 50,
  min_completeness = 50,
  max_contamination = 10
)
}
\arguments{
\item{checkm2_df}{Data frame. CheckM2 results containing at least columns:
'Completeness', 'Contamination', and 'Name'.}

\item{add_marginal}{Logical. Whether to add marginal density plots using ggExtra.
Default is TRUE.}

\item{marginal_type}{Character. Type of marginal plot: "density", "histogram",
"boxplot", or "violin". Default is "density".}

\item{point_size}{Numeric. Size of points in scatter plot. Default is 0.6.}

\item{base_size}{Numeric. Base font size for the plot. Default is 14.}

\item{quality_thresholds}{List. Custom thresholds for quality classification.
Default list(high_comp = 90, high_contam = 5, med_comp = 70, med_contam = 10)}

\item{filter_data}{Logical. Whether to filter low-quality genomes. Default is TRUE.}

\item{min_quality_score}{Numeric. Minimum quality score for filtering. Default is 50.}

\item{min_completeness}{Numeric. Minimum completeness for filtering. Default is 50.}

\item{max_contamination}{Numeric. Maximum contamination for filtering. Default is 10.}
}
\value{
A ggplot object or ggExtra plot object if marginal plots are added.
}
\description{
This function creates a scatter plot showing genome completeness vs contamination
with optional marginal density plots to display distributions.
}
