% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/b_analyse.R
\name{myRDA}
\alias{myRDA}
\alias{myCCA}
\alias{myCAP}
\alias{mydbRDA}
\title{RDA}
\usage{
myRDA(
  otutab,
  env,
  norm = TRUE,
  scale = FALSE,
  choose_var = FALSE,
  direction = "forward",
  nperm = 499,
  verbose = TRUE,
  method = "rda",
  dist = "bray"
)

myCCA(
  otutab,
  env,
  norm = TRUE,
  scale = FALSE,
  choose_var = FALSE,
  nperm = 499,
  verbose = TRUE
)

myCAP(
  otutab,
  env,
  norm = TRUE,
  scale = FALSE,
  choose_var = FALSE,
  nperm = 499,
  verbose = TRUE,
  dist = "bray"
)
}
\arguments{
\item{otutab}{an otutab data.frame, samples are columns, taxs are rows.}

\item{env}{environmental factors}

\item{norm}{should normalize? (default:TRUE)}

\item{scale}{should scale species? (default:FALSE)}

\item{choose_var}{should choose variables? use forward step}

\item{direction}{The direction of the stepwise selection, "both", "forward" or "backward", default is "forward"}

\item{nperm}{number of permutation}

\item{verbose}{verbose}

\item{method}{"rda", "cca", "cap", "dbrda"}

\item{dist}{The name of the dissimilarity (or distance) index for "cap" or "dbrda", for \code{\link[vegan]{vegdist}}}
}
\value{
rda/cca
}
\description{
RDA
}
\examples{
data(otutab, package = "pcutils")
env <- metadata[, 6:10]
# RDA
myRDA(otutab, env) -> phy.rda
RDA_plot(phy.rda, "Group", metadata)
}
\seealso{
\code{\link[vegan]{vegdist};\link[picante]{unifrac}}
}
