% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pcensmix.R
\name{mixgen}
\alias{mixgen}
\title{Generating Mixture Datasets}
\usage{
mixgen(N, dist1, dist2, control)
}
\arguments{
\item{N}{population size.}

\item{dist1, dist2}{respective distributions of the first and second mixture
components to be simulated from. For Normal, Log-normal, Weibull, Gamma,
Cauchy and Beta distributions, they must be provided as \code{'norm'},
\code{'lnorm'}, \code{'weibull'}, \code{'gamma'}, \code{'cauchy'} and
\code{'beta'} respectively. The Exponential distribution can be included as
a Gamma distribution with scale parameter one.}

\item{control}{a list of parameters for controlling the simulation process.
This includes parameters of the first and second mixture component
distributions and the mixture proportion \eqn{\pi} which should be provided
in the order mentioned, i.e., parameters for the first component come
first, those of the second component come after and then the value of the
mixing proportion. All values should be provided in a list of numerics.
Note parameters for each component distribution should be added in the
order as required in their generator functions, see
\code{\link[stats]{rnorm}}, \code{\link[stats]{rlnorm}},
\code{\link[stats]{rweibull}}, \code{\link[stats]{rgamma}},
\code{\link[stats]{rcauchy}} and \code{\link[stats]{rbeta}}.}
}
\value{
An object of class \code{data.frame} containing the following
  information: \item{z}{mixture data} \item{label}{component indicator}
}
\description{
This function generates two-component mixture data from a various different
mixture distributions.
}
\details{
It generates a two-component mixture dataset from a density function
  \deqn{\pi f_1 + (1 - \pi) f_2,}{%
  \pi f_1 + (1 - \pi) f_2,} where \eqn{f_1} and \eqn{f_2} are the first
  and the second mixture component distributions respectively.
}
\examples{
## Generate a sample from a two component Normal-Weibull mixture distribution
## with mixing components as N(12, 2) and Weibull(15, 4), mixing proportion 0.3
## and size of N = 20.

mixture<- mixgen(N = 20, dist1 = 'norm', dist2 = 'weibull', control = list(12, 2, 15, 4, 0.3))

}
\seealso{
\code{\link[pcensmix]{pcgen}}
}
\author{
Lida Fallah, John Hinde

Maintainer: Lida Fallah <l.fallah22@gmail.com>
}
