% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AuxDelaunay.R
\name{funsAB2CMTe}
\alias{funsAB2CMTe}
\alias{lineA2CMinTe}
\alias{lineB2CMinTe}
\title{The lines joining two vertices to the center of mass
in standard equilateral triangle}
\usage{
lineA2CMinTe(x)

lineB2CMinTe(x)
}
\arguments{
\item{x}{A single scalar or a \code{vector} of scalars
which is the argument of the functions
\code{lineA2CMinTe} and \code{lineB2CMinTe}.}
}
\value{
A \code{list} with the elements
\item{txt1}{Longer description of the line.}
\item{txt2}{Shorter description of the line
(to be inserted over the line in the plot).}
\item{mtitle}{The \code{"main"} title for the plot of the line.}
\item{cent}{The center chosen inside the standard equilateral triangle.}
\item{cent.name}{The name of the center
inside the standard equilateral triangle.
It is \code{"CM"} for these two functions.}
\item{tri}{The triangle (it is the standard equilateral triangle
for this function).}
\item{x}{The input vector, can be a scalar or a \code{vector} of scalars,
which constitute the \eqn{x}-coordinates of the point(s) of interest
on the line.}
\item{y}{The output vector,
will be a scalar if \code{x} is a scalar or a \code{vector} of scalars
if \code{x} is a \code{vector} of scalar,
constitutes the \eqn{y}-coordinates of the point(s) of interest on the line.}
\item{slope}{Slope of the line.}
\item{intercept}{Intercept of the line.}
\item{equation}{Equation of the line.}
}
\description{
Two functions, \code{lineA2CMinTe} and \code{lineB2CMinTe}
of class \code{"TriLines"}.
Returns the \code{equation, slope, intercept},
and \eqn{y}-coordinates of the lines joining \eqn{A} and \eqn{CM} and
also \eqn{B} and \eqn{CM}.

\code{lineA2CMinTe} is the line joining \eqn{A} to the center of mass, \eqn{CM},
and
\code{lineB2CMinTe} is the line joining \eqn{B} to the center of mass, \eqn{CM},
in the standard equilateral triangle \eqn{T_e=(A,B,C)}
with \eqn{A=(0,0)}, \eqn{B=(1,0)}, \eqn{C=(1/2,\sqrt{3}/2)};
\eqn{x}-coordinates are provided in \code{vector} \code{x}.
}
\examples{
\donttest{
#Examples for lineA2CMinTe
A<-c(0,0); B<-c(1,0); C<-c(1/2,sqrt(3)/2);
Te<-rbind(A,B,C)
xfence<-abs(A[1]-B[1])*.25
#how far to go at the lower and upper ends in the x-coordinate
x<-seq(min(A[1],B[1])-xfence,max(A[1],B[1])+xfence,by = .1)  #try also by = .01

lnACM<-lineA2CMinTe(x)
lnACM
summary(lnACM)
plot(lnACM)

CM<-(A+B+C)/3;
D1<-(B+C)/2; D2<-(A+C)/2; D3<-(A+B)/2;
Ds<-rbind(D1,D2,D3)

Xlim<-range(Te[,1])
Ylim<-range(Te[,2])
xd<-Xlim[2]-Xlim[1]
yd<-Ylim[2]-Ylim[1]

plot(Te,pch=".",xlab="",ylab="",xlim=Xlim+xd*c(-.05,.05),ylim=Ylim+yd*c(-.05,.05))
polygon(Te)
L<-Te; R<-Ds
segments(L[,1], L[,2], R[,1], R[,2], lty = 2)

txt<-rbind(Te,CM,D1,D2,D3,c(.25,lineA2CMinTe(.25)$y),c(.75,lineB2CMinTe(.75)$y))
xc<-txt[,1]+c(-.02,.02,.02,.05,.05,-.03,.0,0,0)
yc<-txt[,2]+c(.02,.02,.02,.02,0,.02,-.04,0,0)
txt.str<-c("A","B","C","CM","D1","D2","D3","lineA2CMinTe(x)","lineB2CMinTe(x)")
text(xc,yc,txt.str)

lineA2CMinTe(.25)$y
}

\donttest{
#Examples for lineB2CMinTe
A<-c(0,0); B<-c(1,0); C<-c(1/2,sqrt(3)/2);
Te<-rbind(A,B,C)
xfence<-abs(A[1]-B[1])*.25
#how far to go at the lower and upper ends in the x-coordinate
x<-seq(min(A[1],B[1])-xfence,max(A[1],B[1])+xfence,by = .1)  #try also by = .01

lnBCM<-lineB2CMinTe(x)
lnBCM
summary(lnBCM)
plot(lnBCM,xlab=" x",ylab="y")

lineB2CMinTe(.25)$y
}

}
\seealso{
\code{\link{lineA2MinTe}}, \code{\link{lineB2MinTe}},
and \code{\link{lineC2MinTe}}
}
\author{
Elvan Ceyhan
}
