% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pglm.R
\name{pglm}
\alias{pglm}
\title{Profile Boosting for Generalized Linear Models.}
\usage{
pglm(
  formula,
  family = gaussian,
  data,
  weights,
  subset,
  na.action,
  start = NULL,
  etastart,
  mustart,
  offset,
  control = list(...),
  model = TRUE,
  method = "glm.fit",
  x = FALSE,
  y = TRUE,
  singular.ok = TRUE,
  contrasts = NULL,
  ...,
  stopFun = EBIC,
  keep = NULL,
  maxK = NULL,
  verbose = FALSE
)
}
\arguments{
\item{formula}{See \link{pboost}.}

\item{family}{Parameters passed to \link{glm}.}

\item{data}{See \link{pboost}.}

\item{weights}{Parameters passed to \link{glm}.}

\item{subset}{Parameters passed to \link{glm}.}

\item{na.action}{Parameters passed to \link{glm}.}

\item{start}{Parameters passed to \link{glm}.}

\item{etastart}{Parameters passed to \link{glm}.}

\item{mustart}{Parameters passed to \link{glm}.}

\item{offset}{Parameters passed to \link{glm}.}

\item{control}{Parameters passed to \link{glm}.}

\item{model}{Parameters passed to \link{glm}.}

\item{method}{Parameters passed to \link{glm}.}

\item{x}{Parameters passed to \link{glm}.}

\item{y}{Parameters passed to \link{glm}.}

\item{singular.ok}{Parameters passed to \link{glm}.}

\item{contrasts}{Parameters passed to \link{glm}.}

\item{...}{Parameters passed to \link{glm}.}

\item{stopFun}{Parameters passed to \link{pboost}.}

\item{keep}{Parameters passed to \link{pboost}.}

\item{maxK}{Parameters passed to \link{pboost}.}

\item{verbose}{Parameters passed to \link{pboost}.}
}
\value{
An \code{glm} model object fitted on the selected features.
}
\description{
\link{pglm} inherits the usage of the built-in function \link{glm}.
}
\examples{
set.seed(2025)
n <- 300
p <- 200
x <- matrix(rnorm(n*p), n)

eta <- drop( x[, 1:3] \%*\% runif(3, 1.0, 1.5) )
y <- rbinom(n, 1, 1/(1+exp(-eta)))
DF <- data.frame(y, x)

pglm(y ~ ., "binomial", DF, verbose=TRUE)
pglm(y ~ ., "binomial", DF, stopFun=BIC, verbose=TRUE)

scoreLogistic <- function(object) {
   eta.hat <- object[["linear.predictors"]]
   return(object[["y"]] - 1/(1+exp(-eta.hat)))
}
pboost(y ~ ., DF, glm, scoreLogistic, EBIC, family="binomial", verbose=TRUE)

}
\references{
Zengchao Xu, Shan Luo and Zehua Chen (2022). Partial profile score feature selection
in high-dimensional generalized linear interaction models. Statistics and Its Interface.
\doi{10.4310/21-SII706}
}
