% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pboost.R
\name{pboost}
\alias{pboost}
\title{Profile Boosting Framework}
\usage{
pboost(
  formula,
  data,
  fitFun,
  scoreFun,
  stopFun,
  ...,
  keep = NULL,
  maxK = NULL,
  verbose = FALSE
)
}
\arguments{
\item{formula}{An object of class \link{formula} of the form \code{LHS ~ RHS},
where the right-hand side (RHS) specifies the candidate features
for the linear predictor \eqn{\eta = \sum_j \beta_j x_j}.

The following restrictions and recommendations apply:
\itemize{
\item All variables appearing on the RHS must be numeric in the supplied \code{data}
\item For computational efficiency, each term on the RHS must correspond to a
single column in the resulting model matrix. Supported expressions include
main effects (\code{x1}), interactions (\code{x1:x2}), and simple transformations
(\code{log(x1)}, \code{I(x1^2)}, etc.).
Complex terms that expand into multiple columns—such as \code{poly(x, degree)},
\code{bs(x)}, or \code{ns(x)}—are \strong{not supported}.
\item Offset terms should not be included in the formula. Instead, provide them
via the dedicated \code{offset} argument of \code{fitFun}.
}}

\item{data}{An data frame containing the variables in the model.}

\item{fitFun}{Function to fit the empirical risk function in
the form \code{fitFun(formula, data, ...)}.}

\item{scoreFun}{Function to compute the derivative of empirical
risk function in the form \code{scoreFun(object)}, where \code{object} is
returned by \code{fitFun}.
\code{scoreFun} should return a vector with the same length of \code{y} in \code{data}.}

\item{stopFun}{Stopping rule for profile boosting, which has the form
\code{stopFun(object)} to evaluate the performance of model \code{object} returned
by \code{fitFun}, such as \link{EBIC} or \link{BIC}.}

\item{...}{Additional arguments to be passed to \code{fitFun}.}

\item{keep}{Initial set of features that are included in model fitting.
\strong{If \code{keep} is specified, it should also be fully included in the RHS
of \code{formula}.}}

\item{maxK}{Maximal number of identified features.
If \code{maxK} is specified, it will suppress \code{stopFun}, saying that the
profile boosting continues until the procedure identifies \code{maxK} features.
The pre-specified features in \code{keep} are counted toward \code{maxK}.}

\item{verbose}{Print the procedure path?}
}
\value{
Model object fitted on the selected features.
}
\description{
\code{pboost} is the generic workhorse function of profile boosting
framework for parametric regression.
}
\examples{
set.seed(2025)
n <- 200
p <- 300
x <- matrix(rnorm(n*p), n)
eta <- drop(x[, 1:3] \%*\% runif(3, 1.0, 1.5))
y <- rbinom(n, 1, 1/(1+exp(-eta)))
DF <- data.frame(y, x)

scoreLogistic <- function(object) {
    eta.hat <- object[["linear.predictors"]]
    return(object[["y"]] - 1/(1+exp(-eta.hat)))
}

( result <- pboost(y~., DF, glm, scoreLogistic, EBIC, family="binomial") )

attr(terms(formula(result), data=DF), "term.labels")

}
