% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resiliencehub_operations.R
\name{resiliencehub_list_apps}
\alias{resiliencehub_list_apps}
\title{Lists your Resilience Hub applications}
\usage{
resiliencehub_list_apps(
  appArn = NULL,
  awsApplicationArn = NULL,
  fromLastAssessmentTime = NULL,
  maxResults = NULL,
  name = NULL,
  nextToken = NULL,
  reverseOrder = NULL,
  toLastAssessmentTime = NULL
)
}
\arguments{
\item{appArn}{Amazon Resource Name (ARN) of the Resilience Hub application. The format
for this ARN is:
arn:\code{partition}:resiliencehub:\code{region}:\code{account}:app/\code{app-id}. For more
information about ARNs, see \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html}{Amazon Resource Names (ARNs)}
in the \emph{Amazon Web Services General Reference} guide.}

\item{awsApplicationArn}{Amazon Resource Name (ARN) of Resource Groups group that is integrated
with an AppRegistry application. For more information about ARNs, see
\href{https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html}{Amazon Resource Names (ARNs)}
in the \emph{Amazon Web Services General Reference} guide.}

\item{fromLastAssessmentTime}{Lower limit of the range that is used to filter applications based on
their last assessment times.}

\item{maxResults}{Maximum number of results to include in the response. If more results
exist than the specified \code{MaxResults} value, a token is included in the
response so that the remaining results can be retrieved.}

\item{name}{The name for the one of the listed applications.}

\item{nextToken}{Null, or the token from a previous call to get the next set of results.}

\item{reverseOrder}{The application list is sorted based on the values of
\code{lastAppComplianceEvaluationTime} field. By default, application list is
sorted in ascending order. To sort the application list in descending
order, set this field to \code{True}.}

\item{toLastAssessmentTime}{Upper limit of the range that is used to filter the applications based
on their last assessment times.}
}
\description{
Lists your Resilience Hub applications.

See \url{https://www.paws-r-sdk.com/docs/resiliencehub_list_apps/} for full documentation.
}
\keyword{internal}
