# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include neptune_service.R
NULL

#' Associates an Identity and Access Management (IAM) role with an Neptune
#' DB cluster
#'
#' @description
#' Associates an Identity and Access Management (IAM) role with an Neptune DB cluster.
#'
#' See [https://www.paws-r-sdk.com/docs/neptune_add_role_to_db_cluster/](https://www.paws-r-sdk.com/docs/neptune_add_role_to_db_cluster/) for full documentation.
#'
#' @param DBClusterIdentifier &#91;required&#93; The name of the DB cluster to associate the IAM role with.
#' @param RoleArn &#91;required&#93; The Amazon Resource Name (ARN) of the IAM role to associate with the
#' Neptune DB cluster, for example
#' `arn:aws:iam::123456789012:role/NeptuneAccessRole`.
#' @param FeatureName The name of the feature for the Neptune DB cluster that the IAM role is
#' to be associated with. For the list of supported feature names, see
#' DBEngineVersion.
#'
#' @keywords internal
#'
#' @rdname neptune_add_role_to_db_cluster
neptune_add_role_to_db_cluster <- function(DBClusterIdentifier, RoleArn, FeatureName = NULL) {
  op <- new_operation(
    name = "AddRoleToDBCluster",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .neptune$add_role_to_db_cluster_input(DBClusterIdentifier = DBClusterIdentifier, RoleArn = RoleArn, FeatureName = FeatureName)
  output <- .neptune$add_role_to_db_cluster_output()
  config <- get_config()
  svc <- .neptune$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.neptune$operations$add_role_to_db_cluster <- neptune_add_role_to_db_cluster

#' Adds a source identifier to an existing event notification subscription
#'
#' @description
#' Adds a source identifier to an existing event notification subscription.
#'
#' See [https://www.paws-r-sdk.com/docs/neptune_add_source_identifier_to_subscription/](https://www.paws-r-sdk.com/docs/neptune_add_source_identifier_to_subscription/) for full documentation.
#'
#' @param SubscriptionName &#91;required&#93; The name of the event notification subscription you want to add a source
#' identifier to.
#' @param SourceIdentifier &#91;required&#93; The identifier of the event source to be added.
#' 
#' Constraints:
#' 
#' -   If the source type is a DB instance, then a `DBInstanceIdentifier`
#'     must be supplied.
#' 
#' -   If the source type is a DB security group, a `DBSecurityGroupName`
#'     must be supplied.
#' 
#' -   If the source type is a DB parameter group, a `DBParameterGroupName`
#'     must be supplied.
#' 
#' -   If the source type is a DB snapshot, a `DBSnapshotIdentifier` must
#'     be supplied.
#'
#' @keywords internal
#'
#' @rdname neptune_add_source_identifier_to_subscription
neptune_add_source_identifier_to_subscription <- function(SubscriptionName, SourceIdentifier) {
  op <- new_operation(
    name = "AddSourceIdentifierToSubscription",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .neptune$add_source_identifier_to_subscription_input(SubscriptionName = SubscriptionName, SourceIdentifier = SourceIdentifier)
  output <- .neptune$add_source_identifier_to_subscription_output()
  config <- get_config()
  svc <- .neptune$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.neptune$operations$add_source_identifier_to_subscription <- neptune_add_source_identifier_to_subscription

#' Adds metadata tags to an Amazon Neptune resource
#'
#' @description
#' Adds metadata tags to an Amazon Neptune resource. These tags can also be used with cost allocation reporting to track cost associated with Amazon Neptune resources, or used in a Condition statement in an IAM policy for Amazon Neptune.
#'
#' See [https://www.paws-r-sdk.com/docs/neptune_add_tags_to_resource/](https://www.paws-r-sdk.com/docs/neptune_add_tags_to_resource/) for full documentation.
#'
#' @param ResourceName &#91;required&#93; The Amazon Neptune resource that the tags are added to. This value is an
#' Amazon Resource Name (ARN). For information about creating an ARN, see
#' [Constructing an Amazon Resource Name
#' (ARN)](https://docs.aws.amazon.com/neptune/latest/userguide/#tagging.ARN.Constructing).
#' @param Tags &#91;required&#93; The tags to be assigned to the Amazon Neptune resource.
#'
#' @keywords internal
#'
#' @rdname neptune_add_tags_to_resource
neptune_add_tags_to_resource <- function(ResourceName, Tags) {
  op <- new_operation(
    name = "AddTagsToResource",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .neptune$add_tags_to_resource_input(ResourceName = ResourceName, Tags = Tags)
  output <- .neptune$add_tags_to_resource_output()
  config <- get_config()
  svc <- .neptune$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.neptune$operations$add_tags_to_resource <- neptune_add_tags_to_resource

#' Applies a pending maintenance action to a resource (for example, to a DB
#' instance)
#'
#' @description
#' Applies a pending maintenance action to a resource (for example, to a DB instance).
#'
#' See [https://www.paws-r-sdk.com/docs/neptune_apply_pending_maintenance_action/](https://www.paws-r-sdk.com/docs/neptune_apply_pending_maintenance_action/) for full documentation.
#'
#' @param ResourceIdentifier &#91;required&#93; The Amazon Resource Name (ARN) of the resource that the pending
#' maintenance action applies to. For information about creating an ARN,
#' see [Constructing an Amazon Resource Name
#' (ARN)](https://docs.aws.amazon.com/neptune/latest/userguide/#tagging.ARN.Constructing).
#' @param ApplyAction &#91;required&#93; The pending maintenance action to apply to this resource.
#' 
#' Valid values: `system-update`, `db-upgrade`
#' @param OptInType &#91;required&#93; A value that specifies the type of opt-in request, or undoes an opt-in
#' request. An opt-in request of type `immediate` can't be undone.
#' 
#' Valid values:
#' 
#' -   `immediate` - Apply the maintenance action immediately.
#' 
#' -   `next-maintenance` - Apply the maintenance action during the next
#'     maintenance window for the resource.
#' 
#' -   `undo-opt-in` - Cancel any existing `next-maintenance` opt-in
#'     requests.
#'
#' @keywords internal
#'
#' @rdname neptune_apply_pending_maintenance_action
neptune_apply_pending_maintenance_action <- function(ResourceIdentifier, ApplyAction, OptInType) {
  op <- new_operation(
    name = "ApplyPendingMaintenanceAction",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .neptune$apply_pending_maintenance_action_input(ResourceIdentifier = ResourceIdentifier, ApplyAction = ApplyAction, OptInType = OptInType)
  output <- .neptune$apply_pending_maintenance_action_output()
  config <- get_config()
  svc <- .neptune$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.neptune$operations$apply_pending_maintenance_action <- neptune_apply_pending_maintenance_action

#' Copies the specified DB cluster parameter group
#'
#' @description
#' Copies the specified DB cluster parameter group.
#'
#' See [https://www.paws-r-sdk.com/docs/neptune_copy_db_cluster_parameter_group/](https://www.paws-r-sdk.com/docs/neptune_copy_db_cluster_parameter_group/) for full documentation.
#'
#' @param SourceDBClusterParameterGroupIdentifier &#91;required&#93; The identifier or Amazon Resource Name (ARN) for the source DB cluster
#' parameter group. For information about creating an ARN, see
#' [Constructing an Amazon Resource Name
#' (ARN)](https://docs.aws.amazon.com/neptune/latest/userguide/#tagging.ARN.Constructing).
#' 
#' Constraints:
#' 
#' -   Must specify a valid DB cluster parameter group.
#' 
#' -   If the source DB cluster parameter group is in the same Amazon
#'     Region as the copy, specify a valid DB parameter group identifier,
#'     for example `my-db-cluster-param-group`, or a valid ARN.
#' 
#' -   If the source DB parameter group is in a different Amazon Region
#'     than the copy, specify a valid DB cluster parameter group ARN, for
#'     example
#'     `arn:aws:rds:us-east-1:123456789012:cluster-pg:custom-cluster-group1`.
#' @param TargetDBClusterParameterGroupIdentifier &#91;required&#93; The identifier for the copied DB cluster parameter group.
#' 
#' Constraints:
#' 
#' -   Cannot be null, empty, or blank
#' 
#' -   Must contain from 1 to 255 letters, numbers, or hyphens
#' 
#' -   First character must be a letter
#' 
#' -   Cannot end with a hyphen or contain two consecutive hyphens
#' 
#' Example: `my-cluster-param-group1`
#' @param TargetDBClusterParameterGroupDescription &#91;required&#93; A description for the copied DB cluster parameter group.
#' @param Tags The tags to be assigned to the copied DB cluster parameter group.
#'
#' @keywords internal
#'
#' @rdname neptune_copy_db_cluster_parameter_group
neptune_copy_db_cluster_parameter_group <- function(SourceDBClusterParameterGroupIdentifier, TargetDBClusterParameterGroupIdentifier, TargetDBClusterParameterGroupDescription, Tags = NULL) {
  op <- new_operation(
    name = "CopyDBClusterParameterGroup",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .neptune$copy_db_cluster_parameter_group_input(SourceDBClusterParameterGroupIdentifier = SourceDBClusterParameterGroupIdentifier, TargetDBClusterParameterGroupIdentifier = TargetDBClusterParameterGroupIdentifier, TargetDBClusterParameterGroupDescription = TargetDBClusterParameterGroupDescription, Tags = Tags)
  output <- .neptune$copy_db_cluster_parameter_group_output()
  config <- get_config()
  svc <- .neptune$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.neptune$operations$copy_db_cluster_parameter_group <- neptune_copy_db_cluster_parameter_group

#' Copies a snapshot of a DB cluster
#'
#' @description
#' Copies a snapshot of a DB cluster.
#'
#' See [https://www.paws-r-sdk.com/docs/neptune_copy_db_cluster_snapshot/](https://www.paws-r-sdk.com/docs/neptune_copy_db_cluster_snapshot/) for full documentation.
#'
#' @param SourceDBClusterSnapshotIdentifier &#91;required&#93; The identifier of the DB cluster snapshot to copy. This parameter is not
#' case-sensitive.
#' 
#' Constraints:
#' 
#' -   Must specify a valid system snapshot in the "available" state.
#' 
#' -   Specify a valid DB snapshot identifier.
#' 
#' Example: `my-cluster-snapshot1`
#' @param TargetDBClusterSnapshotIdentifier &#91;required&#93; The identifier of the new DB cluster snapshot to create from the source
#' DB cluster snapshot. This parameter is not case-sensitive.
#' 
#' Constraints:
#' 
#' -   Must contain from 1 to 63 letters, numbers, or hyphens.
#' 
#' -   First character must be a letter.
#' 
#' -   Cannot end with a hyphen or contain two consecutive hyphens.
#' 
#' Example: `my-cluster-snapshot2`
#' @param KmsKeyId The Amazon Amazon KMS key ID for an encrypted DB cluster snapshot. The
#' KMS key ID is the Amazon Resource Name (ARN), KMS key identifier, or the
#' KMS key alias for the KMS encryption key.
#' 
#' If you copy an encrypted DB cluster snapshot from your Amazon account,
#' you can specify a value for `KmsKeyId` to encrypt the copy with a new
#' KMS encryption key. If you don't specify a value for `KmsKeyId`, then
#' the copy of the DB cluster snapshot is encrypted with the same KMS key
#' as the source DB cluster snapshot.
#' 
#' If you copy an encrypted DB cluster snapshot that is shared from another
#' Amazon account, then you must specify a value for `KmsKeyId`.
#' 
#' KMS encryption keys are specific to the Amazon Region that they are
#' created in, and you can't use encryption keys from one Amazon Region in
#' another Amazon Region.
#' 
#' You cannot encrypt an unencrypted DB cluster snapshot when you copy it.
#' If you try to copy an unencrypted DB cluster snapshot and specify a
#' value for the KmsKeyId parameter, an error is returned.
#' @param PreSignedUrl Not currently supported.
#' @param CopyTags True to copy all tags from the source DB cluster snapshot to the target
#' DB cluster snapshot, and otherwise false. The default is false.
#' @param Tags The tags to assign to the new DB cluster snapshot copy.
#'
#' @keywords internal
#'
#' @rdname neptune_copy_db_cluster_snapshot
neptune_copy_db_cluster_snapshot <- function(SourceDBClusterSnapshotIdentifier, TargetDBClusterSnapshotIdentifier, KmsKeyId = NULL, PreSignedUrl = NULL, CopyTags = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CopyDBClusterSnapshot",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .neptune$copy_db_cluster_snapshot_input(SourceDBClusterSnapshotIdentifier = SourceDBClusterSnapshotIdentifier, TargetDBClusterSnapshotIdentifier = TargetDBClusterSnapshotIdentifier, KmsKeyId = KmsKeyId, PreSignedUrl = PreSignedUrl, CopyTags = CopyTags, Tags = Tags)
  output <- .neptune$copy_db_cluster_snapshot_output()
  config <- get_config()
  svc <- .neptune$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.neptune$operations$copy_db_cluster_snapshot <- neptune_copy_db_cluster_snapshot

#' Copies the specified DB parameter group
#'
#' @description
#' Copies the specified DB parameter group.
#'
#' See [https://www.paws-r-sdk.com/docs/neptune_copy_db_parameter_group/](https://www.paws-r-sdk.com/docs/neptune_copy_db_parameter_group/) for full documentation.
#'
#' @param SourceDBParameterGroupIdentifier &#91;required&#93; The identifier or ARN for the source DB parameter group. For information
#' about creating an ARN, see [Constructing an Amazon Resource Name
#' (ARN)](https://docs.aws.amazon.com/neptune/latest/userguide/#tagging.ARN.Constructing).
#' 
#' Constraints:
#' 
#' -   Must specify a valid DB parameter group.
#' 
#' -   Must specify a valid DB parameter group identifier, for example
#'     `my-db-param-group`, or a valid ARN.
#' @param TargetDBParameterGroupIdentifier &#91;required&#93; The identifier for the copied DB parameter group.
#' 
#' Constraints:
#' 
#' -   Cannot be null, empty, or blank.
#' 
#' -   Must contain from 1 to 255 letters, numbers, or hyphens.
#' 
#' -   First character must be a letter.
#' 
#' -   Cannot end with a hyphen or contain two consecutive hyphens.
#' 
#' Example: `my-db-parameter-group`
#' @param TargetDBParameterGroupDescription &#91;required&#93; A description for the copied DB parameter group.
#' @param Tags The tags to be assigned to the copied DB parameter group.
#'
#' @keywords internal
#'
#' @rdname neptune_copy_db_parameter_group
neptune_copy_db_parameter_group <- function(SourceDBParameterGroupIdentifier, TargetDBParameterGroupIdentifier, TargetDBParameterGroupDescription, Tags = NULL) {
  op <- new_operation(
    name = "CopyDBParameterGroup",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .neptune$copy_db_parameter_group_input(SourceDBParameterGroupIdentifier = SourceDBParameterGroupIdentifier, TargetDBParameterGroupIdentifier = TargetDBParameterGroupIdentifier, TargetDBParameterGroupDescription = TargetDBParameterGroupDescription, Tags = Tags)
  output <- .neptune$copy_db_parameter_group_output()
  config <- get_config()
  svc <- .neptune$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.neptune$operations$copy_db_parameter_group <- neptune_copy_db_parameter_group

#' Creates a new Amazon Neptune DB cluster
#'
#' @description
#' Creates a new Amazon Neptune DB cluster.
#'
#' See [https://www.paws-r-sdk.com/docs/neptune_create_db_cluster/](https://www.paws-r-sdk.com/docs/neptune_create_db_cluster/) for full documentation.
#'
#' @param AvailabilityZones A list of EC2 Availability Zones that instances in the DB cluster can be
#' created in.
#' @param BackupRetentionPeriod The number of days for which automated backups are retained. You must
#' specify a minimum value of 1.
#' 
#' Default: 1
#' 
#' Constraints:
#' 
#' -   Must be a value from 1 to 35
#' @param CharacterSetName *(Not supported by Neptune)*
#' @param CopyTagsToSnapshot *If set to true, tags are copied to any snapshot of the DB cluster that
#' is created.*
#' @param DatabaseName The name for your database of up to 64 alpha-numeric characters. If you
#' do not provide a name, Amazon Neptune will not create a database in the
#' DB cluster you are creating.
#' @param DBClusterIdentifier &#91;required&#93; The DB cluster identifier. This parameter is stored as a lowercase
#' string.
#' 
#' Constraints:
#' 
#' -   Must contain from 1 to 63 letters, numbers, or hyphens.
#' 
#' -   First character must be a letter.
#' 
#' -   Cannot end with a hyphen or contain two consecutive hyphens.
#' 
#' Example: `my-cluster1`
#' @param DBClusterParameterGroupName The name of the DB cluster parameter group to associate with this DB
#' cluster. If this argument is omitted, the default is used.
#' 
#' Constraints:
#' 
#' -   If supplied, must match the name of an existing
#'     DBClusterParameterGroup.
#' @param VpcSecurityGroupIds A list of EC2 VPC security groups to associate with this DB cluster.
#' @param DBSubnetGroupName A DB subnet group to associate with this DB cluster.
#' 
#' Constraints: Must match the name of an existing DBSubnetGroup. Must not
#' be default.
#' 
#' Example: `mySubnetgroup`
#' @param Engine &#91;required&#93; The name of the database engine to be used for this DB cluster.
#' 
#' Valid Values: `neptune`
#' @param EngineVersion The version number of the database engine to use for the new DB cluster.
#' 
#' Example: `1.0.2.1`
#' @param Port The port number on which the instances in the DB cluster accept
#' connections.
#' 
#' Default: `8182`
#' @param MasterUsername Not supported by Neptune.
#' @param MasterUserPassword Not supported by Neptune.
#' @param OptionGroupName *(Not supported by Neptune)*
#' @param PreferredBackupWindow The daily time range during which automated backups are created if
#' automated backups are enabled using the `BackupRetentionPeriod`
#' parameter.
#' 
#' The default is a 30-minute window selected at random from an 8-hour
#' block of time for each Amazon Region. To see the time blocks available,
#' see [Neptune Maintenance
#' Window](https://docs.aws.amazon.com/neptune/latest/userguide/#manage-console-maintaining-window)
#' in the *Amazon Neptune User Guide.*
#' 
#' Constraints:
#' 
#' -   Must be in the format `hh24:mi-hh24:mi`.
#' 
#' -   Must be in Universal Coordinated Time (UTC).
#' 
#' -   Must not conflict with the preferred maintenance window.
#' 
#' -   Must be at least 30 minutes.
#' @param PreferredMaintenanceWindow The weekly time range during which system maintenance can occur, in
#' Universal Coordinated Time (UTC).
#' 
#' Format: `ddd:hh24:mi-ddd:hh24:mi`
#' 
#' The default is a 30-minute window selected at random from an 8-hour
#' block of time for each Amazon Region, occurring on a random day of the
#' week. To see the time blocks available, see [Neptune Maintenance
#' Window](https://docs.aws.amazon.com/neptune/latest/userguide/#manage-console-maintaining-window)
#' in the *Amazon Neptune User Guide.*
#' 
#' Valid Days: Mon, Tue, Wed, Thu, Fri, Sat, Sun.
#' 
#' Constraints: Minimum 30-minute window.
#' @param ReplicationSourceIdentifier The Amazon Resource Name (ARN) of the source DB instance or DB cluster
#' if this DB cluster is created as a Read Replica.
#' @param Tags The tags to assign to the new DB cluster.
#' @param StorageEncrypted Specifies whether the DB cluster is encrypted.
#' @param KmsKeyId The Amazon KMS key identifier for an encrypted DB cluster.
#' 
#' The KMS key identifier is the Amazon Resource Name (ARN) for the KMS
#' encryption key. If you are creating a DB cluster with the same Amazon
#' account that owns the KMS encryption key used to encrypt the new DB
#' cluster, then you can use the KMS key alias instead of the ARN for the
#' KMS encryption key.
#' 
#' If an encryption key is not specified in `KmsKeyId`:
#' 
#' -   If `ReplicationSourceIdentifier` identifies an encrypted source,
#'     then Amazon Neptune will use the encryption key used to encrypt the
#'     source. Otherwise, Amazon Neptune will use your default encryption
#'     key.
#' 
#' -   If the `StorageEncrypted` parameter is true and
#'     `ReplicationSourceIdentifier` is not specified, then Amazon Neptune
#'     will use your default encryption key.
#' 
#' Amazon KMS creates the default encryption key for your Amazon account.
#' Your Amazon account has a different default encryption key for each
#' Amazon Region.
#' 
#' If you create a Read Replica of an encrypted DB cluster in another
#' Amazon Region, you must set `KmsKeyId` to a KMS key ID that is valid in
#' the destination Amazon Region. This key is used to encrypt the Read
#' Replica in that Amazon Region.
#' @param PreSignedUrl This parameter is not currently supported.
#' @param EnableIAMDatabaseAuthentication If set to `true`, enables Amazon Identity and Access Management (IAM)
#' authentication for the entire DB cluster (this cannot be set at an
#' instance level).
#' 
#' Default: `false`.
#' @param EnableCloudwatchLogsExports A list of the log types that this DB cluster should export to CloudWatch
#' Logs. Valid log types are: `audit` (to publish audit logs) and
#' `slowquery` (to publish slow-query logs). See [Publishing Neptune logs
#' to Amazon CloudWatch
#' logs](https://docs.aws.amazon.com/neptune/latest/userguide/cloudwatch-logs.html).
#' @param DeletionProtection A value that indicates whether the DB cluster has deletion protection
#' enabled. The database can't be deleted when deletion protection is
#' enabled. By default, deletion protection is enabled.
#' @param ServerlessV2ScalingConfiguration Contains the scaling configuration of a Neptune Serverless DB cluster.
#' 
#' For more information, see [Using Amazon Neptune
#' Serverless](https://docs.aws.amazon.com/neptune/latest/userguide/neptune-serverless-using.html)
#' in the *Amazon Neptune User Guide*.
#' @param GlobalClusterIdentifier The ID of the Neptune global database to which this new DB cluster
#' should be added.
#' @param StorageType The storage type to associate with the DB cluster.
#' 
#' Valid Values:
#' 
#' -   `standard | iopt1`
#' 
#' Default:
#' 
#' -   `standard`
#' 
#' When you create a Neptune cluster with the storage type set to `iopt1`,
#' the storage type is returned in the response. The storage type isn't
#' returned when you set it to `standard`.
#'
#' @keywords internal
#'
#' @rdname neptune_create_db_cluster
neptune_create_db_cluster <- function(AvailabilityZones = NULL, BackupRetentionPeriod = NULL, CharacterSetName = NULL, CopyTagsToSnapshot = NULL, DatabaseName = NULL, DBClusterIdentifier, DBClusterParameterGroupName = NULL, VpcSecurityGroupIds = NULL, DBSubnetGroupName = NULL, Engine, EngineVersion = NULL, Port = NULL, MasterUsername = NULL, MasterUserPassword = NULL, OptionGroupName = NULL, PreferredBackupWindow = NULL, PreferredMaintenanceWindow = NULL, ReplicationSourceIdentifier = NULL, Tags = NULL, StorageEncrypted = NULL, KmsKeyId = NULL, PreSignedUrl = NULL, EnableIAMDatabaseAuthentication = NULL, EnableCloudwatchLogsExports = NULL, DeletionProtection = NULL, ServerlessV2ScalingConfiguration = NULL, GlobalClusterIdentifier = NULL, StorageType = NULL) {
  op <- new_operation(
    name = "CreateDBCluster",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .neptune$create_db_cluster_input(AvailabilityZones = AvailabilityZones, BackupRetentionPeriod = BackupRetentionPeriod, CharacterSetName = CharacterSetName, CopyTagsToSnapshot = CopyTagsToSnapshot, DatabaseName = DatabaseName, DBClusterIdentifier = DBClusterIdentifier, DBClusterParameterGroupName = DBClusterParameterGroupName, VpcSecurityGroupIds = VpcSecurityGroupIds, DBSubnetGroupName = DBSubnetGroupName, Engine = Engine, EngineVersion = EngineVersion, Port = Port, MasterUsername = MasterUsername, MasterUserPassword = MasterUserPassword, OptionGroupName = OptionGroupName, PreferredBackupWindow = PreferredBackupWindow, PreferredMaintenanceWindow = PreferredMaintenanceWindow, ReplicationSourceIdentifier = ReplicationSourceIdentifier, Tags = Tags, StorageEncrypted = StorageEncrypted, KmsKeyId = KmsKeyId, PreSignedUrl = PreSignedUrl, EnableIAMDatabaseAuthentication = EnableIAMDatabaseAuthentication, EnableCloudwatchLogsExports = EnableCloudwatchLogsExports, DeletionProtection = DeletionProtection, ServerlessV2ScalingConfiguration = ServerlessV2ScalingConfiguration, GlobalClusterIdentifier = GlobalClusterIdentifier, StorageType = StorageType)
  output <- .neptune$create_db_cluster_output()
  config <- get_config()
  svc <- .neptune$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.neptune$operations$create_db_cluster <- neptune_create_db_cluster

#' Creates a new custom endpoint and associates it with an Amazon Neptune
#' DB cluster
#'
#' @description
#' Creates a new custom endpoint and associates it with an Amazon Neptune DB cluster.
#'
#' See [https://www.paws-r-sdk.com/docs/neptune_create_db_cluster_endpoint/](https://www.paws-r-sdk.com/docs/neptune_create_db_cluster_endpoint/) for full documentation.
#'
#' @param DBClusterIdentifier &#91;required&#93; The DB cluster identifier of the DB cluster associated with the
#' endpoint. This parameter is stored as a lowercase string.
#' @param DBClusterEndpointIdentifier &#91;required&#93; The identifier to use for the new endpoint. This parameter is stored as
#' a lowercase string.
#' @param EndpointType &#91;required&#93; The type of the endpoint. One of: `READER`, `WRITER`, `ANY`.
#' @param StaticMembers List of DB instance identifiers that are part of the custom endpoint
#' group.
#' @param ExcludedMembers List of DB instance identifiers that aren't part of the custom endpoint
#' group. All other eligible instances are reachable through the custom
#' endpoint. Only relevant if the list of static members is empty.
#' @param Tags The tags to be assigned to the Amazon Neptune resource.
#'
#' @keywords internal
#'
#' @rdname neptune_create_db_cluster_endpoint
neptune_create_db_cluster_endpoint <- function(DBClusterIdentifier, DBClusterEndpointIdentifier, EndpointType, StaticMembers = NULL, ExcludedMembers = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateDBClusterEndpoint",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .neptune$create_db_cluster_endpoint_input(DBClusterIdentifier = DBClusterIdentifier, DBClusterEndpointIdentifier = DBClusterEndpointIdentifier, EndpointType = EndpointType, StaticMembers = StaticMembers, ExcludedMembers = ExcludedMembers, Tags = Tags)
  output <- .neptune$create_db_cluster_endpoint_output()
  config <- get_config()
  svc <- .neptune$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.neptune$operations$create_db_cluster_endpoint <- neptune_create_db_cluster_endpoint

#' Creates a new DB cluster parameter group
#'
#' @description
#' Creates a new DB cluster parameter group.
#'
#' See [https://www.paws-r-sdk.com/docs/neptune_create_db_cluster_parameter_group/](https://www.paws-r-sdk.com/docs/neptune_create_db_cluster_parameter_group/) for full documentation.
#'
#' @param DBClusterParameterGroupName &#91;required&#93; The name of the DB cluster parameter group.
#' 
#' Constraints:
#' 
#' -   Must match the name of an existing DBClusterParameterGroup.
#' 
#' This value is stored as a lowercase string.
#' @param DBParameterGroupFamily &#91;required&#93; The DB cluster parameter group family name. A DB cluster parameter group
#' can be associated with one and only one DB cluster parameter group
#' family, and can be applied only to a DB cluster running a database
#' engine and engine version compatible with that DB cluster parameter
#' group family.
#' @param Description &#91;required&#93; The description for the DB cluster parameter group.
#' @param Tags The tags to be assigned to the new DB cluster parameter group.
#'
#' @keywords internal
#'
#' @rdname neptune_create_db_cluster_parameter_group
neptune_create_db_cluster_parameter_group <- function(DBClusterParameterGroupName, DBParameterGroupFamily, Description, Tags = NULL) {
  op <- new_operation(
    name = "CreateDBClusterParameterGroup",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .neptune$create_db_cluster_parameter_group_input(DBClusterParameterGroupName = DBClusterParameterGroupName, DBParameterGroupFamily = DBParameterGroupFamily, Description = Description, Tags = Tags)
  output <- .neptune$create_db_cluster_parameter_group_output()
  config <- get_config()
  svc <- .neptune$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.neptune$operations$create_db_cluster_parameter_group <- neptune_create_db_cluster_parameter_group

#' Creates a snapshot of a DB cluster
#'
#' @description
#' Creates a snapshot of a DB cluster.
#'
#' See [https://www.paws-r-sdk.com/docs/neptune_create_db_cluster_snapshot/](https://www.paws-r-sdk.com/docs/neptune_create_db_cluster_snapshot/) for full documentation.
#'
#' @param DBClusterSnapshotIdentifier &#91;required&#93; The identifier of the DB cluster snapshot. This parameter is stored as a
#' lowercase string.
#' 
#' Constraints:
#' 
#' -   Must contain from 1 to 63 letters, numbers, or hyphens.
#' 
#' -   First character must be a letter.
#' 
#' -   Cannot end with a hyphen or contain two consecutive hyphens.
#' 
#' Example: `my-cluster1-snapshot1`
#' @param DBClusterIdentifier &#91;required&#93; The identifier of the DB cluster to create a snapshot for. This
#' parameter is not case-sensitive.
#' 
#' Constraints:
#' 
#' -   Must match the identifier of an existing DBCluster.
#' 
#' Example: `my-cluster1`
#' @param Tags The tags to be assigned to the DB cluster snapshot.
#'
#' @keywords internal
#'
#' @rdname neptune_create_db_cluster_snapshot
neptune_create_db_cluster_snapshot <- function(DBClusterSnapshotIdentifier, DBClusterIdentifier, Tags = NULL) {
  op <- new_operation(
    name = "CreateDBClusterSnapshot",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .neptune$create_db_cluster_snapshot_input(DBClusterSnapshotIdentifier = DBClusterSnapshotIdentifier, DBClusterIdentifier = DBClusterIdentifier, Tags = Tags)
  output <- .neptune$create_db_cluster_snapshot_output()
  config <- get_config()
  svc <- .neptune$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.neptune$operations$create_db_cluster_snapshot <- neptune_create_db_cluster_snapshot

#' Creates a new DB instance
#'
#' @description
#' Creates a new DB instance.
#'
#' See [https://www.paws-r-sdk.com/docs/neptune_create_db_instance/](https://www.paws-r-sdk.com/docs/neptune_create_db_instance/) for full documentation.
#'
#' @param DBName Not supported.
#' @param DBInstanceIdentifier &#91;required&#93; The DB instance identifier. This parameter is stored as a lowercase
#' string.
#' 
#' Constraints:
#' 
#' -   Must contain from 1 to 63 letters, numbers, or hyphens.
#' 
#' -   First character must be a letter.
#' 
#' -   Cannot end with a hyphen or contain two consecutive hyphens.
#' 
#' Example: `mydbinstance`
#' @param AllocatedStorage Not supported by Neptune.
#' @param DBInstanceClass &#91;required&#93; The compute and memory capacity of the DB instance, for example,
#' `db.m4.large`. Not all DB instance classes are available in all Amazon
#' Regions.
#' @param Engine &#91;required&#93; The name of the database engine to be used for this instance.
#' 
#' Valid Values: `neptune`
#' @param MasterUsername Not supported by Neptune.
#' @param MasterUserPassword Not supported by Neptune.
#' @param DBSecurityGroups A list of DB security groups to associate with this DB instance.
#' 
#' Default: The default DB security group for the database engine.
#' @param VpcSecurityGroupIds A list of EC2 VPC security groups to associate with this DB instance.
#' 
#' Not applicable. The associated list of EC2 VPC security groups is
#' managed by the DB cluster. For more information, see
#' [`create_db_cluster`][neptune_create_db_cluster].
#' 
#' Default: The default EC2 VPC security group for the DB subnet group's
#' VPC.
#' @param AvailabilityZone The EC2 Availability Zone that the DB instance is created in
#' 
#' Default: A random, system-chosen Availability Zone in the endpoint's
#' Amazon Region.
#' 
#' Example: `us-east-1d`
#' 
#' Constraint: The AvailabilityZone parameter can't be specified if the
#' MultiAZ parameter is set to `true`. The specified Availability Zone must
#' be in the same Amazon Region as the current endpoint.
#' @param DBSubnetGroupName A DB subnet group to associate with this DB instance.
#' 
#' If there is no DB subnet group, then it is a non-VPC DB instance.
#' @param PreferredMaintenanceWindow The time range each week during which system maintenance can occur, in
#' Universal Coordinated Time (UTC).
#' 
#' Format: `ddd:hh24:mi-ddd:hh24:mi`
#' 
#' The default is a 30-minute window selected at random from an 8-hour
#' block of time for each Amazon Region, occurring on a random day of the
#' week.
#' 
#' Valid Days: Mon, Tue, Wed, Thu, Fri, Sat, Sun.
#' 
#' Constraints: Minimum 30-minute window.
#' @param DBParameterGroupName The name of the DB parameter group to associate with this DB instance.
#' If this argument is omitted, the default DBParameterGroup for the
#' specified engine is used.
#' 
#' Constraints:
#' 
#' -   Must be 1 to 255 letters, numbers, or hyphens.
#' 
#' -   First character must be a letter
#' 
#' -   Cannot end with a hyphen or contain two consecutive hyphens
#' @param BackupRetentionPeriod The number of days for which automated backups are retained.
#' 
#' Not applicable. The retention period for automated backups is managed by
#' the DB cluster. For more information, see
#' [`create_db_cluster`][neptune_create_db_cluster].
#' 
#' Default: 1
#' 
#' Constraints:
#' 
#' -   Must be a value from 0 to 35
#' 
#' -   Cannot be set to 0 if the DB instance is a source to Read Replicas
#' @param PreferredBackupWindow The daily time range during which automated backups are created.
#' 
#' Not applicable. The daily time range for creating automated backups is
#' managed by the DB cluster. For more information, see
#' [`create_db_cluster`][neptune_create_db_cluster].
#' @param Port The port number on which the database accepts connections.
#' 
#' Not applicable. The port is managed by the DB cluster. For more
#' information, see [`create_db_cluster`][neptune_create_db_cluster].
#' 
#' Default: `8182`
#' 
#' Type: Integer
#' @param MultiAZ Specifies if the DB instance is a Multi-AZ deployment. You can't set the
#' AvailabilityZone parameter if the MultiAZ parameter is set to true.
#' @param EngineVersion The version number of the database engine to use. Currently, setting
#' this parameter has no effect.
#' @param AutoMinorVersionUpgrade Indicates that minor engine upgrades are applied automatically to the DB
#' instance during the maintenance window.
#' 
#' Default: `true`
#' @param LicenseModel License model information for this DB instance.
#' 
#' Valid values: `license-included` | `bring-your-own-license` |
#' `general-public-license`
#' @param Iops The amount of Provisioned IOPS (input/output operations per second) to
#' be initially allocated for the DB instance.
#' @param OptionGroupName *(Not supported by Neptune)*
#' @param CharacterSetName *(Not supported by Neptune)*
#' @param PubliclyAccessible This flag should no longer be used.
#' @param Tags The tags to assign to the new instance.
#' @param DBClusterIdentifier &#91;required&#93; The identifier of the DB cluster that the instance will belong to.
#' 
#' For information on creating a DB cluster, see
#' [`create_db_cluster`][neptune_create_db_cluster].
#' 
#' Type: String
#' @param StorageType Specifies the storage type to be associated with the DB instance.
#' 
#' Not applicable. Storage is managed by the DB Cluster.
#' @param TdeCredentialArn The ARN from the key store with which to associate the instance for TDE
#' encryption.
#' @param TdeCredentialPassword The password for the given ARN from the key store in order to access the
#' device.
#' @param StorageEncrypted Specifies whether the DB instance is encrypted.
#' 
#' Not applicable. The encryption for DB instances is managed by the DB
#' cluster. For more information, see
#' [`create_db_cluster`][neptune_create_db_cluster].
#' 
#' Default: false
#' @param KmsKeyId The Amazon KMS key identifier for an encrypted DB instance.
#' 
#' The KMS key identifier is the Amazon Resource Name (ARN) for the KMS
#' encryption key. If you are creating a DB instance with the same Amazon
#' account that owns the KMS encryption key used to encrypt the new DB
#' instance, then you can use the KMS key alias instead of the ARN for the
#' KM encryption key.
#' 
#' Not applicable. The KMS key identifier is managed by the DB cluster. For
#' more information, see [`create_db_cluster`][neptune_create_db_cluster].
#' 
#' If the `StorageEncrypted` parameter is true, and you do not specify a
#' value for the `KmsKeyId` parameter, then Amazon Neptune will use your
#' default encryption key. Amazon KMS creates the default encryption key
#' for your Amazon account. Your Amazon account has a different default
#' encryption key for each Amazon Region.
#' @param Domain Specify the Active Directory Domain to create the instance in.
#' @param CopyTagsToSnapshot True to copy all tags from the DB instance to snapshots of the DB
#' instance, and otherwise false. The default is false.
#' @param MonitoringInterval The interval, in seconds, between points when Enhanced Monitoring
#' metrics are collected for the DB instance. To disable collecting
#' Enhanced Monitoring metrics, specify 0. The default is 0.
#' 
#' If `MonitoringRoleArn` is specified, then you must also set
#' `MonitoringInterval` to a value other than 0.
#' 
#' Valid Values: `0, 1, 5, 10, 15, 30, 60`
#' @param MonitoringRoleArn The ARN for the IAM role that permits Neptune to send enhanced
#' monitoring metrics to Amazon CloudWatch Logs. For example,
#' `arn:aws:iam:123456789012:role/emaccess`.
#' 
#' If `MonitoringInterval` is set to a value other than 0, then you must
#' supply a `MonitoringRoleArn` value.
#' @param DomainIAMRoleName Specify the name of the IAM role to be used when making API calls to the
#' Directory Service.
#' @param PromotionTier A value that specifies the order in which an Read Replica is promoted to
#' the primary instance after a failure of the existing primary instance.
#' 
#' Default: 1
#' 
#' Valid Values: 0 - 15
#' @param Timezone The time zone of the DB instance.
#' @param EnableIAMDatabaseAuthentication Not supported by Neptune (ignored).
#' @param EnablePerformanceInsights *(Not supported by Neptune)*
#' @param PerformanceInsightsKMSKeyId *(Not supported by Neptune)*
#' @param EnableCloudwatchLogsExports The list of log types that need to be enabled for exporting to
#' CloudWatch Logs.
#' @param DeletionProtection A value that indicates whether the DB instance has deletion protection
#' enabled. The database can't be deleted when deletion protection is
#' enabled. By default, deletion protection is disabled. See [Deleting a DB
#' Instance](https://docs.aws.amazon.com/neptune/latest/userguide/manage-console-instances-delete.html).
#' 
#' DB instances in a DB cluster can be deleted even when deletion
#' protection is enabled in their parent DB cluster.
#'
#' @keywords internal
#'
#' @rdname neptune_create_db_instance
neptune_create_db_instance <- function(DBName = NULL, DBInstanceIdentifier, AllocatedStorage = NULL, DBInstanceClass, Engine, MasterUsername = NULL, MasterUserPassword = NULL, DBSecurityGroups = NULL, VpcSecurityGroupIds = NULL, AvailabilityZone = NULL, DBSubnetGroupName = NULL, PreferredMaintenanceWindow = NULL, DBParameterGroupName = NULL, BackupRetentionPeriod = NULL, PreferredBackupWindow = NULL, Port = NULL, MultiAZ = NULL, EngineVersion = NULL, AutoMinorVersionUpgrade = NULL, LicenseModel = NULL, Iops = NULL, OptionGroupName = NULL, CharacterSetName = NULL, PubliclyAccessible = NULL, Tags = NULL, DBClusterIdentifier, StorageType = NULL, TdeCredentialArn = NULL, TdeCredentialPassword = NULL, StorageEncrypted = NULL, KmsKeyId = NULL, Domain = NULL, CopyTagsToSnapshot = NULL, MonitoringInterval = NULL, MonitoringRoleArn = NULL, DomainIAMRoleName = NULL, PromotionTier = NULL, Timezone = NULL, EnableIAMDatabaseAuthentication = NULL, EnablePerformanceInsights = NULL, PerformanceInsightsKMSKeyId = NULL, EnableCloudwatchLogsExports = NULL, DeletionProtection = NULL) {
  op <- new_operation(
    name = "CreateDBInstance",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .neptune$create_db_instance_input(DBName = DBName, DBInstanceIdentifier = DBInstanceIdentifier, AllocatedStorage = AllocatedStorage, DBInstanceClass = DBInstanceClass, Engine = Engine, MasterUsername = MasterUsername, MasterUserPassword = MasterUserPassword, DBSecurityGroups = DBSecurityGroups, VpcSecurityGroupIds = VpcSecurityGroupIds, AvailabilityZone = AvailabilityZone, DBSubnetGroupName = DBSubnetGroupName, PreferredMaintenanceWindow = PreferredMaintenanceWindow, DBParameterGroupName = DBParameterGroupName, BackupRetentionPeriod = BackupRetentionPeriod, PreferredBackupWindow = PreferredBackupWindow, Port = Port, MultiAZ = MultiAZ, EngineVersion = EngineVersion, AutoMinorVersionUpgrade = AutoMinorVersionUpgrade, LicenseModel = LicenseModel, Iops = Iops, OptionGroupName = OptionGroupName, CharacterSetName = CharacterSetName, PubliclyAccessible = PubliclyAccessible, Tags = Tags, DBClusterIdentifier = DBClusterIdentifier, StorageType = StorageType, TdeCredentialArn = TdeCredentialArn, TdeCredentialPassword = TdeCredentialPassword, StorageEncrypted = StorageEncrypted, KmsKeyId = KmsKeyId, Domain = Domain, CopyTagsToSnapshot = CopyTagsToSnapshot, MonitoringInterval = MonitoringInterval, MonitoringRoleArn = MonitoringRoleArn, DomainIAMRoleName = DomainIAMRoleName, PromotionTier = PromotionTier, Timezone = Timezone, EnableIAMDatabaseAuthentication = EnableIAMDatabaseAuthentication, EnablePerformanceInsights = EnablePerformanceInsights, PerformanceInsightsKMSKeyId = PerformanceInsightsKMSKeyId, EnableCloudwatchLogsExports = EnableCloudwatchLogsExports, DeletionProtection = DeletionProtection)
  output <- .neptune$create_db_instance_output()
  config <- get_config()
  svc <- .neptune$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.neptune$operations$create_db_instance <- neptune_create_db_instance

#' Creates a new DB parameter group
#'
#' @description
#' Creates a new DB parameter group.
#'
#' See [https://www.paws-r-sdk.com/docs/neptune_create_db_parameter_group/](https://www.paws-r-sdk.com/docs/neptune_create_db_parameter_group/) for full documentation.
#'
#' @param DBParameterGroupName &#91;required&#93; The name of the DB parameter group.
#' 
#' Constraints:
#' 
#' -   Must be 1 to 255 letters, numbers, or hyphens.
#' 
#' -   First character must be a letter
#' 
#' -   Cannot end with a hyphen or contain two consecutive hyphens
#' 
#' This value is stored as a lowercase string.
#' @param DBParameterGroupFamily &#91;required&#93; The DB parameter group family name. A DB parameter group can be
#' associated with one and only one DB parameter group family, and can be
#' applied only to a DB instance running a database engine and engine
#' version compatible with that DB parameter group family.
#' @param Description &#91;required&#93; The description for the DB parameter group.
#' @param Tags The tags to be assigned to the new DB parameter group.
#'
#' @keywords internal
#'
#' @rdname neptune_create_db_parameter_group
neptune_create_db_parameter_group <- function(DBParameterGroupName, DBParameterGroupFamily, Description, Tags = NULL) {
  op <- new_operation(
    name = "CreateDBParameterGroup",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .neptune$create_db_parameter_group_input(DBParameterGroupName = DBParameterGroupName, DBParameterGroupFamily = DBParameterGroupFamily, Description = Description, Tags = Tags)
  output <- .neptune$create_db_parameter_group_output()
  config <- get_config()
  svc <- .neptune$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.neptune$operations$create_db_parameter_group <- neptune_create_db_parameter_group

#' Creates a new DB subnet group
#'
#' @description
#' Creates a new DB subnet group. DB subnet groups must contain at least one subnet in at least two AZs in the Amazon Region.
#'
#' See [https://www.paws-r-sdk.com/docs/neptune_create_db_subnet_group/](https://www.paws-r-sdk.com/docs/neptune_create_db_subnet_group/) for full documentation.
#'
#' @param DBSubnetGroupName &#91;required&#93; The name for the DB subnet group. This value is stored as a lowercase
#' string.
#' 
#' Constraints: Must contain no more than 255 letters, numbers, periods,
#' underscores, spaces, or hyphens. Must not be default.
#' 
#' Example: `mySubnetgroup`
#' @param DBSubnetGroupDescription &#91;required&#93; The description for the DB subnet group.
#' @param SubnetIds &#91;required&#93; The EC2 Subnet IDs for the DB subnet group.
#' @param Tags The tags to be assigned to the new DB subnet group.
#'
#' @keywords internal
#'
#' @rdname neptune_create_db_subnet_group
neptune_create_db_subnet_group <- function(DBSubnetGroupName, DBSubnetGroupDescription, SubnetIds, Tags = NULL) {
  op <- new_operation(
    name = "CreateDBSubnetGroup",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .neptune$create_db_subnet_group_input(DBSubnetGroupName = DBSubnetGroupName, DBSubnetGroupDescription = DBSubnetGroupDescription, SubnetIds = SubnetIds, Tags = Tags)
  output <- .neptune$create_db_subnet_group_output()
  config <- get_config()
  svc <- .neptune$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.neptune$operations$create_db_subnet_group <- neptune_create_db_subnet_group

#' Creates an event notification subscription
#'
#' @description
#' Creates an event notification subscription. This action requires a topic ARN (Amazon Resource Name) created by either the Neptune console, the SNS console, or the SNS API. To obtain an ARN with SNS, you must create a topic in Amazon SNS and subscribe to the topic. The ARN is displayed in the SNS console.
#'
#' See [https://www.paws-r-sdk.com/docs/neptune_create_event_subscription/](https://www.paws-r-sdk.com/docs/neptune_create_event_subscription/) for full documentation.
#'
#' @param SubscriptionName &#91;required&#93; The name of the subscription.
#' 
#' Constraints: The name must be less than 255 characters.
#' @param SnsTopicArn &#91;required&#93; The Amazon Resource Name (ARN) of the SNS topic created for event
#' notification. The ARN is created by Amazon SNS when you create a topic
#' and subscribe to it.
#' @param SourceType The type of source that is generating the events. For example, if you
#' want to be notified of events generated by a DB instance, you would set
#' this parameter to db-instance. if this value is not specified, all
#' events are returned.
#' 
#' Valid values: `db-instance` | `db-cluster` | `db-parameter-group` |
#' `db-security-group` | `db-snapshot` | `db-cluster-snapshot`
#' @param EventCategories A list of event categories for a SourceType that you want to subscribe
#' to. You can see a list of the categories for a given SourceType by using
#' the **DescribeEventCategories** action.
#' @param SourceIds The list of identifiers of the event sources for which events are
#' returned. If not specified, then all sources are included in the
#' response. An identifier must begin with a letter and must contain only
#' ASCII letters, digits, and hyphens; it can't end with a hyphen or
#' contain two consecutive hyphens.
#' 
#' Constraints:
#' 
#' -   If SourceIds are supplied, SourceType must also be provided.
#' 
#' -   If the source type is a DB instance, then a `DBInstanceIdentifier`
#'     must be supplied.
#' 
#' -   If the source type is a DB security group, a `DBSecurityGroupName`
#'     must be supplied.
#' 
#' -   If the source type is a DB parameter group, a `DBParameterGroupName`
#'     must be supplied.
#' 
#' -   If the source type is a DB snapshot, a `DBSnapshotIdentifier` must
#'     be supplied.
#' @param Enabled A Boolean value; set to **true** to activate the subscription, set to
#' **false** to create the subscription but not active it.
#' @param Tags The tags to be applied to the new event subscription.
#'
#' @keywords internal
#'
#' @rdname neptune_create_event_subscription
neptune_create_event_subscription <- function(SubscriptionName, SnsTopicArn, SourceType = NULL, EventCategories = NULL, SourceIds = NULL, Enabled = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateEventSubscription",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .neptune$create_event_subscription_input(SubscriptionName = SubscriptionName, SnsTopicArn = SnsTopicArn, SourceType = SourceType, EventCategories = EventCategories, SourceIds = SourceIds, Enabled = Enabled, Tags = Tags)
  output <- .neptune$create_event_subscription_output()
  config <- get_config()
  svc <- .neptune$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.neptune$operations$create_event_subscription <- neptune_create_event_subscription

#' Creates a Neptune global database spread across multiple Amazon Regions
#'
#' @description
#' Creates a Neptune global database spread across multiple Amazon Regions. The global database contains a single primary cluster with read-write capability, and read-only secondary clusters that receive data from the primary cluster through high-speed replication performed by the Neptune storage subsystem.
#'
#' See [https://www.paws-r-sdk.com/docs/neptune_create_global_cluster/](https://www.paws-r-sdk.com/docs/neptune_create_global_cluster/) for full documentation.
#'
#' @param GlobalClusterIdentifier &#91;required&#93; The cluster identifier of the new global database cluster.
#' @param SourceDBClusterIdentifier (*Optional*) The Amazon Resource Name (ARN) of an existing Neptune DB
#' cluster to use as the primary cluster of the new global database.
#' @param Engine The name of the database engine to be used in the global database.
#' 
#' Valid values: `neptune`
#' @param EngineVersion The Neptune engine version to be used by the global database.
#' 
#' Valid values: `1.2.0.0` or above.
#' @param DeletionProtection The deletion protection setting for the new global database. The global
#' database can't be deleted when deletion protection is enabled.
#' @param StorageEncrypted The storage encryption setting for the new global database cluster.
#'
#' @keywords internal
#'
#' @rdname neptune_create_global_cluster
neptune_create_global_cluster <- function(GlobalClusterIdentifier, SourceDBClusterIdentifier = NULL, Engine = NULL, EngineVersion = NULL, DeletionProtection = NULL, StorageEncrypted = NULL) {
  op <- new_operation(
    name = "CreateGlobalCluster",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .neptune$create_global_cluster_input(GlobalClusterIdentifier = GlobalClusterIdentifier, SourceDBClusterIdentifier = SourceDBClusterIdentifier, Engine = Engine, EngineVersion = EngineVersion, DeletionProtection = DeletionProtection, StorageEncrypted = StorageEncrypted)
  output <- .neptune$create_global_cluster_output()
  config <- get_config()
  svc <- .neptune$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.neptune$operations$create_global_cluster <- neptune_create_global_cluster

#' The DeleteDBCluster action deletes a previously provisioned DB cluster
#'
#' @description
#' The DeleteDBCluster action deletes a previously provisioned DB cluster. When you delete a DB cluster, all automated backups for that DB cluster are deleted and can't be recovered. Manual DB cluster snapshots of the specified DB cluster are not deleted.
#'
#' See [https://www.paws-r-sdk.com/docs/neptune_delete_db_cluster/](https://www.paws-r-sdk.com/docs/neptune_delete_db_cluster/) for full documentation.
#'
#' @param DBClusterIdentifier &#91;required&#93; The DB cluster identifier for the DB cluster to be deleted. This
#' parameter isn't case-sensitive.
#' 
#' Constraints:
#' 
#' -   Must match an existing DBClusterIdentifier.
#' @param SkipFinalSnapshot Determines whether a final DB cluster snapshot is created before the DB
#' cluster is deleted. If `true` is specified, no DB cluster snapshot is
#' created. If `false` is specified, a DB cluster snapshot is created
#' before the DB cluster is deleted.
#' 
#' You must specify a `FinalDBSnapshotIdentifier` parameter if
#' `SkipFinalSnapshot` is `false`.
#' 
#' Default: `false`
#' @param FinalDBSnapshotIdentifier The DB cluster snapshot identifier of the new DB cluster snapshot
#' created when `SkipFinalSnapshot` is set to `false`.
#' 
#' Specifying this parameter and also setting the `SkipFinalShapshot`
#' parameter to true results in an error.
#' 
#' Constraints:
#' 
#' -   Must be 1 to 255 letters, numbers, or hyphens.
#' 
#' -   First character must be a letter
#' 
#' -   Cannot end with a hyphen or contain two consecutive hyphens
#'
#' @keywords internal
#'
#' @rdname neptune_delete_db_cluster
neptune_delete_db_cluster <- function(DBClusterIdentifier, SkipFinalSnapshot = NULL, FinalDBSnapshotIdentifier = NULL) {
  op <- new_operation(
    name = "DeleteDBCluster",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .neptune$delete_db_cluster_input(DBClusterIdentifier = DBClusterIdentifier, SkipFinalSnapshot = SkipFinalSnapshot, FinalDBSnapshotIdentifier = FinalDBSnapshotIdentifier)
  output <- .neptune$delete_db_cluster_output()
  config <- get_config()
  svc <- .neptune$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.neptune$operations$delete_db_cluster <- neptune_delete_db_cluster

#' Deletes a custom endpoint and removes it from an Amazon Neptune DB
#' cluster
#'
#' @description
#' Deletes a custom endpoint and removes it from an Amazon Neptune DB cluster.
#'
#' See [https://www.paws-r-sdk.com/docs/neptune_delete_db_cluster_endpoint/](https://www.paws-r-sdk.com/docs/neptune_delete_db_cluster_endpoint/) for full documentation.
#'
#' @param DBClusterEndpointIdentifier &#91;required&#93; The identifier associated with the custom endpoint. This parameter is
#' stored as a lowercase string.
#'
#' @keywords internal
#'
#' @rdname neptune_delete_db_cluster_endpoint
neptune_delete_db_cluster_endpoint <- function(DBClusterEndpointIdentifier) {
  op <- new_operation(
    name = "DeleteDBClusterEndpoint",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .neptune$delete_db_cluster_endpoint_input(DBClusterEndpointIdentifier = DBClusterEndpointIdentifier)
  output <- .neptune$delete_db_cluster_endpoint_output()
  config <- get_config()
  svc <- .neptune$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.neptune$operations$delete_db_cluster_endpoint <- neptune_delete_db_cluster_endpoint

#' Deletes a specified DB cluster parameter group
#'
#' @description
#' Deletes a specified DB cluster parameter group. The DB cluster parameter group to be deleted can't be associated with any DB clusters.
#'
#' See [https://www.paws-r-sdk.com/docs/neptune_delete_db_cluster_parameter_group/](https://www.paws-r-sdk.com/docs/neptune_delete_db_cluster_parameter_group/) for full documentation.
#'
#' @param DBClusterParameterGroupName &#91;required&#93; The name of the DB cluster parameter group.
#' 
#' Constraints:
#' 
#' -   Must be the name of an existing DB cluster parameter group.
#' 
#' -   You can't delete a default DB cluster parameter group.
#' 
#' -   Cannot be associated with any DB clusters.
#'
#' @keywords internal
#'
#' @rdname neptune_delete_db_cluster_parameter_group
neptune_delete_db_cluster_parameter_group <- function(DBClusterParameterGroupName) {
  op <- new_operation(
    name = "DeleteDBClusterParameterGroup",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .neptune$delete_db_cluster_parameter_group_input(DBClusterParameterGroupName = DBClusterParameterGroupName)
  output <- .neptune$delete_db_cluster_parameter_group_output()
  config <- get_config()
  svc <- .neptune$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.neptune$operations$delete_db_cluster_parameter_group <- neptune_delete_db_cluster_parameter_group

#' Deletes a DB cluster snapshot
#'
#' @description
#' Deletes a DB cluster snapshot. If the snapshot is being copied, the copy operation is terminated.
#'
#' See [https://www.paws-r-sdk.com/docs/neptune_delete_db_cluster_snapshot/](https://www.paws-r-sdk.com/docs/neptune_delete_db_cluster_snapshot/) for full documentation.
#'
#' @param DBClusterSnapshotIdentifier &#91;required&#93; The identifier of the DB cluster snapshot to delete.
#' 
#' Constraints: Must be the name of an existing DB cluster snapshot in the
#' `available` state.
#'
#' @keywords internal
#'
#' @rdname neptune_delete_db_cluster_snapshot
neptune_delete_db_cluster_snapshot <- function(DBClusterSnapshotIdentifier) {
  op <- new_operation(
    name = "DeleteDBClusterSnapshot",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .neptune$delete_db_cluster_snapshot_input(DBClusterSnapshotIdentifier = DBClusterSnapshotIdentifier)
  output <- .neptune$delete_db_cluster_snapshot_output()
  config <- get_config()
  svc <- .neptune$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.neptune$operations$delete_db_cluster_snapshot <- neptune_delete_db_cluster_snapshot

#' The DeleteDBInstance action deletes a previously provisioned DB instance
#'
#' @description
#' The DeleteDBInstance action deletes a previously provisioned DB instance. When you delete a DB instance, all automated backups for that instance are deleted and can't be recovered. Manual DB snapshots of the DB instance to be deleted by [`delete_db_instance`][neptune_delete_db_instance] are not deleted.
#'
#' See [https://www.paws-r-sdk.com/docs/neptune_delete_db_instance/](https://www.paws-r-sdk.com/docs/neptune_delete_db_instance/) for full documentation.
#'
#' @param DBInstanceIdentifier &#91;required&#93; The DB instance identifier for the DB instance to be deleted. This
#' parameter isn't case-sensitive.
#' 
#' Constraints:
#' 
#' -   Must match the name of an existing DB instance.
#' @param SkipFinalSnapshot Determines whether a final DB snapshot is created before the DB instance
#' is deleted. If `true` is specified, no DBSnapshot is created. If `false`
#' is specified, a DB snapshot is created before the DB instance is
#' deleted.
#' 
#' Note that when a DB instance is in a failure state and has a status of
#' 'failed', 'incompatible-restore', or 'incompatible-network', it can only
#' be deleted when the SkipFinalSnapshot parameter is set to "true".
#' 
#' Specify `true` when deleting a Read Replica.
#' 
#' The FinalDBSnapshotIdentifier parameter must be specified if
#' SkipFinalSnapshot is `false`.
#' 
#' Default: `false`
#' @param FinalDBSnapshotIdentifier The DBSnapshotIdentifier of the new DBSnapshot created when
#' SkipFinalSnapshot is set to `false`.
#' 
#' Specifying this parameter and also setting the SkipFinalShapshot
#' parameter to true results in an error.
#' 
#' Constraints:
#' 
#' -   Must be 1 to 255 letters or numbers.
#' 
#' -   First character must be a letter
#' 
#' -   Cannot end with a hyphen or contain two consecutive hyphens
#' 
#' -   Cannot be specified when deleting a Read Replica.
#'
#' @keywords internal
#'
#' @rdname neptune_delete_db_instance
neptune_delete_db_instance <- function(DBInstanceIdentifier, SkipFinalSnapshot = NULL, FinalDBSnapshotIdentifier = NULL) {
  op <- new_operation(
    name = "DeleteDBInstance",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .neptune$delete_db_instance_input(DBInstanceIdentifier = DBInstanceIdentifier, SkipFinalSnapshot = SkipFinalSnapshot, FinalDBSnapshotIdentifier = FinalDBSnapshotIdentifier)
  output <- .neptune$delete_db_instance_output()
  config <- get_config()
  svc <- .neptune$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.neptune$operations$delete_db_instance <- neptune_delete_db_instance

#' Deletes a specified DBParameterGroup
#'
#' @description
#' Deletes a specified DBParameterGroup. The DBParameterGroup to be deleted can't be associated with any DB instances.
#'
#' See [https://www.paws-r-sdk.com/docs/neptune_delete_db_parameter_group/](https://www.paws-r-sdk.com/docs/neptune_delete_db_parameter_group/) for full documentation.
#'
#' @param DBParameterGroupName &#91;required&#93; The name of the DB parameter group.
#' 
#' Constraints:
#' 
#' -   Must be the name of an existing DB parameter group
#' 
#' -   You can't delete a default DB parameter group
#' 
#' -   Cannot be associated with any DB instances
#'
#' @keywords internal
#'
#' @rdname neptune_delete_db_parameter_group
neptune_delete_db_parameter_group <- function(DBParameterGroupName) {
  op <- new_operation(
    name = "DeleteDBParameterGroup",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .neptune$delete_db_parameter_group_input(DBParameterGroupName = DBParameterGroupName)
  output <- .neptune$delete_db_parameter_group_output()
  config <- get_config()
  svc <- .neptune$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.neptune$operations$delete_db_parameter_group <- neptune_delete_db_parameter_group

#' Deletes a DB subnet group
#'
#' @description
#' Deletes a DB subnet group.
#'
#' See [https://www.paws-r-sdk.com/docs/neptune_delete_db_subnet_group/](https://www.paws-r-sdk.com/docs/neptune_delete_db_subnet_group/) for full documentation.
#'
#' @param DBSubnetGroupName &#91;required&#93; The name of the database subnet group to delete.
#' 
#' You can't delete the default subnet group.
#' 
#' Constraints:
#' 
#' Constraints: Must match the name of an existing DBSubnetGroup. Must not
#' be default.
#' 
#' Example: `mySubnetgroup`
#'
#' @keywords internal
#'
#' @rdname neptune_delete_db_subnet_group
neptune_delete_db_subnet_group <- function(DBSubnetGroupName) {
  op <- new_operation(
    name = "DeleteDBSubnetGroup",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .neptune$delete_db_subnet_group_input(DBSubnetGroupName = DBSubnetGroupName)
  output <- .neptune$delete_db_subnet_group_output()
  config <- get_config()
  svc <- .neptune$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.neptune$operations$delete_db_subnet_group <- neptune_delete_db_subnet_group

#' Deletes an event notification subscription
#'
#' @description
#' Deletes an event notification subscription.
#'
#' See [https://www.paws-r-sdk.com/docs/neptune_delete_event_subscription/](https://www.paws-r-sdk.com/docs/neptune_delete_event_subscription/) for full documentation.
#'
#' @param SubscriptionName &#91;required&#93; The name of the event notification subscription you want to delete.
#'
#' @keywords internal
#'
#' @rdname neptune_delete_event_subscription
neptune_delete_event_subscription <- function(SubscriptionName) {
  op <- new_operation(
    name = "DeleteEventSubscription",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .neptune$delete_event_subscription_input(SubscriptionName = SubscriptionName)
  output <- .neptune$delete_event_subscription_output()
  config <- get_config()
  svc <- .neptune$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.neptune$operations$delete_event_subscription <- neptune_delete_event_subscription

#' Deletes a global database
#'
#' @description
#' Deletes a global database. The primary and all secondary clusters must already be detached or deleted first.
#'
#' See [https://www.paws-r-sdk.com/docs/neptune_delete_global_cluster/](https://www.paws-r-sdk.com/docs/neptune_delete_global_cluster/) for full documentation.
#'
#' @param GlobalClusterIdentifier &#91;required&#93; The cluster identifier of the global database cluster being deleted.
#'
#' @keywords internal
#'
#' @rdname neptune_delete_global_cluster
neptune_delete_global_cluster <- function(GlobalClusterIdentifier) {
  op <- new_operation(
    name = "DeleteGlobalCluster",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .neptune$delete_global_cluster_input(GlobalClusterIdentifier = GlobalClusterIdentifier)
  output <- .neptune$delete_global_cluster_output()
  config <- get_config()
  svc <- .neptune$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.neptune$operations$delete_global_cluster <- neptune_delete_global_cluster

#' Returns information about endpoints for an Amazon Neptune DB cluster
#'
#' @description
#' Returns information about endpoints for an Amazon Neptune DB cluster.
#'
#' See [https://www.paws-r-sdk.com/docs/neptune_describe_db_cluster_endpoints/](https://www.paws-r-sdk.com/docs/neptune_describe_db_cluster_endpoints/) for full documentation.
#'
#' @param DBClusterIdentifier The DB cluster identifier of the DB cluster associated with the
#' endpoint. This parameter is stored as a lowercase string.
#' @param DBClusterEndpointIdentifier The identifier of the endpoint to describe. This parameter is stored as
#' a lowercase string.
#' @param Filters A set of name-value pairs that define which endpoints to include in the
#' output. The filters are specified as name-value pairs, in the format
#' `Name=endpoint_type,Values=endpoint_type1,endpoint_type2,...`. `Name`
#' can be one of: `db-cluster-endpoint-type`,
#' `db-cluster-endpoint-custom-type`, `db-cluster-endpoint-id`,
#' `db-cluster-endpoint-status`. `Values` for the
#' ` db-cluster-endpoint-type` filter can be one or more of: `reader`,
#' `writer`, `custom`. `Values` for the `db-cluster-endpoint-custom-type`
#' filter can be one or more of: `reader`, `any`. `Values` for the
#' `db-cluster-endpoint-status` filter can be one or more of: `available`,
#' `creating`, `deleting`, `inactive`, `modifying`.
#' @param MaxRecords The maximum number of records to include in the response. If more
#' records exist than the specified `MaxRecords` value, a pagination token
#' called a marker is included in the response so you can retrieve the
#' remaining results.
#' 
#' Default: 100
#' 
#' Constraints: Minimum 20, maximum 100.
#' @param Marker An optional pagination token provided by a previous
#' [`describe_db_cluster_endpoints`][neptune_describe_db_cluster_endpoints]
#' request. If this parameter is specified, the response includes only
#' records beyond the marker, up to the value specified by `MaxRecords`.
#'
#' @keywords internal
#'
#' @rdname neptune_describe_db_cluster_endpoints
neptune_describe_db_cluster_endpoints <- function(DBClusterIdentifier = NULL, DBClusterEndpointIdentifier = NULL, Filters = NULL, MaxRecords = NULL, Marker = NULL) {
  op <- new_operation(
    name = "DescribeDBClusterEndpoints",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "Marker", limit_key = "MaxRecords", output_token = "Marker", result_key = "DBClusterEndpoints"),
    stream_api = FALSE
  )
  input <- .neptune$describe_db_cluster_endpoints_input(DBClusterIdentifier = DBClusterIdentifier, DBClusterEndpointIdentifier = DBClusterEndpointIdentifier, Filters = Filters, MaxRecords = MaxRecords, Marker = Marker)
  output <- .neptune$describe_db_cluster_endpoints_output()
  config <- get_config()
  svc <- .neptune$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.neptune$operations$describe_db_cluster_endpoints <- neptune_describe_db_cluster_endpoints

#' Returns a list of DBClusterParameterGroup descriptions
#'
#' @description
#' Returns a list of `DBClusterParameterGroup` descriptions. If a `DBClusterParameterGroupName` parameter is specified, the list will contain only the description of the specified DB cluster parameter group.
#'
#' See [https://www.paws-r-sdk.com/docs/neptune_describe_db_cluster_parameter_groups/](https://www.paws-r-sdk.com/docs/neptune_describe_db_cluster_parameter_groups/) for full documentation.
#'
#' @param DBClusterParameterGroupName The name of a specific DB cluster parameter group to return details for.
#' 
#' Constraints:
#' 
#' -   If supplied, must match the name of an existing
#'     DBClusterParameterGroup.
#' @param Filters This parameter is not currently supported.
#' @param MaxRecords The maximum number of records to include in the response. If more
#' records exist than the specified `MaxRecords` value, a pagination token
#' called a marker is included in the response so that the remaining
#' results can be retrieved.
#' 
#' Default: 100
#' 
#' Constraints: Minimum 20, maximum 100.
#' @param Marker An optional pagination token provided by a previous
#' [`describe_db_cluster_parameter_groups`][neptune_describe_db_cluster_parameter_groups]
#' request. If this parameter is specified, the response includes only
#' records beyond the marker, up to the value specified by `MaxRecords`.
#'
#' @keywords internal
#'
#' @rdname neptune_describe_db_cluster_parameter_groups
neptune_describe_db_cluster_parameter_groups <- function(DBClusterParameterGroupName = NULL, Filters = NULL, MaxRecords = NULL, Marker = NULL) {
  op <- new_operation(
    name = "DescribeDBClusterParameterGroups",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "Marker", limit_key = "MaxRecords", output_token = "Marker", result_key = "DBClusterParameterGroups"),
    stream_api = FALSE
  )
  input <- .neptune$describe_db_cluster_parameter_groups_input(DBClusterParameterGroupName = DBClusterParameterGroupName, Filters = Filters, MaxRecords = MaxRecords, Marker = Marker)
  output <- .neptune$describe_db_cluster_parameter_groups_output()
  config <- get_config()
  svc <- .neptune$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.neptune$operations$describe_db_cluster_parameter_groups <- neptune_describe_db_cluster_parameter_groups

#' Returns the detailed parameter list for a particular DB cluster
#' parameter group
#'
#' @description
#' Returns the detailed parameter list for a particular DB cluster parameter group.
#'
#' See [https://www.paws-r-sdk.com/docs/neptune_describe_db_cluster_parameters/](https://www.paws-r-sdk.com/docs/neptune_describe_db_cluster_parameters/) for full documentation.
#'
#' @param DBClusterParameterGroupName &#91;required&#93; The name of a specific DB cluster parameter group to return parameter
#' details for.
#' 
#' Constraints:
#' 
#' -   If supplied, must match the name of an existing
#'     DBClusterParameterGroup.
#' @param Source A value that indicates to return only parameters for a specific source.
#' Parameter sources can be `engine`, `service`, or `customer`.
#' @param Filters This parameter is not currently supported.
#' @param MaxRecords The maximum number of records to include in the response. If more
#' records exist than the specified `MaxRecords` value, a pagination token
#' called a marker is included in the response so that the remaining
#' results can be retrieved.
#' 
#' Default: 100
#' 
#' Constraints: Minimum 20, maximum 100.
#' @param Marker An optional pagination token provided by a previous
#' [`describe_db_cluster_parameters`][neptune_describe_db_cluster_parameters]
#' request. If this parameter is specified, the response includes only
#' records beyond the marker, up to the value specified by `MaxRecords`.
#'
#' @keywords internal
#'
#' @rdname neptune_describe_db_cluster_parameters
neptune_describe_db_cluster_parameters <- function(DBClusterParameterGroupName, Source = NULL, Filters = NULL, MaxRecords = NULL, Marker = NULL) {
  op <- new_operation(
    name = "DescribeDBClusterParameters",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "Marker", limit_key = "MaxRecords", output_token = "Marker", result_key = "Parameters"),
    stream_api = FALSE
  )
  input <- .neptune$describe_db_cluster_parameters_input(DBClusterParameterGroupName = DBClusterParameterGroupName, Source = Source, Filters = Filters, MaxRecords = MaxRecords, Marker = Marker)
  output <- .neptune$describe_db_cluster_parameters_output()
  config <- get_config()
  svc <- .neptune$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.neptune$operations$describe_db_cluster_parameters <- neptune_describe_db_cluster_parameters

#' Returns a list of DB cluster snapshot attribute names and values for a
#' manual DB cluster snapshot
#'
#' @description
#' Returns a list of DB cluster snapshot attribute names and values for a manual DB cluster snapshot.
#'
#' See [https://www.paws-r-sdk.com/docs/neptune_describe_db_cluster_snapshot_attributes/](https://www.paws-r-sdk.com/docs/neptune_describe_db_cluster_snapshot_attributes/) for full documentation.
#'
#' @param DBClusterSnapshotIdentifier &#91;required&#93; The identifier for the DB cluster snapshot to describe the attributes
#' for.
#'
#' @keywords internal
#'
#' @rdname neptune_describe_db_cluster_snapshot_attributes
neptune_describe_db_cluster_snapshot_attributes <- function(DBClusterSnapshotIdentifier) {
  op <- new_operation(
    name = "DescribeDBClusterSnapshotAttributes",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .neptune$describe_db_cluster_snapshot_attributes_input(DBClusterSnapshotIdentifier = DBClusterSnapshotIdentifier)
  output <- .neptune$describe_db_cluster_snapshot_attributes_output()
  config <- get_config()
  svc <- .neptune$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.neptune$operations$describe_db_cluster_snapshot_attributes <- neptune_describe_db_cluster_snapshot_attributes

#' Returns information about DB cluster snapshots
#'
#' @description
#' Returns information about DB cluster snapshots. This API action supports pagination.
#'
#' See [https://www.paws-r-sdk.com/docs/neptune_describe_db_cluster_snapshots/](https://www.paws-r-sdk.com/docs/neptune_describe_db_cluster_snapshots/) for full documentation.
#'
#' @param DBClusterIdentifier The ID of the DB cluster to retrieve the list of DB cluster snapshots
#' for. This parameter can't be used in conjunction with the
#' `DBClusterSnapshotIdentifier` parameter. This parameter is not
#' case-sensitive.
#' 
#' Constraints:
#' 
#' -   If supplied, must match the identifier of an existing DBCluster.
#' @param DBClusterSnapshotIdentifier A specific DB cluster snapshot identifier to describe. This parameter
#' can't be used in conjunction with the `DBClusterIdentifier` parameter.
#' This value is stored as a lowercase string.
#' 
#' Constraints:
#' 
#' -   If supplied, must match the identifier of an existing
#'     DBClusterSnapshot.
#' 
#' -   If this identifier is for an automated snapshot, the `SnapshotType`
#'     parameter must also be specified.
#' @param SnapshotType The type of DB cluster snapshots to be returned. You can specify one of
#' the following values:
#' 
#' -   `automated` - Return all DB cluster snapshots that have been
#'     automatically taken by Amazon Neptune for my Amazon account.
#' 
#' -   `manual` - Return all DB cluster snapshots that have been taken by
#'     my Amazon account.
#' 
#' -   `shared` - Return all manual DB cluster snapshots that have been
#'     shared to my Amazon account.
#' 
#' -   `public` - Return all DB cluster snapshots that have been marked as
#'     public.
#' 
#' If you don't specify a `SnapshotType` value, then both automated and
#' manual DB cluster snapshots are returned. You can include shared DB
#' cluster snapshots with these results by setting the `IncludeShared`
#' parameter to `true`. You can include public DB cluster snapshots with
#' these results by setting the `IncludePublic` parameter to `true`.
#' 
#' The `IncludeShared` and `IncludePublic` parameters don't apply for
#' `SnapshotType` values of `manual` or `automated`. The `IncludePublic`
#' parameter doesn't apply when `SnapshotType` is set to `shared`. The
#' `IncludeShared` parameter doesn't apply when `SnapshotType` is set to
#' `public`.
#' @param Filters This parameter is not currently supported.
#' @param MaxRecords The maximum number of records to include in the response. If more
#' records exist than the specified `MaxRecords` value, a pagination token
#' called a marker is included in the response so that the remaining
#' results can be retrieved.
#' 
#' Default: 100
#' 
#' Constraints: Minimum 20, maximum 100.
#' @param Marker An optional pagination token provided by a previous
#' [`describe_db_cluster_snapshots`][neptune_describe_db_cluster_snapshots]
#' request. If this parameter is specified, the response includes only
#' records beyond the marker, up to the value specified by `MaxRecords`.
#' @param IncludeShared True to include shared manual DB cluster snapshots from other Amazon
#' accounts that this Amazon account has been given permission to copy or
#' restore, and otherwise false. The default is `false`.
#' 
#' You can give an Amazon account permission to restore a manual DB cluster
#' snapshot from another Amazon account by the
#' [`modify_db_cluster_snapshot_attribute`][neptune_modify_db_cluster_snapshot_attribute]
#' API action.
#' @param IncludePublic True to include manual DB cluster snapshots that are public and can be
#' copied or restored by any Amazon account, and otherwise false. The
#' default is `false`. The default is false.
#' 
#' You can share a manual DB cluster snapshot as public by using the
#' [`modify_db_cluster_snapshot_attribute`][neptune_modify_db_cluster_snapshot_attribute]
#' API action.
#'
#' @keywords internal
#'
#' @rdname neptune_describe_db_cluster_snapshots
neptune_describe_db_cluster_snapshots <- function(DBClusterIdentifier = NULL, DBClusterSnapshotIdentifier = NULL, SnapshotType = NULL, Filters = NULL, MaxRecords = NULL, Marker = NULL, IncludeShared = NULL, IncludePublic = NULL) {
  op <- new_operation(
    name = "DescribeDBClusterSnapshots",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "Marker", limit_key = "MaxRecords", output_token = "Marker", result_key = "DBClusterSnapshots"),
    stream_api = FALSE
  )
  input <- .neptune$describe_db_cluster_snapshots_input(DBClusterIdentifier = DBClusterIdentifier, DBClusterSnapshotIdentifier = DBClusterSnapshotIdentifier, SnapshotType = SnapshotType, Filters = Filters, MaxRecords = MaxRecords, Marker = Marker, IncludeShared = IncludeShared, IncludePublic = IncludePublic)
  output <- .neptune$describe_db_cluster_snapshots_output()
  config <- get_config()
  svc <- .neptune$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.neptune$operations$describe_db_cluster_snapshots <- neptune_describe_db_cluster_snapshots

#' Returns information about provisioned DB clusters, and supports
#' pagination
#'
#' @description
#' Returns information about provisioned DB clusters, and supports pagination.
#'
#' See [https://www.paws-r-sdk.com/docs/neptune_describe_db_clusters/](https://www.paws-r-sdk.com/docs/neptune_describe_db_clusters/) for full documentation.
#'
#' @param DBClusterIdentifier The user-supplied DB cluster identifier. If this parameter is specified,
#' information from only the specific DB cluster is returned. This
#' parameter isn't case-sensitive.
#' 
#' Constraints:
#' 
#' -   If supplied, must match an existing DBClusterIdentifier.
#' @param Filters A filter that specifies one or more DB clusters to describe.
#' 
#' Supported filters:
#' 
#' -   `db-cluster-id` - Accepts DB cluster identifiers and DB cluster
#'     Amazon Resource Names (ARNs). The results list will only include
#'     information about the DB clusters identified by these ARNs.
#' 
#' -   `engine` - Accepts an engine name (such as `neptune`), and restricts
#'     the results list to DB clusters created by that engine.
#' 
#' For example, to invoke this API from the Amazon CLI and filter so that
#' only Neptune DB clusters are returned, you could use the following
#' command:
#' @param MaxRecords The maximum number of records to include in the response. If more
#' records exist than the specified `MaxRecords` value, a pagination token
#' called a marker is included in the response so that the remaining
#' results can be retrieved.
#' 
#' Default: 100
#' 
#' Constraints: Minimum 20, maximum 100.
#' @param Marker An optional pagination token provided by a previous
#' [`describe_db_clusters`][neptune_describe_db_clusters] request. If this
#' parameter is specified, the response includes only records beyond the
#' marker, up to the value specified by `MaxRecords`.
#'
#' @keywords internal
#'
#' @rdname neptune_describe_db_clusters
neptune_describe_db_clusters <- function(DBClusterIdentifier = NULL, Filters = NULL, MaxRecords = NULL, Marker = NULL) {
  op <- new_operation(
    name = "DescribeDBClusters",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "Marker", limit_key = "MaxRecords", output_token = "Marker", result_key = "DBClusters"),
    stream_api = FALSE
  )
  input <- .neptune$describe_db_clusters_input(DBClusterIdentifier = DBClusterIdentifier, Filters = Filters, MaxRecords = MaxRecords, Marker = Marker)
  output <- .neptune$describe_db_clusters_output()
  config <- get_config()
  svc <- .neptune$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.neptune$operations$describe_db_clusters <- neptune_describe_db_clusters

#' Returns a list of the available DB engines
#'
#' @description
#' Returns a list of the available DB engines.
#'
#' See [https://www.paws-r-sdk.com/docs/neptune_describe_db_engine_versions/](https://www.paws-r-sdk.com/docs/neptune_describe_db_engine_versions/) for full documentation.
#'
#' @param Engine The database engine to return.
#' @param EngineVersion The database engine version to return.
#' 
#' Example: `5.1.49`
#' @param DBParameterGroupFamily The name of a specific DB parameter group family to return details for.
#' 
#' Constraints:
#' 
#' -   If supplied, must match an existing DBParameterGroupFamily.
#' @param Filters Not currently supported.
#' @param MaxRecords The maximum number of records to include in the response. If more than
#' the `MaxRecords` value is available, a pagination token called a marker
#' is included in the response so that the following results can be
#' retrieved.
#' 
#' Default: 100
#' 
#' Constraints: Minimum 20, maximum 100.
#' @param Marker An optional pagination token provided by a previous request. If this
#' parameter is specified, the response includes only records beyond the
#' marker, up to the value specified by `MaxRecords`.
#' @param DefaultOnly Indicates that only the default version of the specified engine or
#' engine and major version combination is returned.
#' @param ListSupportedCharacterSets If this parameter is specified and the requested engine supports the
#' `CharacterSetName` parameter for
#' [`create_db_instance`][neptune_create_db_instance], the response
#' includes a list of supported character sets for each engine version.
#' @param ListSupportedTimezones If this parameter is specified and the requested engine supports the
#' `TimeZone` parameter for
#' [`create_db_instance`][neptune_create_db_instance], the response
#' includes a list of supported time zones for each engine version.
#'
#' @keywords internal
#'
#' @rdname neptune_describe_db_engine_versions
neptune_describe_db_engine_versions <- function(Engine = NULL, EngineVersion = NULL, DBParameterGroupFamily = NULL, Filters = NULL, MaxRecords = NULL, Marker = NULL, DefaultOnly = NULL, ListSupportedCharacterSets = NULL, ListSupportedTimezones = NULL) {
  op <- new_operation(
    name = "DescribeDBEngineVersions",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "Marker", limit_key = "MaxRecords", output_token = "Marker", result_key = "DBEngineVersions"),
    stream_api = FALSE
  )
  input <- .neptune$describe_db_engine_versions_input(Engine = Engine, EngineVersion = EngineVersion, DBParameterGroupFamily = DBParameterGroupFamily, Filters = Filters, MaxRecords = MaxRecords, Marker = Marker, DefaultOnly = DefaultOnly, ListSupportedCharacterSets = ListSupportedCharacterSets, ListSupportedTimezones = ListSupportedTimezones)
  output <- .neptune$describe_db_engine_versions_output()
  config <- get_config()
  svc <- .neptune$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.neptune$operations$describe_db_engine_versions <- neptune_describe_db_engine_versions

#' Returns information about provisioned instances, and supports pagination
#'
#' @description
#' Returns information about provisioned instances, and supports pagination.
#'
#' See [https://www.paws-r-sdk.com/docs/neptune_describe_db_instances/](https://www.paws-r-sdk.com/docs/neptune_describe_db_instances/) for full documentation.
#'
#' @param DBInstanceIdentifier The user-supplied instance identifier. If this parameter is specified,
#' information from only the specific DB instance is returned. This
#' parameter isn't case-sensitive.
#' 
#' Constraints:
#' 
#' -   If supplied, must match the identifier of an existing DBInstance.
#' @param Filters A filter that specifies one or more DB instances to describe.
#' 
#' Supported filters:
#' 
#' -   `db-cluster-id` - Accepts DB cluster identifiers and DB cluster
#'     Amazon Resource Names (ARNs). The results list will only include
#'     information about the DB instances associated with the DB clusters
#'     identified by these ARNs.
#' 
#' -   `engine` - Accepts an engine name (such as `neptune`), and restricts
#'     the results list to DB instances created by that engine.
#' 
#' For example, to invoke this API from the Amazon CLI and filter so that
#' only Neptune DB instances are returned, you could use the following
#' command:
#' @param MaxRecords The maximum number of records to include in the response. If more
#' records exist than the specified `MaxRecords` value, a pagination token
#' called a marker is included in the response so that the remaining
#' results can be retrieved.
#' 
#' Default: 100
#' 
#' Constraints: Minimum 20, maximum 100.
#' @param Marker An optional pagination token provided by a previous
#' [`describe_db_instances`][neptune_describe_db_instances] request. If
#' this parameter is specified, the response includes only records beyond
#' the marker, up to the value specified by `MaxRecords`.
#'
#' @keywords internal
#'
#' @rdname neptune_describe_db_instances
neptune_describe_db_instances <- function(DBInstanceIdentifier = NULL, Filters = NULL, MaxRecords = NULL, Marker = NULL) {
  op <- new_operation(
    name = "DescribeDBInstances",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "Marker", limit_key = "MaxRecords", output_token = "Marker", result_key = "DBInstances"),
    stream_api = FALSE
  )
  input <- .neptune$describe_db_instances_input(DBInstanceIdentifier = DBInstanceIdentifier, Filters = Filters, MaxRecords = MaxRecords, Marker = Marker)
  output <- .neptune$describe_db_instances_output()
  config <- get_config()
  svc <- .neptune$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.neptune$operations$describe_db_instances <- neptune_describe_db_instances

#' Returns a list of DBParameterGroup descriptions
#'
#' @description
#' Returns a list of `DBParameterGroup` descriptions. If a `DBParameterGroupName` is specified, the list will contain only the description of the specified DB parameter group.
#'
#' See [https://www.paws-r-sdk.com/docs/neptune_describe_db_parameter_groups/](https://www.paws-r-sdk.com/docs/neptune_describe_db_parameter_groups/) for full documentation.
#'
#' @param DBParameterGroupName The name of a specific DB parameter group to return details for.
#' 
#' Constraints:
#' 
#' -   If supplied, must match the name of an existing
#'     DBClusterParameterGroup.
#' @param Filters This parameter is not currently supported.
#' @param MaxRecords The maximum number of records to include in the response. If more
#' records exist than the specified `MaxRecords` value, a pagination token
#' called a marker is included in the response so that the remaining
#' results can be retrieved.
#' 
#' Default: 100
#' 
#' Constraints: Minimum 20, maximum 100.
#' @param Marker An optional pagination token provided by a previous
#' [`describe_db_parameter_groups`][neptune_describe_db_parameter_groups]
#' request. If this parameter is specified, the response includes only
#' records beyond the marker, up to the value specified by `MaxRecords`.
#'
#' @keywords internal
#'
#' @rdname neptune_describe_db_parameter_groups
neptune_describe_db_parameter_groups <- function(DBParameterGroupName = NULL, Filters = NULL, MaxRecords = NULL, Marker = NULL) {
  op <- new_operation(
    name = "DescribeDBParameterGroups",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "Marker", limit_key = "MaxRecords", output_token = "Marker", result_key = "DBParameterGroups"),
    stream_api = FALSE
  )
  input <- .neptune$describe_db_parameter_groups_input(DBParameterGroupName = DBParameterGroupName, Filters = Filters, MaxRecords = MaxRecords, Marker = Marker)
  output <- .neptune$describe_db_parameter_groups_output()
  config <- get_config()
  svc <- .neptune$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.neptune$operations$describe_db_parameter_groups <- neptune_describe_db_parameter_groups

#' Returns the detailed parameter list for a particular DB parameter group
#'
#' @description
#' Returns the detailed parameter list for a particular DB parameter group.
#'
#' See [https://www.paws-r-sdk.com/docs/neptune_describe_db_parameters/](https://www.paws-r-sdk.com/docs/neptune_describe_db_parameters/) for full documentation.
#'
#' @param DBParameterGroupName &#91;required&#93; The name of a specific DB parameter group to return details for.
#' 
#' Constraints:
#' 
#' -   If supplied, must match the name of an existing DBParameterGroup.
#' @param Source The parameter types to return.
#' 
#' Default: All parameter types returned
#' 
#' Valid Values: `user | system | engine-default`
#' @param Filters This parameter is not currently supported.
#' @param MaxRecords The maximum number of records to include in the response. If more
#' records exist than the specified `MaxRecords` value, a pagination token
#' called a marker is included in the response so that the remaining
#' results can be retrieved.
#' 
#' Default: 100
#' 
#' Constraints: Minimum 20, maximum 100.
#' @param Marker An optional pagination token provided by a previous
#' [`describe_db_parameters`][neptune_describe_db_parameters] request. If
#' this parameter is specified, the response includes only records beyond
#' the marker, up to the value specified by `MaxRecords`.
#'
#' @keywords internal
#'
#' @rdname neptune_describe_db_parameters
neptune_describe_db_parameters <- function(DBParameterGroupName, Source = NULL, Filters = NULL, MaxRecords = NULL, Marker = NULL) {
  op <- new_operation(
    name = "DescribeDBParameters",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "Marker", limit_key = "MaxRecords", output_token = "Marker", result_key = "Parameters"),
    stream_api = FALSE
  )
  input <- .neptune$describe_db_parameters_input(DBParameterGroupName = DBParameterGroupName, Source = Source, Filters = Filters, MaxRecords = MaxRecords, Marker = Marker)
  output <- .neptune$describe_db_parameters_output()
  config <- get_config()
  svc <- .neptune$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.neptune$operations$describe_db_parameters <- neptune_describe_db_parameters

#' Returns a list of DBSubnetGroup descriptions
#'
#' @description
#' Returns a list of DBSubnetGroup descriptions. If a DBSubnetGroupName is specified, the list will contain only the descriptions of the specified DBSubnetGroup.
#'
#' See [https://www.paws-r-sdk.com/docs/neptune_describe_db_subnet_groups/](https://www.paws-r-sdk.com/docs/neptune_describe_db_subnet_groups/) for full documentation.
#'
#' @param DBSubnetGroupName The name of the DB subnet group to return details for.
#' @param Filters This parameter is not currently supported.
#' @param MaxRecords The maximum number of records to include in the response. If more
#' records exist than the specified `MaxRecords` value, a pagination token
#' called a marker is included in the response so that the remaining
#' results can be retrieved.
#' 
#' Default: 100
#' 
#' Constraints: Minimum 20, maximum 100.
#' @param Marker An optional pagination token provided by a previous
#' DescribeDBSubnetGroups request. If this parameter is specified, the
#' response includes only records beyond the marker, up to the value
#' specified by `MaxRecords`.
#'
#' @keywords internal
#'
#' @rdname neptune_describe_db_subnet_groups
neptune_describe_db_subnet_groups <- function(DBSubnetGroupName = NULL, Filters = NULL, MaxRecords = NULL, Marker = NULL) {
  op <- new_operation(
    name = "DescribeDBSubnetGroups",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "Marker", limit_key = "MaxRecords", output_token = "Marker", result_key = "DBSubnetGroups"),
    stream_api = FALSE
  )
  input <- .neptune$describe_db_subnet_groups_input(DBSubnetGroupName = DBSubnetGroupName, Filters = Filters, MaxRecords = MaxRecords, Marker = Marker)
  output <- .neptune$describe_db_subnet_groups_output()
  config <- get_config()
  svc <- .neptune$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.neptune$operations$describe_db_subnet_groups <- neptune_describe_db_subnet_groups

#' Returns the default engine and system parameter information for the
#' cluster database engine
#'
#' @description
#' Returns the default engine and system parameter information for the cluster database engine.
#'
#' See [https://www.paws-r-sdk.com/docs/neptune_describe_engine_default_cluster_parameters/](https://www.paws-r-sdk.com/docs/neptune_describe_engine_default_cluster_parameters/) for full documentation.
#'
#' @param DBParameterGroupFamily &#91;required&#93; The name of the DB cluster parameter group family to return engine
#' parameter information for.
#' @param Filters This parameter is not currently supported.
#' @param MaxRecords The maximum number of records to include in the response. If more
#' records exist than the specified `MaxRecords` value, a pagination token
#' called a marker is included in the response so that the remaining
#' results can be retrieved.
#' 
#' Default: 100
#' 
#' Constraints: Minimum 20, maximum 100.
#' @param Marker An optional pagination token provided by a previous
#' [`describe_engine_default_cluster_parameters`][neptune_describe_engine_default_cluster_parameters]
#' request. If this parameter is specified, the response includes only
#' records beyond the marker, up to the value specified by `MaxRecords`.
#'
#' @keywords internal
#'
#' @rdname neptune_describe_engine_default_cluster_parameters
neptune_describe_engine_default_cluster_parameters <- function(DBParameterGroupFamily, Filters = NULL, MaxRecords = NULL, Marker = NULL) {
  op <- new_operation(
    name = "DescribeEngineDefaultClusterParameters",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .neptune$describe_engine_default_cluster_parameters_input(DBParameterGroupFamily = DBParameterGroupFamily, Filters = Filters, MaxRecords = MaxRecords, Marker = Marker)
  output <- .neptune$describe_engine_default_cluster_parameters_output()
  config <- get_config()
  svc <- .neptune$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.neptune$operations$describe_engine_default_cluster_parameters <- neptune_describe_engine_default_cluster_parameters

#' Returns the default engine and system parameter information for the
#' specified database engine
#'
#' @description
#' Returns the default engine and system parameter information for the specified database engine.
#'
#' See [https://www.paws-r-sdk.com/docs/neptune_describe_engine_default_parameters/](https://www.paws-r-sdk.com/docs/neptune_describe_engine_default_parameters/) for full documentation.
#'
#' @param DBParameterGroupFamily &#91;required&#93; The name of the DB parameter group family.
#' @param Filters Not currently supported.
#' @param MaxRecords The maximum number of records to include in the response. If more
#' records exist than the specified `MaxRecords` value, a pagination token
#' called a marker is included in the response so that the remaining
#' results can be retrieved.
#' 
#' Default: 100
#' 
#' Constraints: Minimum 20, maximum 100.
#' @param Marker An optional pagination token provided by a previous
#' [`describe_engine_default_parameters`][neptune_describe_engine_default_parameters]
#' request. If this parameter is specified, the response includes only
#' records beyond the marker, up to the value specified by `MaxRecords`.
#'
#' @keywords internal
#'
#' @rdname neptune_describe_engine_default_parameters
neptune_describe_engine_default_parameters <- function(DBParameterGroupFamily, Filters = NULL, MaxRecords = NULL, Marker = NULL) {
  op <- new_operation(
    name = "DescribeEngineDefaultParameters",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "Marker", limit_key = "MaxRecords", output_token = "EngineDefaults.Marker", result_key = "EngineDefaults.Parameters"),
    stream_api = FALSE
  )
  input <- .neptune$describe_engine_default_parameters_input(DBParameterGroupFamily = DBParameterGroupFamily, Filters = Filters, MaxRecords = MaxRecords, Marker = Marker)
  output <- .neptune$describe_engine_default_parameters_output()
  config <- get_config()
  svc <- .neptune$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.neptune$operations$describe_engine_default_parameters <- neptune_describe_engine_default_parameters

#' Displays a list of categories for all event source types, or, if
#' specified, for a specified source type
#'
#' @description
#' Displays a list of categories for all event source types, or, if specified, for a specified source type.
#'
#' See [https://www.paws-r-sdk.com/docs/neptune_describe_event_categories/](https://www.paws-r-sdk.com/docs/neptune_describe_event_categories/) for full documentation.
#'
#' @param SourceType The type of source that is generating the events.
#' 
#' Valid values: db-instance | db-parameter-group | db-security-group |
#' db-snapshot
#' @param Filters This parameter is not currently supported.
#'
#' @keywords internal
#'
#' @rdname neptune_describe_event_categories
neptune_describe_event_categories <- function(SourceType = NULL, Filters = NULL) {
  op <- new_operation(
    name = "DescribeEventCategories",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .neptune$describe_event_categories_input(SourceType = SourceType, Filters = Filters)
  output <- .neptune$describe_event_categories_output()
  config <- get_config()
  svc <- .neptune$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.neptune$operations$describe_event_categories <- neptune_describe_event_categories

#' Lists all the subscription descriptions for a customer account
#'
#' @description
#' Lists all the subscription descriptions for a customer account. The description for a subscription includes SubscriptionName, SNSTopicARN, CustomerID, SourceType, SourceID, CreationTime, and Status.
#'
#' See [https://www.paws-r-sdk.com/docs/neptune_describe_event_subscriptions/](https://www.paws-r-sdk.com/docs/neptune_describe_event_subscriptions/) for full documentation.
#'
#' @param SubscriptionName The name of the event notification subscription you want to describe.
#' @param Filters This parameter is not currently supported.
#' @param MaxRecords The maximum number of records to include in the response. If more
#' records exist than the specified `MaxRecords` value, a pagination token
#' called a marker is included in the response so that the remaining
#' results can be retrieved.
#' 
#' Default: 100
#' 
#' Constraints: Minimum 20, maximum 100.
#' @param Marker An optional pagination token provided by a previous
#' DescribeOrderableDBInstanceOptions request. If this parameter is
#' specified, the response includes only records beyond the marker, up to
#' the value specified by `MaxRecords` .
#'
#' @keywords internal
#'
#' @rdname neptune_describe_event_subscriptions
neptune_describe_event_subscriptions <- function(SubscriptionName = NULL, Filters = NULL, MaxRecords = NULL, Marker = NULL) {
  op <- new_operation(
    name = "DescribeEventSubscriptions",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "Marker", limit_key = "MaxRecords", output_token = "Marker", result_key = "EventSubscriptionsList"),
    stream_api = FALSE
  )
  input <- .neptune$describe_event_subscriptions_input(SubscriptionName = SubscriptionName, Filters = Filters, MaxRecords = MaxRecords, Marker = Marker)
  output <- .neptune$describe_event_subscriptions_output()
  config <- get_config()
  svc <- .neptune$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.neptune$operations$describe_event_subscriptions <- neptune_describe_event_subscriptions

#' Returns events related to DB instances, DB security groups, DB
#' snapshots, and DB parameter groups for the past 14 days
#'
#' @description
#' Returns events related to DB instances, DB security groups, DB snapshots, and DB parameter groups for the past 14 days. Events specific to a particular DB instance, DB security group, database snapshot, or DB parameter group can be obtained by providing the name as a parameter. By default, the past hour of events are returned.
#'
#' See [https://www.paws-r-sdk.com/docs/neptune_describe_events/](https://www.paws-r-sdk.com/docs/neptune_describe_events/) for full documentation.
#'
#' @param SourceIdentifier The identifier of the event source for which events are returned. If not
#' specified, then all sources are included in the response.
#' 
#' Constraints:
#' 
#' -   If SourceIdentifier is supplied, SourceType must also be provided.
#' 
#' -   If the source type is `DBInstance`, then a `DBInstanceIdentifier`
#'     must be supplied.
#' 
#' -   If the source type is `DBSecurityGroup`, a `DBSecurityGroupName`
#'     must be supplied.
#' 
#' -   If the source type is `DBParameterGroup`, a `DBParameterGroupName`
#'     must be supplied.
#' 
#' -   If the source type is `DBSnapshot`, a `DBSnapshotIdentifier` must be
#'     supplied.
#' 
#' -   Cannot end with a hyphen or contain two consecutive hyphens.
#' @param SourceType The event source to retrieve events for. If no value is specified, all
#' events are returned.
#' @param StartTime The beginning of the time interval to retrieve events for, specified in
#' ISO 8601 format. For more information about ISO 8601, go to the [ISO8601
#' Wikipedia page.](https://en.wikipedia.org/wiki/ISO_8601)
#' 
#' Example: 2009-07-08T18:00Z
#' @param EndTime The end of the time interval for which to retrieve events, specified in
#' ISO 8601 format. For more information about ISO 8601, go to the [ISO8601
#' Wikipedia page.](https://en.wikipedia.org/wiki/ISO_8601)
#' 
#' Example: 2009-07-08T18:00Z
#' @param Duration The number of minutes to retrieve events for.
#' 
#' Default: 60
#' @param EventCategories A list of event categories that trigger notifications for a event
#' notification subscription.
#' @param Filters This parameter is not currently supported.
#' @param MaxRecords The maximum number of records to include in the response. If more
#' records exist than the specified `MaxRecords` value, a pagination token
#' called a marker is included in the response so that the remaining
#' results can be retrieved.
#' 
#' Default: 100
#' 
#' Constraints: Minimum 20, maximum 100.
#' @param Marker An optional pagination token provided by a previous DescribeEvents
#' request. If this parameter is specified, the response includes only
#' records beyond the marker, up to the value specified by `MaxRecords`.
#'
#' @keywords internal
#'
#' @rdname neptune_describe_events
neptune_describe_events <- function(SourceIdentifier = NULL, SourceType = NULL, StartTime = NULL, EndTime = NULL, Duration = NULL, EventCategories = NULL, Filters = NULL, MaxRecords = NULL, Marker = NULL) {
  op <- new_operation(
    name = "DescribeEvents",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "Marker", limit_key = "MaxRecords", output_token = "Marker", result_key = "Events"),
    stream_api = FALSE
  )
  input <- .neptune$describe_events_input(SourceIdentifier = SourceIdentifier, SourceType = SourceType, StartTime = StartTime, EndTime = EndTime, Duration = Duration, EventCategories = EventCategories, Filters = Filters, MaxRecords = MaxRecords, Marker = Marker)
  output <- .neptune$describe_events_output()
  config <- get_config()
  svc <- .neptune$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.neptune$operations$describe_events <- neptune_describe_events

#' Returns information about Neptune global database clusters
#'
#' @description
#' Returns information about Neptune global database clusters. This API supports pagination.
#'
#' See [https://www.paws-r-sdk.com/docs/neptune_describe_global_clusters/](https://www.paws-r-sdk.com/docs/neptune_describe_global_clusters/) for full documentation.
#'
#' @param GlobalClusterIdentifier The user-supplied DB cluster identifier. If this parameter is specified,
#' only information about the specified DB cluster is returned. This
#' parameter is not case-sensitive.
#' 
#' Constraints: If supplied, must match an existing DB cluster identifier.
#' @param MaxRecords The maximum number of records to include in the response. If more
#' records exist than the specified `MaxRecords` value, a pagination marker
#' token is included in the response that you can use to retrieve the
#' remaining results.
#' 
#' Default: `100`
#' 
#' Constraints: Minimum 20, maximum 100.
#' @param Marker (*Optional*) A pagination token returned by a previous call to
#' [`describe_global_clusters`][neptune_describe_global_clusters]. If this
#' parameter is specified, the response will only include records beyond
#' the marker, up to the number specified by `MaxRecords`.
#'
#' @keywords internal
#'
#' @rdname neptune_describe_global_clusters
neptune_describe_global_clusters <- function(GlobalClusterIdentifier = NULL, MaxRecords = NULL, Marker = NULL) {
  op <- new_operation(
    name = "DescribeGlobalClusters",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "Marker", limit_key = "MaxRecords", output_token = "Marker", result_key = "GlobalClusters"),
    stream_api = FALSE
  )
  input <- .neptune$describe_global_clusters_input(GlobalClusterIdentifier = GlobalClusterIdentifier, MaxRecords = MaxRecords, Marker = Marker)
  output <- .neptune$describe_global_clusters_output()
  config <- get_config()
  svc <- .neptune$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.neptune$operations$describe_global_clusters <- neptune_describe_global_clusters

#' Returns a list of orderable DB instance options for the specified engine
#'
#' @description
#' Returns a list of orderable DB instance options for the specified engine.
#'
#' See [https://www.paws-r-sdk.com/docs/neptune_describe_orderable_db_instance_options/](https://www.paws-r-sdk.com/docs/neptune_describe_orderable_db_instance_options/) for full documentation.
#'
#' @param Engine &#91;required&#93; The name of the engine to retrieve DB instance options for.
#' @param EngineVersion The engine version filter value. Specify this parameter to show only the
#' available offerings matching the specified engine version.
#' @param DBInstanceClass The DB instance class filter value. Specify this parameter to show only
#' the available offerings matching the specified DB instance class.
#' @param LicenseModel The license model filter value. Specify this parameter to show only the
#' available offerings matching the specified license model.
#' @param Vpc The VPC filter value. Specify this parameter to show only the available
#' VPC or non-VPC offerings.
#' @param Filters This parameter is not currently supported.
#' @param MaxRecords The maximum number of records to include in the response. If more
#' records exist than the specified `MaxRecords` value, a pagination token
#' called a marker is included in the response so that the remaining
#' results can be retrieved.
#' 
#' Default: 100
#' 
#' Constraints: Minimum 20, maximum 100.
#' @param Marker An optional pagination token provided by a previous
#' DescribeOrderableDBInstanceOptions request. If this parameter is
#' specified, the response includes only records beyond the marker, up to
#' the value specified by `MaxRecords` .
#'
#' @keywords internal
#'
#' @rdname neptune_describe_orderable_db_instance_options
neptune_describe_orderable_db_instance_options <- function(Engine, EngineVersion = NULL, DBInstanceClass = NULL, LicenseModel = NULL, Vpc = NULL, Filters = NULL, MaxRecords = NULL, Marker = NULL) {
  op <- new_operation(
    name = "DescribeOrderableDBInstanceOptions",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "Marker", limit_key = "MaxRecords", output_token = "Marker", result_key = "OrderableDBInstanceOptions"),
    stream_api = FALSE
  )
  input <- .neptune$describe_orderable_db_instance_options_input(Engine = Engine, EngineVersion = EngineVersion, DBInstanceClass = DBInstanceClass, LicenseModel = LicenseModel, Vpc = Vpc, Filters = Filters, MaxRecords = MaxRecords, Marker = Marker)
  output <- .neptune$describe_orderable_db_instance_options_output()
  config <- get_config()
  svc <- .neptune$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.neptune$operations$describe_orderable_db_instance_options <- neptune_describe_orderable_db_instance_options

#' Returns a list of resources (for example, DB instances) that have at
#' least one pending maintenance action
#'
#' @description
#' Returns a list of resources (for example, DB instances) that have at least one pending maintenance action.
#'
#' See [https://www.paws-r-sdk.com/docs/neptune_describe_pending_maintenance_actions/](https://www.paws-r-sdk.com/docs/neptune_describe_pending_maintenance_actions/) for full documentation.
#'
#' @param ResourceIdentifier The ARN of a resource to return pending maintenance actions for.
#' @param Filters A filter that specifies one or more resources to return pending
#' maintenance actions for.
#' 
#' Supported filters:
#' 
#' -   `db-cluster-id` - Accepts DB cluster identifiers and DB cluster
#'     Amazon Resource Names (ARNs). The results list will only include
#'     pending maintenance actions for the DB clusters identified by these
#'     ARNs.
#' 
#' -   `db-instance-id` - Accepts DB instance identifiers and DB instance
#'     ARNs. The results list will only include pending maintenance actions
#'     for the DB instances identified by these ARNs.
#' @param Marker An optional pagination token provided by a previous
#' [`describe_pending_maintenance_actions`][neptune_describe_pending_maintenance_actions]
#' request. If this parameter is specified, the response includes only
#' records beyond the marker, up to a number of records specified by
#' `MaxRecords`.
#' @param MaxRecords The maximum number of records to include in the response. If more
#' records exist than the specified `MaxRecords` value, a pagination token
#' called a marker is included in the response so that the remaining
#' results can be retrieved.
#' 
#' Default: 100
#' 
#' Constraints: Minimum 20, maximum 100.
#'
#' @keywords internal
#'
#' @rdname neptune_describe_pending_maintenance_actions
neptune_describe_pending_maintenance_actions <- function(ResourceIdentifier = NULL, Filters = NULL, Marker = NULL, MaxRecords = NULL) {
  op <- new_operation(
    name = "DescribePendingMaintenanceActions",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "Marker", limit_key = "MaxRecords", output_token = "Marker", result_key = "PendingMaintenanceActions"),
    stream_api = FALSE
  )
  input <- .neptune$describe_pending_maintenance_actions_input(ResourceIdentifier = ResourceIdentifier, Filters = Filters, Marker = Marker, MaxRecords = MaxRecords)
  output <- .neptune$describe_pending_maintenance_actions_output()
  config <- get_config()
  svc <- .neptune$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.neptune$operations$describe_pending_maintenance_actions <- neptune_describe_pending_maintenance_actions

#' You can call DescribeValidDBInstanceModifications to learn what
#' modifications you can make to your DB instance
#'
#' @description
#' You can call [`describe_valid_db_instance_modifications`][neptune_describe_valid_db_instance_modifications] to learn what modifications you can make to your DB instance. You can use this information when you call [`modify_db_instance`][neptune_modify_db_instance].
#'
#' See [https://www.paws-r-sdk.com/docs/neptune_describe_valid_db_instance_modifications/](https://www.paws-r-sdk.com/docs/neptune_describe_valid_db_instance_modifications/) for full documentation.
#'
#' @param DBInstanceIdentifier &#91;required&#93; The customer identifier or the ARN of your DB instance.
#'
#' @keywords internal
#'
#' @rdname neptune_describe_valid_db_instance_modifications
neptune_describe_valid_db_instance_modifications <- function(DBInstanceIdentifier) {
  op <- new_operation(
    name = "DescribeValidDBInstanceModifications",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .neptune$describe_valid_db_instance_modifications_input(DBInstanceIdentifier = DBInstanceIdentifier)
  output <- .neptune$describe_valid_db_instance_modifications_output()
  config <- get_config()
  svc <- .neptune$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.neptune$operations$describe_valid_db_instance_modifications <- neptune_describe_valid_db_instance_modifications

#' Forces a failover for a DB cluster
#'
#' @description
#' Forces a failover for a DB cluster.
#'
#' See [https://www.paws-r-sdk.com/docs/neptune_failover_db_cluster/](https://www.paws-r-sdk.com/docs/neptune_failover_db_cluster/) for full documentation.
#'
#' @param DBClusterIdentifier A DB cluster identifier to force a failover for. This parameter is not
#' case-sensitive.
#' 
#' Constraints:
#' 
#' -   Must match the identifier of an existing DBCluster.
#' @param TargetDBInstanceIdentifier The name of the instance to promote to the primary instance.
#' 
#' You must specify the instance identifier for an Read Replica in the DB
#' cluster. For example, `mydbcluster-replica1`.
#'
#' @keywords internal
#'
#' @rdname neptune_failover_db_cluster
neptune_failover_db_cluster <- function(DBClusterIdentifier = NULL, TargetDBInstanceIdentifier = NULL) {
  op <- new_operation(
    name = "FailoverDBCluster",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .neptune$failover_db_cluster_input(DBClusterIdentifier = DBClusterIdentifier, TargetDBInstanceIdentifier = TargetDBInstanceIdentifier)
  output <- .neptune$failover_db_cluster_output()
  config <- get_config()
  svc <- .neptune$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.neptune$operations$failover_db_cluster <- neptune_failover_db_cluster

#' Initiates the failover process for a Neptune global database
#'
#' @description
#' Initiates the failover process for a Neptune global database.
#'
#' See [https://www.paws-r-sdk.com/docs/neptune_failover_global_cluster/](https://www.paws-r-sdk.com/docs/neptune_failover_global_cluster/) for full documentation.
#'
#' @param GlobalClusterIdentifier &#91;required&#93; Identifier of the Neptune global database that should be failed over.
#' The identifier is the unique key assigned by the user when the Neptune
#' global database was created. In other words, it's the name of the global
#' database that you want to fail over.
#' 
#' Constraints: Must match the identifier of an existing Neptune global
#' database.
#' @param TargetDbClusterIdentifier &#91;required&#93; The Amazon Resource Name (ARN) of the secondary Neptune DB cluster that
#' you want to promote to primary for the global database.
#'
#' @keywords internal
#'
#' @rdname neptune_failover_global_cluster
neptune_failover_global_cluster <- function(GlobalClusterIdentifier, TargetDbClusterIdentifier) {
  op <- new_operation(
    name = "FailoverGlobalCluster",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .neptune$failover_global_cluster_input(GlobalClusterIdentifier = GlobalClusterIdentifier, TargetDbClusterIdentifier = TargetDbClusterIdentifier)
  output <- .neptune$failover_global_cluster_output()
  config <- get_config()
  svc <- .neptune$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.neptune$operations$failover_global_cluster <- neptune_failover_global_cluster

#' Lists all tags on an Amazon Neptune resource
#'
#' @description
#' Lists all tags on an Amazon Neptune resource.
#'
#' See [https://www.paws-r-sdk.com/docs/neptune_list_tags_for_resource/](https://www.paws-r-sdk.com/docs/neptune_list_tags_for_resource/) for full documentation.
#'
#' @param ResourceName &#91;required&#93; The Amazon Neptune resource with tags to be listed. This value is an
#' Amazon Resource Name (ARN). For information about creating an ARN, see
#' [Constructing an Amazon Resource Name
#' (ARN)](https://docs.aws.amazon.com/neptune/latest/userguide/#tagging.ARN.Constructing).
#' @param Filters This parameter is not currently supported.
#'
#' @keywords internal
#'
#' @rdname neptune_list_tags_for_resource
neptune_list_tags_for_resource <- function(ResourceName, Filters = NULL) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .neptune$list_tags_for_resource_input(ResourceName = ResourceName, Filters = Filters)
  output <- .neptune$list_tags_for_resource_output()
  config <- get_config()
  svc <- .neptune$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.neptune$operations$list_tags_for_resource <- neptune_list_tags_for_resource

#' Modify a setting for a DB cluster
#'
#' @description
#' Modify a setting for a DB cluster. You can change one or more database configuration parameters by specifying these parameters and the new values in the request.
#'
#' See [https://www.paws-r-sdk.com/docs/neptune_modify_db_cluster/](https://www.paws-r-sdk.com/docs/neptune_modify_db_cluster/) for full documentation.
#'
#' @param DBClusterIdentifier &#91;required&#93; The DB cluster identifier for the cluster being modified. This parameter
#' is not case-sensitive.
#' 
#' Constraints:
#' 
#' -   Must match the identifier of an existing DBCluster.
#' @param NewDBClusterIdentifier The new DB cluster identifier for the DB cluster when renaming a DB
#' cluster. This value is stored as a lowercase string.
#' 
#' Constraints:
#' 
#' -   Must contain from 1 to 63 letters, numbers, or hyphens
#' 
#' -   The first character must be a letter
#' 
#' -   Cannot end with a hyphen or contain two consecutive hyphens
#' 
#' Example: `my-cluster2`
#' @param ApplyImmediately A value that specifies whether the modifications in this request and any
#' pending modifications are asynchronously applied as soon as possible,
#' regardless of the `PreferredMaintenanceWindow` setting for the DB
#' cluster. If this parameter is set to `false`, changes to the DB cluster
#' are applied during the next maintenance window.
#' 
#' The `ApplyImmediately` parameter only affects `NewDBClusterIdentifier`
#' values. If you set the `ApplyImmediately` parameter value to false, then
#' changes to `NewDBClusterIdentifier` values are applied during the next
#' maintenance window. All other changes are applied immediately,
#' regardless of the value of the `ApplyImmediately` parameter.
#' 
#' Default: `false`
#' @param BackupRetentionPeriod The number of days for which automated backups are retained. You must
#' specify a minimum value of 1.
#' 
#' Default: 1
#' 
#' Constraints:
#' 
#' -   Must be a value from 1 to 35
#' @param DBClusterParameterGroupName The name of the DB cluster parameter group to use for the DB cluster.
#' @param VpcSecurityGroupIds A list of VPC security groups that the DB cluster will belong to.
#' @param Port The port number on which the DB cluster accepts connections.
#' 
#' Constraints: Value must be `1150-65535`
#' 
#' Default: The same port as the original DB cluster.
#' @param MasterUserPassword Not supported by Neptune.
#' @param OptionGroupName *Not supported by Neptune.*
#' @param PreferredBackupWindow The daily time range during which automated backups are created if
#' automated backups are enabled, using the `BackupRetentionPeriod`
#' parameter.
#' 
#' The default is a 30-minute window selected at random from an 8-hour
#' block of time for each Amazon Region.
#' 
#' Constraints:
#' 
#' -   Must be in the format `hh24:mi-hh24:mi`.
#' 
#' -   Must be in Universal Coordinated Time (UTC).
#' 
#' -   Must not conflict with the preferred maintenance window.
#' 
#' -   Must be at least 30 minutes.
#' @param PreferredMaintenanceWindow The weekly time range during which system maintenance can occur, in
#' Universal Coordinated Time (UTC).
#' 
#' Format: `ddd:hh24:mi-ddd:hh24:mi`
#' 
#' The default is a 30-minute window selected at random from an 8-hour
#' block of time for each Amazon Region, occurring on a random day of the
#' week.
#' 
#' Valid Days: Mon, Tue, Wed, Thu, Fri, Sat, Sun.
#' 
#' Constraints: Minimum 30-minute window.
#' @param EnableIAMDatabaseAuthentication True to enable mapping of Amazon Identity and Access Management (IAM)
#' accounts to database accounts, and otherwise false.
#' 
#' Default: `false`
#' @param CloudwatchLogsExportConfiguration The configuration setting for the log types to be enabled for export to
#' CloudWatch Logs for a specific DB cluster. See [Using the CLI to publish
#' Neptune audit logs to CloudWatch
#' Logs](https://docs.aws.amazon.com/neptune/latest/userguide/cloudwatch-logs.html#cloudwatch-logs-cli).
#' @param EngineVersion The version number of the database engine to which you want to upgrade.
#' Changing this parameter results in an outage. The change is applied
#' during the next maintenance window unless the `ApplyImmediately`
#' parameter is set to true.
#' 
#' For a list of valid engine versions, see [Engine Releases for Amazon
#' Neptune](https://docs.aws.amazon.com/neptune/latest/userguide/engine-releases.html),
#' or call
#' [`describe_db_engine_versions`][neptune_describe_db_engine_versions].
#' @param AllowMajorVersionUpgrade A value that indicates whether upgrades between different major versions
#' are allowed.
#' 
#' Constraints: You must set the allow-major-version-upgrade flag when
#' providing an `EngineVersion` parameter that uses a different major
#' version than the DB cluster's current version.
#' @param DBInstanceParameterGroupName The name of the DB parameter group to apply to all instances of the DB
#' cluster.
#' 
#' When you apply a parameter group using `DBInstanceParameterGroupName`,
#' parameter changes aren't applied during the next maintenance window but
#' instead are applied immediately.
#' 
#' Default: The existing name setting
#' 
#' Constraints:
#' 
#' -   The DB parameter group must be in the same DB parameter group family
#'     as the target DB cluster version.
#' 
#' -   The `DBInstanceParameterGroupName` parameter is only valid in
#'     combination with the `AllowMajorVersionUpgrade` parameter.
#' @param DeletionProtection A value that indicates whether the DB cluster has deletion protection
#' enabled. The database can't be deleted when deletion protection is
#' enabled. By default, deletion protection is disabled.
#' @param CopyTagsToSnapshot *If set to true, tags are copied to any snapshot of the DB cluster that
#' is created.*
#' @param ServerlessV2ScalingConfiguration Contains the scaling configuration of a Neptune Serverless DB cluster.
#' 
#' For more information, see [Using Amazon Neptune
#' Serverless](https://docs.aws.amazon.com/neptune/latest/userguide/neptune-serverless-using.html)
#' in the *Amazon Neptune User Guide*.
#' @param StorageType The storage type to associate with the DB cluster.
#' 
#' Valid Values:
#' 
#' -   `standard | iopt1`
#' 
#' Default:
#' 
#' -   `standard`
#'
#' @keywords internal
#'
#' @rdname neptune_modify_db_cluster
neptune_modify_db_cluster <- function(DBClusterIdentifier, NewDBClusterIdentifier = NULL, ApplyImmediately = NULL, BackupRetentionPeriod = NULL, DBClusterParameterGroupName = NULL, VpcSecurityGroupIds = NULL, Port = NULL, MasterUserPassword = NULL, OptionGroupName = NULL, PreferredBackupWindow = NULL, PreferredMaintenanceWindow = NULL, EnableIAMDatabaseAuthentication = NULL, CloudwatchLogsExportConfiguration = NULL, EngineVersion = NULL, AllowMajorVersionUpgrade = NULL, DBInstanceParameterGroupName = NULL, DeletionProtection = NULL, CopyTagsToSnapshot = NULL, ServerlessV2ScalingConfiguration = NULL, StorageType = NULL) {
  op <- new_operation(
    name = "ModifyDBCluster",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .neptune$modify_db_cluster_input(DBClusterIdentifier = DBClusterIdentifier, NewDBClusterIdentifier = NewDBClusterIdentifier, ApplyImmediately = ApplyImmediately, BackupRetentionPeriod = BackupRetentionPeriod, DBClusterParameterGroupName = DBClusterParameterGroupName, VpcSecurityGroupIds = VpcSecurityGroupIds, Port = Port, MasterUserPassword = MasterUserPassword, OptionGroupName = OptionGroupName, PreferredBackupWindow = PreferredBackupWindow, PreferredMaintenanceWindow = PreferredMaintenanceWindow, EnableIAMDatabaseAuthentication = EnableIAMDatabaseAuthentication, CloudwatchLogsExportConfiguration = CloudwatchLogsExportConfiguration, EngineVersion = EngineVersion, AllowMajorVersionUpgrade = AllowMajorVersionUpgrade, DBInstanceParameterGroupName = DBInstanceParameterGroupName, DeletionProtection = DeletionProtection, CopyTagsToSnapshot = CopyTagsToSnapshot, ServerlessV2ScalingConfiguration = ServerlessV2ScalingConfiguration, StorageType = StorageType)
  output <- .neptune$modify_db_cluster_output()
  config <- get_config()
  svc <- .neptune$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.neptune$operations$modify_db_cluster <- neptune_modify_db_cluster

#' Modifies the properties of an endpoint in an Amazon Neptune DB cluster
#'
#' @description
#' Modifies the properties of an endpoint in an Amazon Neptune DB cluster.
#'
#' See [https://www.paws-r-sdk.com/docs/neptune_modify_db_cluster_endpoint/](https://www.paws-r-sdk.com/docs/neptune_modify_db_cluster_endpoint/) for full documentation.
#'
#' @param DBClusterEndpointIdentifier &#91;required&#93; The identifier of the endpoint to modify. This parameter is stored as a
#' lowercase string.
#' @param EndpointType The type of the endpoint. One of: `READER`, `WRITER`, `ANY`.
#' @param StaticMembers List of DB instance identifiers that are part of the custom endpoint
#' group.
#' @param ExcludedMembers List of DB instance identifiers that aren't part of the custom endpoint
#' group. All other eligible instances are reachable through the custom
#' endpoint. Only relevant if the list of static members is empty.
#'
#' @keywords internal
#'
#' @rdname neptune_modify_db_cluster_endpoint
neptune_modify_db_cluster_endpoint <- function(DBClusterEndpointIdentifier, EndpointType = NULL, StaticMembers = NULL, ExcludedMembers = NULL) {
  op <- new_operation(
    name = "ModifyDBClusterEndpoint",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .neptune$modify_db_cluster_endpoint_input(DBClusterEndpointIdentifier = DBClusterEndpointIdentifier, EndpointType = EndpointType, StaticMembers = StaticMembers, ExcludedMembers = ExcludedMembers)
  output <- .neptune$modify_db_cluster_endpoint_output()
  config <- get_config()
  svc <- .neptune$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.neptune$operations$modify_db_cluster_endpoint <- neptune_modify_db_cluster_endpoint

#' Modifies the parameters of a DB cluster parameter group
#'
#' @description
#' Modifies the parameters of a DB cluster parameter group. To modify more than one parameter, submit a list of the following: `ParameterName`, `ParameterValue`, and `ApplyMethod`. A maximum of 20 parameters can be modified in a single request.
#'
#' See [https://www.paws-r-sdk.com/docs/neptune_modify_db_cluster_parameter_group/](https://www.paws-r-sdk.com/docs/neptune_modify_db_cluster_parameter_group/) for full documentation.
#'
#' @param DBClusterParameterGroupName &#91;required&#93; The name of the DB cluster parameter group to modify.
#' @param Parameters &#91;required&#93; A list of parameters in the DB cluster parameter group to modify.
#'
#' @keywords internal
#'
#' @rdname neptune_modify_db_cluster_parameter_group
neptune_modify_db_cluster_parameter_group <- function(DBClusterParameterGroupName, Parameters) {
  op <- new_operation(
    name = "ModifyDBClusterParameterGroup",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .neptune$modify_db_cluster_parameter_group_input(DBClusterParameterGroupName = DBClusterParameterGroupName, Parameters = Parameters)
  output <- .neptune$modify_db_cluster_parameter_group_output()
  config <- get_config()
  svc <- .neptune$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.neptune$operations$modify_db_cluster_parameter_group <- neptune_modify_db_cluster_parameter_group

#' Adds an attribute and values to, or removes an attribute and values
#' from, a manual DB cluster snapshot
#'
#' @description
#' Adds an attribute and values to, or removes an attribute and values from, a manual DB cluster snapshot.
#'
#' See [https://www.paws-r-sdk.com/docs/neptune_modify_db_cluster_snapshot_attribute/](https://www.paws-r-sdk.com/docs/neptune_modify_db_cluster_snapshot_attribute/) for full documentation.
#'
#' @param DBClusterSnapshotIdentifier &#91;required&#93; The identifier for the DB cluster snapshot to modify the attributes for.
#' @param AttributeName &#91;required&#93; The name of the DB cluster snapshot attribute to modify.
#' 
#' To manage authorization for other Amazon accounts to copy or restore a
#' manual DB cluster snapshot, set this value to `restore`.
#' @param ValuesToAdd A list of DB cluster snapshot attributes to add to the attribute
#' specified by `AttributeName`.
#' 
#' To authorize other Amazon accounts to copy or restore a manual DB
#' cluster snapshot, set this list to include one or more Amazon account
#' IDs, or `all` to make the manual DB cluster snapshot restorable by any
#' Amazon account. Do not add the `all` value for any manual DB cluster
#' snapshots that contain private information that you don't want available
#' to all Amazon accounts.
#' @param ValuesToRemove A list of DB cluster snapshot attributes to remove from the attribute
#' specified by `AttributeName`.
#' 
#' To remove authorization for other Amazon accounts to copy or restore a
#' manual DB cluster snapshot, set this list to include one or more Amazon
#' account identifiers, or `all` to remove authorization for any Amazon
#' account to copy or restore the DB cluster snapshot. If you specify
#' `all`, an Amazon account whose account ID is explicitly added to the
#' `restore` attribute can still copy or restore a manual DB cluster
#' snapshot.
#'
#' @keywords internal
#'
#' @rdname neptune_modify_db_cluster_snapshot_attribute
neptune_modify_db_cluster_snapshot_attribute <- function(DBClusterSnapshotIdentifier, AttributeName, ValuesToAdd = NULL, ValuesToRemove = NULL) {
  op <- new_operation(
    name = "ModifyDBClusterSnapshotAttribute",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .neptune$modify_db_cluster_snapshot_attribute_input(DBClusterSnapshotIdentifier = DBClusterSnapshotIdentifier, AttributeName = AttributeName, ValuesToAdd = ValuesToAdd, ValuesToRemove = ValuesToRemove)
  output <- .neptune$modify_db_cluster_snapshot_attribute_output()
  config <- get_config()
  svc <- .neptune$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.neptune$operations$modify_db_cluster_snapshot_attribute <- neptune_modify_db_cluster_snapshot_attribute

#' Modifies settings for a DB instance
#'
#' @description
#' Modifies settings for a DB instance. You can change one or more database configuration parameters by specifying these parameters and the new values in the request. To learn what modifications you can make to your DB instance, call [`describe_valid_db_instance_modifications`][neptune_describe_valid_db_instance_modifications] before you call [`modify_db_instance`][neptune_modify_db_instance].
#'
#' See [https://www.paws-r-sdk.com/docs/neptune_modify_db_instance/](https://www.paws-r-sdk.com/docs/neptune_modify_db_instance/) for full documentation.
#'
#' @param DBInstanceIdentifier &#91;required&#93; The DB instance identifier. This value is stored as a lowercase string.
#' 
#' Constraints:
#' 
#' -   Must match the identifier of an existing DBInstance.
#' @param AllocatedStorage Not supported by Neptune.
#' @param DBInstanceClass The new compute and memory capacity of the DB instance, for example,
#' `db.m4.large`. Not all DB instance classes are available in all Amazon
#' Regions.
#' 
#' If you modify the DB instance class, an outage occurs during the change.
#' The change is applied during the next maintenance window, unless
#' `ApplyImmediately` is specified as `true` for this request.
#' 
#' Default: Uses existing setting
#' @param DBSubnetGroupName The new DB subnet group for the DB instance. You can use this parameter
#' to move your DB instance to a different VPC.
#' 
#' Changing the subnet group causes an outage during the change. The change
#' is applied during the next maintenance window, unless you specify `true`
#' for the `ApplyImmediately` parameter.
#' 
#' Constraints: If supplied, must match the name of an existing
#' DBSubnetGroup.
#' 
#' Example: `mySubnetGroup`
#' @param DBSecurityGroups A list of DB security groups to authorize on this DB instance. Changing
#' this setting doesn't result in an outage and the change is
#' asynchronously applied as soon as possible.
#' 
#' Constraints:
#' 
#' -   If supplied, must match existing DBSecurityGroups.
#' @param VpcSecurityGroupIds A list of EC2 VPC security groups to authorize on this DB instance. This
#' change is asynchronously applied as soon as possible.
#' 
#' Not applicable. The associated list of EC2 VPC security groups is
#' managed by the DB cluster. For more information, see
#' [`modify_db_cluster`][neptune_modify_db_cluster].
#' 
#' Constraints:
#' 
#' -   If supplied, must match existing VpcSecurityGroupIds.
#' @param ApplyImmediately Specifies whether the modifications in this request and any pending
#' modifications are asynchronously applied as soon as possible, regardless
#' of the `PreferredMaintenanceWindow` setting for the DB instance.
#' 
#' If this parameter is set to `false`, changes to the DB instance are
#' applied during the next maintenance window. Some parameter changes can
#' cause an outage and are applied on the next call to
#' [`reboot_db_instance`][neptune_reboot_db_instance], or the next failure
#' reboot.
#' 
#' Default: `false`
#' @param MasterUserPassword Not supported by Neptune.
#' @param DBParameterGroupName The name of the DB parameter group to apply to the DB instance. Changing
#' this setting doesn't result in an outage. The parameter group name
#' itself is changed immediately, but the actual parameter changes are not
#' applied until you reboot the instance without failover. The db instance
#' will NOT be rebooted automatically and the parameter changes will NOT be
#' applied during the next maintenance window.
#' 
#' Default: Uses existing setting
#' 
#' Constraints: The DB parameter group must be in the same DB parameter
#' group family as this DB instance.
#' @param BackupRetentionPeriod Not applicable. The retention period for automated backups is managed by
#' the DB cluster. For more information, see
#' [`modify_db_cluster`][neptune_modify_db_cluster].
#' 
#' Default: Uses existing setting
#' @param PreferredBackupWindow The daily time range during which automated backups are created if
#' automated backups are enabled.
#' 
#' Not applicable. The daily time range for creating automated backups is
#' managed by the DB cluster. For more information, see
#' [`modify_db_cluster`][neptune_modify_db_cluster].
#' 
#' Constraints:
#' 
#' -   Must be in the format hh24:mi-hh24:mi
#' 
#' -   Must be in Universal Time Coordinated (UTC)
#' 
#' -   Must not conflict with the preferred maintenance window
#' 
#' -   Must be at least 30 minutes
#' @param PreferredMaintenanceWindow The weekly time range (in UTC) during which system maintenance can
#' occur, which might result in an outage. Changing this parameter doesn't
#' result in an outage, except in the following situation, and the change
#' is asynchronously applied as soon as possible. If there are pending
#' actions that cause a reboot, and the maintenance window is changed to
#' include the current time, then changing this parameter will cause a
#' reboot of the DB instance. If moving this window to the current time,
#' there must be at least 30 minutes between the current time and end of
#' the window to ensure pending changes are applied.
#' 
#' Default: Uses existing setting
#' 
#' Format: ddd:hh24:mi-ddd:hh24:mi
#' 
#' Valid Days: Mon | Tue | Wed | Thu | Fri | Sat | Sun
#' 
#' Constraints: Must be at least 30 minutes
#' @param MultiAZ Specifies if the DB instance is a Multi-AZ deployment. Changing this
#' parameter doesn't result in an outage and the change is applied during
#' the next maintenance window unless the `ApplyImmediately` parameter is
#' set to `true` for this request.
#' @param EngineVersion The version number of the database engine to upgrade to. Currently,
#' setting this parameter has no effect. To upgrade your database engine to
#' the most recent release, use the
#' [`apply_pending_maintenance_action`][neptune_apply_pending_maintenance_action]
#' API.
#' @param AllowMajorVersionUpgrade Indicates that major version upgrades are allowed. Changing this
#' parameter doesn't result in an outage and the change is asynchronously
#' applied as soon as possible.
#' @param AutoMinorVersionUpgrade Indicates that minor version upgrades are applied automatically to the
#' DB instance during the maintenance window. Changing this parameter
#' doesn't result in an outage except in the following case and the change
#' is asynchronously applied as soon as possible. An outage will result if
#' this parameter is set to `true` during the maintenance window, and a
#' newer minor version is available, and Neptune has enabled auto patching
#' for that engine version.
#' @param LicenseModel Not supported by Neptune.
#' @param Iops The new Provisioned IOPS (I/O operations per second) value for the
#' instance.
#' 
#' Changing this setting doesn't result in an outage and the change is
#' applied during the next maintenance window unless the `ApplyImmediately`
#' parameter is set to `true` for this request.
#' 
#' Default: Uses existing setting
#' @param OptionGroupName *(Not supported by Neptune)*
#' @param NewDBInstanceIdentifier The new DB instance identifier for the DB instance when renaming a DB
#' instance. When you change the DB instance identifier, an instance reboot
#' will occur immediately if you set `Apply Immediately` to true, or will
#' occur during the next maintenance window if `Apply Immediately` to
#' false. This value is stored as a lowercase string.
#' 
#' Constraints:
#' 
#' -   Must contain from 1 to 63 letters, numbers, or hyphens.
#' 
#' -   The first character must be a letter.
#' 
#' -   Cannot end with a hyphen or contain two consecutive hyphens.
#' 
#' Example: `mydbinstance`
#' @param StorageType Not supported.
#' @param TdeCredentialArn The ARN from the key store with which to associate the instance for TDE
#' encryption.
#' @param TdeCredentialPassword The password for the given ARN from the key store in order to access the
#' device.
#' @param CACertificateIdentifier Indicates the certificate that needs to be associated with the instance.
#' @param Domain Not supported.
#' @param CopyTagsToSnapshot True to copy all tags from the DB instance to snapshots of the DB
#' instance, and otherwise false. The default is false.
#' @param MonitoringInterval The interval, in seconds, between points when Enhanced Monitoring
#' metrics are collected for the DB instance. To disable collecting
#' Enhanced Monitoring metrics, specify 0. The default is 0.
#' 
#' If `MonitoringRoleArn` is specified, then you must also set
#' `MonitoringInterval` to a value other than 0.
#' 
#' Valid Values: `0, 1, 5, 10, 15, 30, 60`
#' @param DBPortNumber The port number on which the database accepts connections.
#' 
#' The value of the `DBPortNumber` parameter must not match any of the port
#' values specified for options in the option group for the DB instance.
#' 
#' Your database will restart when you change the `DBPortNumber` value
#' regardless of the value of the `ApplyImmediately` parameter.
#' 
#' Default: `8182`
#' @param PubliclyAccessible This flag should no longer be used.
#' @param MonitoringRoleArn The ARN for the IAM role that permits Neptune to send enhanced
#' monitoring metrics to Amazon CloudWatch Logs. For example,
#' `arn:aws:iam:123456789012:role/emaccess`.
#' 
#' If `MonitoringInterval` is set to a value other than 0, then you must
#' supply a `MonitoringRoleArn` value.
#' @param DomainIAMRoleName Not supported
#' @param PromotionTier A value that specifies the order in which a Read Replica is promoted to
#' the primary instance after a failure of the existing primary instance.
#' 
#' Default: 1
#' 
#' Valid Values: 0 - 15
#' @param EnableIAMDatabaseAuthentication True to enable mapping of Amazon Identity and Access Management (IAM)
#' accounts to database accounts, and otherwise false.
#' 
#' You can enable IAM database authentication for the following database
#' engines
#' 
#' Not applicable. Mapping Amazon IAM accounts to database accounts is
#' managed by the DB cluster. For more information, see
#' [`modify_db_cluster`][neptune_modify_db_cluster].
#' 
#' Default: `false`
#' @param EnablePerformanceInsights *(Not supported by Neptune)*
#' @param PerformanceInsightsKMSKeyId *(Not supported by Neptune)*
#' @param CloudwatchLogsExportConfiguration The configuration setting for the log types to be enabled for export to
#' CloudWatch Logs for a specific DB instance or DB cluster.
#' @param DeletionProtection A value that indicates whether the DB instance has deletion protection
#' enabled. The database can't be deleted when deletion protection is
#' enabled. By default, deletion protection is disabled. See [Deleting a DB
#' Instance](https://docs.aws.amazon.com/neptune/latest/userguide/manage-console-instances-delete.html).
#'
#' @keywords internal
#'
#' @rdname neptune_modify_db_instance
neptune_modify_db_instance <- function(DBInstanceIdentifier, AllocatedStorage = NULL, DBInstanceClass = NULL, DBSubnetGroupName = NULL, DBSecurityGroups = NULL, VpcSecurityGroupIds = NULL, ApplyImmediately = NULL, MasterUserPassword = NULL, DBParameterGroupName = NULL, BackupRetentionPeriod = NULL, PreferredBackupWindow = NULL, PreferredMaintenanceWindow = NULL, MultiAZ = NULL, EngineVersion = NULL, AllowMajorVersionUpgrade = NULL, AutoMinorVersionUpgrade = NULL, LicenseModel = NULL, Iops = NULL, OptionGroupName = NULL, NewDBInstanceIdentifier = NULL, StorageType = NULL, TdeCredentialArn = NULL, TdeCredentialPassword = NULL, CACertificateIdentifier = NULL, Domain = NULL, CopyTagsToSnapshot = NULL, MonitoringInterval = NULL, DBPortNumber = NULL, PubliclyAccessible = NULL, MonitoringRoleArn = NULL, DomainIAMRoleName = NULL, PromotionTier = NULL, EnableIAMDatabaseAuthentication = NULL, EnablePerformanceInsights = NULL, PerformanceInsightsKMSKeyId = NULL, CloudwatchLogsExportConfiguration = NULL, DeletionProtection = NULL) {
  op <- new_operation(
    name = "ModifyDBInstance",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .neptune$modify_db_instance_input(DBInstanceIdentifier = DBInstanceIdentifier, AllocatedStorage = AllocatedStorage, DBInstanceClass = DBInstanceClass, DBSubnetGroupName = DBSubnetGroupName, DBSecurityGroups = DBSecurityGroups, VpcSecurityGroupIds = VpcSecurityGroupIds, ApplyImmediately = ApplyImmediately, MasterUserPassword = MasterUserPassword, DBParameterGroupName = DBParameterGroupName, BackupRetentionPeriod = BackupRetentionPeriod, PreferredBackupWindow = PreferredBackupWindow, PreferredMaintenanceWindow = PreferredMaintenanceWindow, MultiAZ = MultiAZ, EngineVersion = EngineVersion, AllowMajorVersionUpgrade = AllowMajorVersionUpgrade, AutoMinorVersionUpgrade = AutoMinorVersionUpgrade, LicenseModel = LicenseModel, Iops = Iops, OptionGroupName = OptionGroupName, NewDBInstanceIdentifier = NewDBInstanceIdentifier, StorageType = StorageType, TdeCredentialArn = TdeCredentialArn, TdeCredentialPassword = TdeCredentialPassword, CACertificateIdentifier = CACertificateIdentifier, Domain = Domain, CopyTagsToSnapshot = CopyTagsToSnapshot, MonitoringInterval = MonitoringInterval, DBPortNumber = DBPortNumber, PubliclyAccessible = PubliclyAccessible, MonitoringRoleArn = MonitoringRoleArn, DomainIAMRoleName = DomainIAMRoleName, PromotionTier = PromotionTier, EnableIAMDatabaseAuthentication = EnableIAMDatabaseAuthentication, EnablePerformanceInsights = EnablePerformanceInsights, PerformanceInsightsKMSKeyId = PerformanceInsightsKMSKeyId, CloudwatchLogsExportConfiguration = CloudwatchLogsExportConfiguration, DeletionProtection = DeletionProtection)
  output <- .neptune$modify_db_instance_output()
  config <- get_config()
  svc <- .neptune$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.neptune$operations$modify_db_instance <- neptune_modify_db_instance

#' Modifies the parameters of a DB parameter group
#'
#' @description
#' Modifies the parameters of a DB parameter group. To modify more than one parameter, submit a list of the following: `ParameterName`, `ParameterValue`, and `ApplyMethod`. A maximum of 20 parameters can be modified in a single request.
#'
#' See [https://www.paws-r-sdk.com/docs/neptune_modify_db_parameter_group/](https://www.paws-r-sdk.com/docs/neptune_modify_db_parameter_group/) for full documentation.
#'
#' @param DBParameterGroupName &#91;required&#93; The name of the DB parameter group.
#' 
#' Constraints:
#' 
#' -   If supplied, must match the name of an existing DBParameterGroup.
#' @param Parameters &#91;required&#93; An array of parameter names, values, and the apply method for the
#' parameter update. At least one parameter name, value, and apply method
#' must be supplied; subsequent arguments are optional. A maximum of 20
#' parameters can be modified in a single request.
#' 
#' Valid Values (for the application method): `immediate | pending-reboot`
#' 
#' You can use the immediate value with dynamic parameters only. You can
#' use the pending-reboot value for both dynamic and static parameters, and
#' changes are applied when you reboot the DB instance without failover.
#'
#' @keywords internal
#'
#' @rdname neptune_modify_db_parameter_group
neptune_modify_db_parameter_group <- function(DBParameterGroupName, Parameters) {
  op <- new_operation(
    name = "ModifyDBParameterGroup",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .neptune$modify_db_parameter_group_input(DBParameterGroupName = DBParameterGroupName, Parameters = Parameters)
  output <- .neptune$modify_db_parameter_group_output()
  config <- get_config()
  svc <- .neptune$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.neptune$operations$modify_db_parameter_group <- neptune_modify_db_parameter_group

#' Modifies an existing DB subnet group
#'
#' @description
#' Modifies an existing DB subnet group. DB subnet groups must contain at least one subnet in at least two AZs in the Amazon Region.
#'
#' See [https://www.paws-r-sdk.com/docs/neptune_modify_db_subnet_group/](https://www.paws-r-sdk.com/docs/neptune_modify_db_subnet_group/) for full documentation.
#'
#' @param DBSubnetGroupName &#91;required&#93; The name for the DB subnet group. This value is stored as a lowercase
#' string. You can't modify the default subnet group.
#' 
#' Constraints: Must match the name of an existing DBSubnetGroup. Must not
#' be default.
#' 
#' Example: `mySubnetgroup`
#' @param DBSubnetGroupDescription The description for the DB subnet group.
#' @param SubnetIds &#91;required&#93; The EC2 subnet IDs for the DB subnet group.
#'
#' @keywords internal
#'
#' @rdname neptune_modify_db_subnet_group
neptune_modify_db_subnet_group <- function(DBSubnetGroupName, DBSubnetGroupDescription = NULL, SubnetIds) {
  op <- new_operation(
    name = "ModifyDBSubnetGroup",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .neptune$modify_db_subnet_group_input(DBSubnetGroupName = DBSubnetGroupName, DBSubnetGroupDescription = DBSubnetGroupDescription, SubnetIds = SubnetIds)
  output <- .neptune$modify_db_subnet_group_output()
  config <- get_config()
  svc <- .neptune$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.neptune$operations$modify_db_subnet_group <- neptune_modify_db_subnet_group

#' Modifies an existing event notification subscription
#'
#' @description
#' Modifies an existing event notification subscription. Note that you can't modify the source identifiers using this call; to change source identifiers for a subscription, use the [`add_source_identifier_to_subscription`][neptune_add_source_identifier_to_subscription] and [`remove_source_identifier_from_subscription`][neptune_remove_source_identifier_from_subscription] calls.
#'
#' See [https://www.paws-r-sdk.com/docs/neptune_modify_event_subscription/](https://www.paws-r-sdk.com/docs/neptune_modify_event_subscription/) for full documentation.
#'
#' @param SubscriptionName &#91;required&#93; The name of the event notification subscription.
#' @param SnsTopicArn The Amazon Resource Name (ARN) of the SNS topic created for event
#' notification. The ARN is created by Amazon SNS when you create a topic
#' and subscribe to it.
#' @param SourceType The type of source that is generating the events. For example, if you
#' want to be notified of events generated by a DB instance, you would set
#' this parameter to db-instance. if this value is not specified, all
#' events are returned.
#' 
#' Valid values: db-instance | db-parameter-group | db-security-group |
#' db-snapshot
#' @param EventCategories A list of event categories for a SourceType that you want to subscribe
#' to. You can see a list of the categories for a given SourceType by using
#' the **DescribeEventCategories** action.
#' @param Enabled A Boolean value; set to **true** to activate the subscription.
#'
#' @keywords internal
#'
#' @rdname neptune_modify_event_subscription
neptune_modify_event_subscription <- function(SubscriptionName, SnsTopicArn = NULL, SourceType = NULL, EventCategories = NULL, Enabled = NULL) {
  op <- new_operation(
    name = "ModifyEventSubscription",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .neptune$modify_event_subscription_input(SubscriptionName = SubscriptionName, SnsTopicArn = SnsTopicArn, SourceType = SourceType, EventCategories = EventCategories, Enabled = Enabled)
  output <- .neptune$modify_event_subscription_output()
  config <- get_config()
  svc <- .neptune$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.neptune$operations$modify_event_subscription <- neptune_modify_event_subscription

#' Modify a setting for an Amazon Neptune global cluster
#'
#' @description
#' Modify a setting for an Amazon Neptune global cluster. You can change one or more database configuration parameters by specifying these parameters and their new values in the request.
#'
#' See [https://www.paws-r-sdk.com/docs/neptune_modify_global_cluster/](https://www.paws-r-sdk.com/docs/neptune_modify_global_cluster/) for full documentation.
#'
#' @param GlobalClusterIdentifier &#91;required&#93; The DB cluster identifier for the global cluster being modified. This
#' parameter is not case-sensitive.
#' 
#' Constraints: Must match the identifier of an existing global database
#' cluster.
#' @param NewGlobalClusterIdentifier A new cluster identifier to assign to the global database. This value is
#' stored as a lowercase string.
#' 
#' Constraints:
#' 
#' -   Must contain from 1 to 63 letters, numbers, or hyphens.
#' 
#' -   The first character must be a letter.
#' 
#' -   Can't end with a hyphen or contain two consecutive hyphens
#' 
#' Example: `my-cluster2`
#' @param DeletionProtection Indicates whether the global database has deletion protection enabled.
#' The global database cannot be deleted when deletion protection is
#' enabled.
#' @param EngineVersion The version number of the database engine to which you want to upgrade.
#' Changing this parameter will result in an outage. The change is applied
#' during the next maintenance window unless `ApplyImmediately` is enabled.
#' 
#' To list all of the available Neptune engine versions, use the following
#' command:
#' @param AllowMajorVersionUpgrade A value that indicates whether major version upgrades are allowed.
#' 
#' Constraints: You must allow major version upgrades if you specify a
#' value for the `EngineVersion` parameter that is a different major
#' version than the DB cluster's current version.
#' 
#' If you upgrade the major version of a global database, the cluster and
#' DB instance parameter groups are set to the default parameter groups for
#' the new version, so you will need to apply any custom parameter groups
#' after completing the upgrade.
#'
#' @keywords internal
#'
#' @rdname neptune_modify_global_cluster
neptune_modify_global_cluster <- function(GlobalClusterIdentifier, NewGlobalClusterIdentifier = NULL, DeletionProtection = NULL, EngineVersion = NULL, AllowMajorVersionUpgrade = NULL) {
  op <- new_operation(
    name = "ModifyGlobalCluster",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .neptune$modify_global_cluster_input(GlobalClusterIdentifier = GlobalClusterIdentifier, NewGlobalClusterIdentifier = NewGlobalClusterIdentifier, DeletionProtection = DeletionProtection, EngineVersion = EngineVersion, AllowMajorVersionUpgrade = AllowMajorVersionUpgrade)
  output <- .neptune$modify_global_cluster_output()
  config <- get_config()
  svc <- .neptune$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.neptune$operations$modify_global_cluster <- neptune_modify_global_cluster

#' Not supported
#'
#' @description
#' Not supported.
#'
#' See [https://www.paws-r-sdk.com/docs/neptune_promote_read_replica_db_cluster/](https://www.paws-r-sdk.com/docs/neptune_promote_read_replica_db_cluster/) for full documentation.
#'
#' @param DBClusterIdentifier &#91;required&#93; Not supported.
#'
#' @keywords internal
#'
#' @rdname neptune_promote_read_replica_db_cluster
neptune_promote_read_replica_db_cluster <- function(DBClusterIdentifier) {
  op <- new_operation(
    name = "PromoteReadReplicaDBCluster",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .neptune$promote_read_replica_db_cluster_input(DBClusterIdentifier = DBClusterIdentifier)
  output <- .neptune$promote_read_replica_db_cluster_output()
  config <- get_config()
  svc <- .neptune$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.neptune$operations$promote_read_replica_db_cluster <- neptune_promote_read_replica_db_cluster

#' You might need to reboot your DB instance, usually for maintenance
#' reasons
#'
#' @description
#' You might need to reboot your DB instance, usually for maintenance reasons. For example, if you make certain modifications, or if you change the DB parameter group associated with the DB instance, you must reboot the instance for the changes to take effect.
#'
#' See [https://www.paws-r-sdk.com/docs/neptune_reboot_db_instance/](https://www.paws-r-sdk.com/docs/neptune_reboot_db_instance/) for full documentation.
#'
#' @param DBInstanceIdentifier &#91;required&#93; The DB instance identifier. This parameter is stored as a lowercase
#' string.
#' 
#' Constraints:
#' 
#' -   Must match the identifier of an existing DBInstance.
#' @param ForceFailover When `true`, the reboot is conducted through a MultiAZ failover.
#' 
#' Constraint: You can't specify `true` if the instance is not configured
#' for MultiAZ.
#'
#' @keywords internal
#'
#' @rdname neptune_reboot_db_instance
neptune_reboot_db_instance <- function(DBInstanceIdentifier, ForceFailover = NULL) {
  op <- new_operation(
    name = "RebootDBInstance",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .neptune$reboot_db_instance_input(DBInstanceIdentifier = DBInstanceIdentifier, ForceFailover = ForceFailover)
  output <- .neptune$reboot_db_instance_output()
  config <- get_config()
  svc <- .neptune$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.neptune$operations$reboot_db_instance <- neptune_reboot_db_instance

#' Detaches a Neptune DB cluster from a Neptune global database
#'
#' @description
#' Detaches a Neptune DB cluster from a Neptune global database. A secondary cluster becomes a normal standalone cluster with read-write capability instead of being read-only, and no longer receives data from a the primary cluster.
#'
#' See [https://www.paws-r-sdk.com/docs/neptune_remove_from_global_cluster/](https://www.paws-r-sdk.com/docs/neptune_remove_from_global_cluster/) for full documentation.
#'
#' @param GlobalClusterIdentifier &#91;required&#93; The identifier of the Neptune global database from which to detach the
#' specified Neptune DB cluster.
#' @param DbClusterIdentifier &#91;required&#93; The Amazon Resource Name (ARN) identifying the cluster to be detached
#' from the Neptune global database cluster.
#'
#' @keywords internal
#'
#' @rdname neptune_remove_from_global_cluster
neptune_remove_from_global_cluster <- function(GlobalClusterIdentifier, DbClusterIdentifier) {
  op <- new_operation(
    name = "RemoveFromGlobalCluster",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .neptune$remove_from_global_cluster_input(GlobalClusterIdentifier = GlobalClusterIdentifier, DbClusterIdentifier = DbClusterIdentifier)
  output <- .neptune$remove_from_global_cluster_output()
  config <- get_config()
  svc <- .neptune$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.neptune$operations$remove_from_global_cluster <- neptune_remove_from_global_cluster

#' Disassociates an Identity and Access Management (IAM) role from a DB
#' cluster
#'
#' @description
#' Disassociates an Identity and Access Management (IAM) role from a DB cluster.
#'
#' See [https://www.paws-r-sdk.com/docs/neptune_remove_role_from_db_cluster/](https://www.paws-r-sdk.com/docs/neptune_remove_role_from_db_cluster/) for full documentation.
#'
#' @param DBClusterIdentifier &#91;required&#93; The name of the DB cluster to disassociate the IAM role from.
#' @param RoleArn &#91;required&#93; The Amazon Resource Name (ARN) of the IAM role to disassociate from the
#' DB cluster, for example
#' `arn:aws:iam::123456789012:role/NeptuneAccessRole`.
#' @param FeatureName The name of the feature for the DB cluster that the IAM role is to be
#' disassociated from. For the list of supported feature names, see
#' [`describe_db_engine_versions`][neptune_describe_db_engine_versions].
#'
#' @keywords internal
#'
#' @rdname neptune_remove_role_from_db_cluster
neptune_remove_role_from_db_cluster <- function(DBClusterIdentifier, RoleArn, FeatureName = NULL) {
  op <- new_operation(
    name = "RemoveRoleFromDBCluster",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .neptune$remove_role_from_db_cluster_input(DBClusterIdentifier = DBClusterIdentifier, RoleArn = RoleArn, FeatureName = FeatureName)
  output <- .neptune$remove_role_from_db_cluster_output()
  config <- get_config()
  svc <- .neptune$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.neptune$operations$remove_role_from_db_cluster <- neptune_remove_role_from_db_cluster

#' Removes a source identifier from an existing event notification
#' subscription
#'
#' @description
#' Removes a source identifier from an existing event notification subscription.
#'
#' See [https://www.paws-r-sdk.com/docs/neptune_remove_source_identifier_from_subscription/](https://www.paws-r-sdk.com/docs/neptune_remove_source_identifier_from_subscription/) for full documentation.
#'
#' @param SubscriptionName &#91;required&#93; The name of the event notification subscription you want to remove a
#' source identifier from.
#' @param SourceIdentifier &#91;required&#93; The source identifier to be removed from the subscription, such as the
#' **DB instance identifier** for a DB instance or the name of a security
#' group.
#'
#' @keywords internal
#'
#' @rdname neptune_remove_source_identifier_from_subscription
neptune_remove_source_identifier_from_subscription <- function(SubscriptionName, SourceIdentifier) {
  op <- new_operation(
    name = "RemoveSourceIdentifierFromSubscription",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .neptune$remove_source_identifier_from_subscription_input(SubscriptionName = SubscriptionName, SourceIdentifier = SourceIdentifier)
  output <- .neptune$remove_source_identifier_from_subscription_output()
  config <- get_config()
  svc <- .neptune$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.neptune$operations$remove_source_identifier_from_subscription <- neptune_remove_source_identifier_from_subscription

#' Removes metadata tags from an Amazon Neptune resource
#'
#' @description
#' Removes metadata tags from an Amazon Neptune resource.
#'
#' See [https://www.paws-r-sdk.com/docs/neptune_remove_tags_from_resource/](https://www.paws-r-sdk.com/docs/neptune_remove_tags_from_resource/) for full documentation.
#'
#' @param ResourceName &#91;required&#93; The Amazon Neptune resource that the tags are removed from. This value
#' is an Amazon Resource Name (ARN). For information about creating an ARN,
#' see [Constructing an Amazon Resource Name
#' (ARN)](https://docs.aws.amazon.com/neptune/latest/userguide/#tagging.ARN.Constructing).
#' @param TagKeys &#91;required&#93; The tag key (name) of the tag to be removed.
#'
#' @keywords internal
#'
#' @rdname neptune_remove_tags_from_resource
neptune_remove_tags_from_resource <- function(ResourceName, TagKeys) {
  op <- new_operation(
    name = "RemoveTagsFromResource",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .neptune$remove_tags_from_resource_input(ResourceName = ResourceName, TagKeys = TagKeys)
  output <- .neptune$remove_tags_from_resource_output()
  config <- get_config()
  svc <- .neptune$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.neptune$operations$remove_tags_from_resource <- neptune_remove_tags_from_resource

#' Modifies the parameters of a DB cluster parameter group to the default
#' value
#'
#' @description
#' Modifies the parameters of a DB cluster parameter group to the default value. To reset specific parameters submit a list of the following: `ParameterName` and `ApplyMethod`. To reset the entire DB cluster parameter group, specify the `DBClusterParameterGroupName` and `ResetAllParameters` parameters.
#'
#' See [https://www.paws-r-sdk.com/docs/neptune_reset_db_cluster_parameter_group/](https://www.paws-r-sdk.com/docs/neptune_reset_db_cluster_parameter_group/) for full documentation.
#'
#' @param DBClusterParameterGroupName &#91;required&#93; The name of the DB cluster parameter group to reset.
#' @param ResetAllParameters A value that is set to `true` to reset all parameters in the DB cluster
#' parameter group to their default values, and `false` otherwise. You
#' can't use this parameter if there is a list of parameter names specified
#' for the `Parameters` parameter.
#' @param Parameters A list of parameter names in the DB cluster parameter group to reset to
#' the default values. You can't use this parameter if the
#' `ResetAllParameters` parameter is set to `true`.
#'
#' @keywords internal
#'
#' @rdname neptune_reset_db_cluster_parameter_group
neptune_reset_db_cluster_parameter_group <- function(DBClusterParameterGroupName, ResetAllParameters = NULL, Parameters = NULL) {
  op <- new_operation(
    name = "ResetDBClusterParameterGroup",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .neptune$reset_db_cluster_parameter_group_input(DBClusterParameterGroupName = DBClusterParameterGroupName, ResetAllParameters = ResetAllParameters, Parameters = Parameters)
  output <- .neptune$reset_db_cluster_parameter_group_output()
  config <- get_config()
  svc <- .neptune$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.neptune$operations$reset_db_cluster_parameter_group <- neptune_reset_db_cluster_parameter_group

#' Modifies the parameters of a DB parameter group to the engine/system
#' default value
#'
#' @description
#' Modifies the parameters of a DB parameter group to the engine/system default value. To reset specific parameters, provide a list of the following: `ParameterName` and `ApplyMethod`. To reset the entire DB parameter group, specify the `DBParameterGroup` name and `ResetAllParameters` parameters. When resetting the entire group, dynamic parameters are updated immediately and static parameters are set to `pending-reboot` to take effect on the next DB instance restart or [`reboot_db_instance`][neptune_reboot_db_instance] request.
#'
#' See [https://www.paws-r-sdk.com/docs/neptune_reset_db_parameter_group/](https://www.paws-r-sdk.com/docs/neptune_reset_db_parameter_group/) for full documentation.
#'
#' @param DBParameterGroupName &#91;required&#93; The name of the DB parameter group.
#' 
#' Constraints:
#' 
#' -   Must match the name of an existing DBParameterGroup.
#' @param ResetAllParameters Specifies whether (`true`) or not (`false`) to reset all parameters in
#' the DB parameter group to default values.
#' 
#' Default: `true`
#' @param Parameters To reset the entire DB parameter group, specify the `DBParameterGroup`
#' name and `ResetAllParameters` parameters. To reset specific parameters,
#' provide a list of the following: `ParameterName` and `ApplyMethod`. A
#' maximum of 20 parameters can be modified in a single request.
#' 
#' Valid Values (for Apply method): `pending-reboot`
#'
#' @keywords internal
#'
#' @rdname neptune_reset_db_parameter_group
neptune_reset_db_parameter_group <- function(DBParameterGroupName, ResetAllParameters = NULL, Parameters = NULL) {
  op <- new_operation(
    name = "ResetDBParameterGroup",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .neptune$reset_db_parameter_group_input(DBParameterGroupName = DBParameterGroupName, ResetAllParameters = ResetAllParameters, Parameters = Parameters)
  output <- .neptune$reset_db_parameter_group_output()
  config <- get_config()
  svc <- .neptune$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.neptune$operations$reset_db_parameter_group <- neptune_reset_db_parameter_group

#' Creates a new DB cluster from a DB snapshot or DB cluster snapshot
#'
#' @description
#' Creates a new DB cluster from a DB snapshot or DB cluster snapshot.
#'
#' See [https://www.paws-r-sdk.com/docs/neptune_restore_db_cluster_from_snapshot/](https://www.paws-r-sdk.com/docs/neptune_restore_db_cluster_from_snapshot/) for full documentation.
#'
#' @param AvailabilityZones Provides the list of EC2 Availability Zones that instances in the
#' restored DB cluster can be created in.
#' @param DBClusterIdentifier &#91;required&#93; The name of the DB cluster to create from the DB snapshot or DB cluster
#' snapshot. This parameter isn't case-sensitive.
#' 
#' Constraints:
#' 
#' -   Must contain from 1 to 63 letters, numbers, or hyphens
#' 
#' -   First character must be a letter
#' 
#' -   Cannot end with a hyphen or contain two consecutive hyphens
#' 
#' Example: `my-snapshot-id`
#' @param SnapshotIdentifier &#91;required&#93; The identifier for the DB snapshot or DB cluster snapshot to restore
#' from.
#' 
#' You can use either the name or the Amazon Resource Name (ARN) to specify
#' a DB cluster snapshot. However, you can use only the ARN to specify a DB
#' snapshot.
#' 
#' Constraints:
#' 
#' -   Must match the identifier of an existing Snapshot.
#' @param Engine &#91;required&#93; The database engine to use for the new DB cluster.
#' 
#' Default: The same as source
#' 
#' Constraint: Must be compatible with the engine of the source
#' @param EngineVersion The version of the database engine to use for the new DB cluster.
#' @param Port The port number on which the new DB cluster accepts connections.
#' 
#' Constraints: Value must be `1150-65535`
#' 
#' Default: The same port as the original DB cluster.
#' @param DBSubnetGroupName The name of the DB subnet group to use for the new DB cluster.
#' 
#' Constraints: If supplied, must match the name of an existing
#' DBSubnetGroup.
#' 
#' Example: `mySubnetgroup`
#' @param DatabaseName Not supported.
#' @param OptionGroupName *(Not supported by Neptune)*
#' @param VpcSecurityGroupIds A list of VPC security groups that the new DB cluster will belong to.
#' @param Tags The tags to be assigned to the restored DB cluster.
#' @param KmsKeyId The Amazon KMS key identifier to use when restoring an encrypted DB
#' cluster from a DB snapshot or DB cluster snapshot.
#' 
#' The KMS key identifier is the Amazon Resource Name (ARN) for the KMS
#' encryption key. If you are restoring a DB cluster with the same Amazon
#' account that owns the KMS encryption key used to encrypt the new DB
#' cluster, then you can use the KMS key alias instead of the ARN for the
#' KMS encryption key.
#' 
#' If you do not specify a value for the `KmsKeyId` parameter, then the
#' following will occur:
#' 
#' -   If the DB snapshot or DB cluster snapshot in `SnapshotIdentifier` is
#'     encrypted, then the restored DB cluster is encrypted using the KMS
#'     key that was used to encrypt the DB snapshot or DB cluster snapshot.
#' 
#' -   If the DB snapshot or DB cluster snapshot in `SnapshotIdentifier` is
#'     not encrypted, then the restored DB cluster is not encrypted.
#' @param EnableIAMDatabaseAuthentication True to enable mapping of Amazon Identity and Access Management (IAM)
#' accounts to database accounts, and otherwise false.
#' 
#' Default: `false`
#' @param EnableCloudwatchLogsExports The list of logs that the restored DB cluster is to export to Amazon
#' CloudWatch Logs.
#' @param DBClusterParameterGroupName The name of the DB cluster parameter group to associate with the new DB
#' cluster.
#' 
#' Constraints:
#' 
#' -   If supplied, must match the name of an existing
#'     DBClusterParameterGroup.
#' @param DeletionProtection A value that indicates whether the DB cluster has deletion protection
#' enabled. The database can't be deleted when deletion protection is
#' enabled. By default, deletion protection is disabled.
#' @param CopyTagsToSnapshot *If set to true, tags are copied to any snapshot of the restored DB
#' cluster that is created.*
#' @param ServerlessV2ScalingConfiguration Contains the scaling configuration of a Neptune Serverless DB cluster.
#' 
#' For more information, see [Using Amazon Neptune
#' Serverless](https://docs.aws.amazon.com/neptune/latest/userguide/neptune-serverless-using.html)
#' in the *Amazon Neptune User Guide*.
#' @param StorageType Specifies the storage type to be associated with the DB cluster.
#' 
#' Valid values: `standard`, `iopt1`
#' 
#' Default: `standard`
#'
#' @keywords internal
#'
#' @rdname neptune_restore_db_cluster_from_snapshot
neptune_restore_db_cluster_from_snapshot <- function(AvailabilityZones = NULL, DBClusterIdentifier, SnapshotIdentifier, Engine, EngineVersion = NULL, Port = NULL, DBSubnetGroupName = NULL, DatabaseName = NULL, OptionGroupName = NULL, VpcSecurityGroupIds = NULL, Tags = NULL, KmsKeyId = NULL, EnableIAMDatabaseAuthentication = NULL, EnableCloudwatchLogsExports = NULL, DBClusterParameterGroupName = NULL, DeletionProtection = NULL, CopyTagsToSnapshot = NULL, ServerlessV2ScalingConfiguration = NULL, StorageType = NULL) {
  op <- new_operation(
    name = "RestoreDBClusterFromSnapshot",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .neptune$restore_db_cluster_from_snapshot_input(AvailabilityZones = AvailabilityZones, DBClusterIdentifier = DBClusterIdentifier, SnapshotIdentifier = SnapshotIdentifier, Engine = Engine, EngineVersion = EngineVersion, Port = Port, DBSubnetGroupName = DBSubnetGroupName, DatabaseName = DatabaseName, OptionGroupName = OptionGroupName, VpcSecurityGroupIds = VpcSecurityGroupIds, Tags = Tags, KmsKeyId = KmsKeyId, EnableIAMDatabaseAuthentication = EnableIAMDatabaseAuthentication, EnableCloudwatchLogsExports = EnableCloudwatchLogsExports, DBClusterParameterGroupName = DBClusterParameterGroupName, DeletionProtection = DeletionProtection, CopyTagsToSnapshot = CopyTagsToSnapshot, ServerlessV2ScalingConfiguration = ServerlessV2ScalingConfiguration, StorageType = StorageType)
  output <- .neptune$restore_db_cluster_from_snapshot_output()
  config <- get_config()
  svc <- .neptune$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.neptune$operations$restore_db_cluster_from_snapshot <- neptune_restore_db_cluster_from_snapshot

#' Restores a DB cluster to an arbitrary point in time
#'
#' @description
#' Restores a DB cluster to an arbitrary point in time. Users can restore to any point in time before `LatestRestorableTime` for up to `BackupRetentionPeriod` days. The target DB cluster is created from the source DB cluster with the same configuration as the original DB cluster, except that the new DB cluster is created with the default DB security group.
#'
#' See [https://www.paws-r-sdk.com/docs/neptune_restore_db_cluster_to_point_in_time/](https://www.paws-r-sdk.com/docs/neptune_restore_db_cluster_to_point_in_time/) for full documentation.
#'
#' @param DBClusterIdentifier &#91;required&#93; The name of the new DB cluster to be created.
#' 
#' Constraints:
#' 
#' -   Must contain from 1 to 63 letters, numbers, or hyphens
#' 
#' -   First character must be a letter
#' 
#' -   Cannot end with a hyphen or contain two consecutive hyphens
#' @param RestoreType The type of restore to be performed. You can specify one of the
#' following values:
#' 
#' -   `full-copy` - The new DB cluster is restored as a full copy of the
#'     source DB cluster.
#' 
#' -   `copy-on-write` - The new DB cluster is restored as a clone of the
#'     source DB cluster.
#' 
#' If you don't specify a `RestoreType` value, then the new DB cluster is
#' restored as a full copy of the source DB cluster.
#' @param SourceDBClusterIdentifier &#91;required&#93; The identifier of the source DB cluster from which to restore.
#' 
#' Constraints:
#' 
#' -   Must match the identifier of an existing DBCluster.
#' @param RestoreToTime The date and time to restore the DB cluster to.
#' 
#' Valid Values: Value must be a time in Universal Coordinated Time (UTC)
#' format
#' 
#' Constraints:
#' 
#' -   Must be before the latest restorable time for the DB instance
#' 
#' -   Must be specified if `UseLatestRestorableTime` parameter is not
#'     provided
#' 
#' -   Cannot be specified if `UseLatestRestorableTime` parameter is true
#' 
#' -   Cannot be specified if `RestoreType` parameter is `copy-on-write`
#' 
#' Example: `2015-03-07T23:45:00Z`
#' @param UseLatestRestorableTime A value that is set to `true` to restore the DB cluster to the latest
#' restorable backup time, and `false` otherwise.
#' 
#' Default: `false`
#' 
#' Constraints: Cannot be specified if `RestoreToTime` parameter is
#' provided.
#' @param Port The port number on which the new DB cluster accepts connections.
#' 
#' Constraints: Value must be `1150-65535`
#' 
#' Default: The same port as the original DB cluster.
#' @param DBSubnetGroupName The DB subnet group name to use for the new DB cluster.
#' 
#' Constraints: If supplied, must match the name of an existing
#' DBSubnetGroup.
#' 
#' Example: `mySubnetgroup`
#' @param OptionGroupName *(Not supported by Neptune)*
#' @param VpcSecurityGroupIds A list of VPC security groups that the new DB cluster belongs to.
#' @param Tags The tags to be applied to the restored DB cluster.
#' @param KmsKeyId The Amazon KMS key identifier to use when restoring an encrypted DB
#' cluster from an encrypted DB cluster.
#' 
#' The KMS key identifier is the Amazon Resource Name (ARN) for the KMS
#' encryption key. If you are restoring a DB cluster with the same Amazon
#' account that owns the KMS encryption key used to encrypt the new DB
#' cluster, then you can use the KMS key alias instead of the ARN for the
#' KMS encryption key.
#' 
#' You can restore to a new DB cluster and encrypt the new DB cluster with
#' a KMS key that is different than the KMS key used to encrypt the source
#' DB cluster. The new DB cluster is encrypted with the KMS key identified
#' by the `KmsKeyId` parameter.
#' 
#' If you do not specify a value for the `KmsKeyId` parameter, then the
#' following will occur:
#' 
#' -   If the DB cluster is encrypted, then the restored DB cluster is
#'     encrypted using the KMS key that was used to encrypt the source DB
#'     cluster.
#' 
#' -   If the DB cluster is not encrypted, then the restored DB cluster is
#'     not encrypted.
#' 
#' If `DBClusterIdentifier` refers to a DB cluster that is not encrypted,
#' then the restore request is rejected.
#' @param EnableIAMDatabaseAuthentication True to enable mapping of Amazon Identity and Access Management (IAM)
#' accounts to database accounts, and otherwise false.
#' 
#' Default: `false`
#' @param EnableCloudwatchLogsExports The list of logs that the restored DB cluster is to export to CloudWatch
#' Logs.
#' @param DBClusterParameterGroupName The name of the DB cluster parameter group to associate with the new DB
#' cluster.
#' 
#' Constraints:
#' 
#' -   If supplied, must match the name of an existing
#'     DBClusterParameterGroup.
#' @param DeletionProtection A value that indicates whether the DB cluster has deletion protection
#' enabled. The database can't be deleted when deletion protection is
#' enabled. By default, deletion protection is disabled.
#' @param ServerlessV2ScalingConfiguration Contains the scaling configuration of a Neptune Serverless DB cluster.
#' 
#' For more information, see [Using Amazon Neptune
#' Serverless](https://docs.aws.amazon.com/neptune/latest/userguide/neptune-serverless-using.html)
#' in the *Amazon Neptune User Guide*.
#' @param StorageType Specifies the storage type to be associated with the DB cluster.
#' 
#' Valid values: `standard`, `iopt1`
#' 
#' Default: `standard`
#'
#' @keywords internal
#'
#' @rdname neptune_restore_db_cluster_to_point_in_time
neptune_restore_db_cluster_to_point_in_time <- function(DBClusterIdentifier, RestoreType = NULL, SourceDBClusterIdentifier, RestoreToTime = NULL, UseLatestRestorableTime = NULL, Port = NULL, DBSubnetGroupName = NULL, OptionGroupName = NULL, VpcSecurityGroupIds = NULL, Tags = NULL, KmsKeyId = NULL, EnableIAMDatabaseAuthentication = NULL, EnableCloudwatchLogsExports = NULL, DBClusterParameterGroupName = NULL, DeletionProtection = NULL, ServerlessV2ScalingConfiguration = NULL, StorageType = NULL) {
  op <- new_operation(
    name = "RestoreDBClusterToPointInTime",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .neptune$restore_db_cluster_to_point_in_time_input(DBClusterIdentifier = DBClusterIdentifier, RestoreType = RestoreType, SourceDBClusterIdentifier = SourceDBClusterIdentifier, RestoreToTime = RestoreToTime, UseLatestRestorableTime = UseLatestRestorableTime, Port = Port, DBSubnetGroupName = DBSubnetGroupName, OptionGroupName = OptionGroupName, VpcSecurityGroupIds = VpcSecurityGroupIds, Tags = Tags, KmsKeyId = KmsKeyId, EnableIAMDatabaseAuthentication = EnableIAMDatabaseAuthentication, EnableCloudwatchLogsExports = EnableCloudwatchLogsExports, DBClusterParameterGroupName = DBClusterParameterGroupName, DeletionProtection = DeletionProtection, ServerlessV2ScalingConfiguration = ServerlessV2ScalingConfiguration, StorageType = StorageType)
  output <- .neptune$restore_db_cluster_to_point_in_time_output()
  config <- get_config()
  svc <- .neptune$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.neptune$operations$restore_db_cluster_to_point_in_time <- neptune_restore_db_cluster_to_point_in_time

#' Starts an Amazon Neptune DB cluster that was stopped using the Amazon
#' console, the Amazon CLI stop-db-cluster command, or the StopDBCluster
#' API
#'
#' @description
#' Starts an Amazon Neptune DB cluster that was stopped using the Amazon console, the Amazon CLI stop-db-cluster command, or the StopDBCluster API.
#'
#' See [https://www.paws-r-sdk.com/docs/neptune_start_db_cluster/](https://www.paws-r-sdk.com/docs/neptune_start_db_cluster/) for full documentation.
#'
#' @param DBClusterIdentifier &#91;required&#93; The DB cluster identifier of the Neptune DB cluster to be started. This
#' parameter is stored as a lowercase string.
#'
#' @keywords internal
#'
#' @rdname neptune_start_db_cluster
neptune_start_db_cluster <- function(DBClusterIdentifier) {
  op <- new_operation(
    name = "StartDBCluster",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .neptune$start_db_cluster_input(DBClusterIdentifier = DBClusterIdentifier)
  output <- .neptune$start_db_cluster_output()
  config <- get_config()
  svc <- .neptune$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.neptune$operations$start_db_cluster <- neptune_start_db_cluster

#' Stops an Amazon Neptune DB cluster
#'
#' @description
#' Stops an Amazon Neptune DB cluster. When you stop a DB cluster, Neptune retains the DB cluster's metadata, including its endpoints and DB parameter groups.
#'
#' See [https://www.paws-r-sdk.com/docs/neptune_stop_db_cluster/](https://www.paws-r-sdk.com/docs/neptune_stop_db_cluster/) for full documentation.
#'
#' @param DBClusterIdentifier &#91;required&#93; The DB cluster identifier of the Neptune DB cluster to be stopped. This
#' parameter is stored as a lowercase string.
#'
#' @keywords internal
#'
#' @rdname neptune_stop_db_cluster
neptune_stop_db_cluster <- function(DBClusterIdentifier) {
  op <- new_operation(
    name = "StopDBCluster",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .neptune$stop_db_cluster_input(DBClusterIdentifier = DBClusterIdentifier)
  output <- .neptune$stop_db_cluster_output()
  config <- get_config()
  svc <- .neptune$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.neptune$operations$stop_db_cluster <- neptune_stop_db_cluster
